<?php

session_start();

// require '../../db.php';
require '../helper_functions/data_request.php';
require '../auth/auth_functions.php';

// --------------Need to verify all this before delete old code --------------------------------- \\
// try {
//     //code...
//     if ($_SERVER['REQUEST_METHOD'] == 'POST') {
//         $action = $_POST['action'];
    
//         switch ($action) {
//             case 'create_role':
//                 echo"creating ";
//                 $role_name = $_POST['role_name'];
//                 $stmt = $pdo->prepare("INSERT INTO roles (name) VALUES (?)");
//                 $stmt->execute([$role_name]);
//                 break;
    
//             case 'create_resource':
//                 $resource_name = $_POST['resource_name'];
//                 $stmt = $pdo->prepare("INSERT INTO resources (name) VALUES (?)");
//                 $stmt->execute([$resource_name]);
//                 break;
    
//             case 'create_role_resource':
//                 $role_id = $_POST['role_id'];
//                 $resource_id = $_POST['resource_id'];
//                 $action_id = $_POST['action_id'];
//                 $stmt = $pdo->prepare("INSERT INTO role_resources (role_id, resource_id, action_id) VALUES (?, ?, ?)");
//                 $stmt->execute([$role_id, $resource_id, $action_id]);
//                 break;
    
//             case 'update_roles':
//                 $role_id = $_POST['role_id'];
//                 $role_name = $_POST['role_name'];
//                 $stmt = $pdo->prepare("UPDATE roles SET name = ? WHERE id = ?");
//                 $stmt->execute([$role_name, $role_id]);
//                 break;
    
//             case 'delete_roles':
//                 $role_id = $_POST['role_id'];
//                 $stmt = $pdo->prepare("DELETE FROM roles WHERE id = ?");
//                 $stmt->execute([$role_id]);
//                 break;
    
//             case 'update_resource':
//                 $resource_id = $_POST['resource_id'];
//                 $resource_name = $_POST['resource_name'];
//                 $stmt = $pdo->prepare("UPDATE resources SET name = ? WHERE id = ?");
//                 $stmt->execute([$resource_name, $resource_id]);
//                 break;
    
//             case 'delete_resource':
//                 $resource_id = $_POST['resource_id'];
//                 $stmt = $pdo->prepare("DELETE FROM resources WHERE id = ?");
//                 $stmt->execute([$resource_id]);
//                 break;
    
//             case 'update_role_resources':
//                 $role_id = $_POST['role_id'];
//                 $resource_id = $_POST['resource_id'];
//                 $action_id = $_POST['action_id'];
//                 $role_id_new = $_POST['role_id_new'];
//                 $resource_id_new = $_POST['resource_id_new'];
//                 $action_id_new = $_POST['action_id_new'];
//                 $stmt = $pdo->prepare("UPDATE role_resources SET role_id = ?, resource_id = ?, action_id = ? WHERE role_id = ? AND resource_id = ? AND action_id = ?");
//                 $stmt->execute([$role_id_new, $resource_id_new, $action_id_new, $role_id, $resource_id, $action_id]);
//                 break;
    
//             case 'delete_role_resources':
//                 $role_id = $_POST['role_id'];
//                 $resource_id = $_POST['resource_id'];
//                 $action_id = $_POST['action_id'];
//                 $stmt = $pdo->prepare("DELETE FROM role_resources WHERE role_id = ? AND resource_id = ? AND action_id = ?");
//                 $stmt->execute([$role_id, $resource_id, $action_id]);
//                 break;

//             case 'signalwire_setting':
//                 $project_id = $_POST['project_id'];
//                 $space_url = $_POST['space_url'];
//                 $api_token = $_POST['api_token'];
//                 $user_id = $_POST['user_id'];
//                 $dealer_purchase_number_limit = $_POST['dealer_purchase_number_limit'];
//                 $signawire_setting_id = $_POST['signawire_setting_id'];
//                 if(!empty($signawire_setting_id)){
//                     $stmt = $pdo->prepare("UPDATE signalwire_settings SET project_id = ?, space_url = ?, api_token = ?, dealer_purchase_number_limit = ? WHERE id = ?");
//                     $stmt->execute([$project_id, $space_url, $api_token, $dealer_purchase_number_limit, $signawire_setting_id]);
//                 }
//                 else{
//                     $stmt = $pdo->prepare("INSERT INTO signalwire_settings (user_id, project_id, space_url, api_token) VALUES (?,?,?,?)");
//                     $stmt->execute([$user_id, $project_id, $space_url, $api_token]);
//                 }
//                 break;
    
//             default:
//                 echo "Invalid action.";
//                 break;
//         }
    
//         header("Location: ../admin/admin_panel.php");
//         exit;
//     }
// } catch (\Throwable $th) {
//     //throw $th;
//     echo "getting messagea of exception". $th->getMessage();
// }

try {
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        $action = $_POST['action'];
    
        switch ($action) {
            case 'create_role':
                $role_name = $_POST['role_name'];
                insertData('roles', ['name' => $role_name]);
                break;
    
            case 'create_resource':
                $resource_name = $_POST['resource_name'];
                insertData('resources', ['name' => $resource_name]);
                break;
    
            case 'create_role_resource':
                $role_id = $_POST['role_id'];
                $resource_id = $_POST['resource_id'];
                $action_id = $_POST['action_id'];
                insertData('role_resources', [
                    'role_id' => $role_id,
                    'resource_id' => $resource_id,
                    'action_id' => $action_id
                ]);
                break;
    
            case 'update_roles':
                $role_id = $_POST['role_id'];
                $role_name = $_POST['role_name'];
                updateTable('roles', ['name' => $role_name], 'id = :id', ['id' => $role_id]);
                break;
    
            case 'delete_roles':
                $role_id = $_POST['role_id'];
                deleteData('roles', 'id', $role_id);
                break;
    
            case 'update_resource':
                $resource_id = $_POST['resource_id'];
                $resource_name = $_POST['resource_name'];
                updateTable('resources', ['name' => $resource_name], 'id = :id', ['id' => $resource_id]);
                break;
    
            case 'delete_resource':
                $resource_id = $_POST['resource_id'];
                deleteData('resources', 'id', $resource_id);
                break;
    
            case 'update_role_resources':
                $role_id = $_POST['role_id'];
                $resource_id = $_POST['resource_id'];
                $action_id = $_POST['action_id'];
                $role_id_new = $_POST['role_id_new'];
                $resource_id_new = $_POST['resource_id_new'];
                $action_id_new = $_POST['action_id_new'];
                updateTable('role_resources', 
                    [
                        'role_id' => $role_id_new,
                        'resource_id' => $resource_id_new,
                        'action_id' => $action_id_new
                    ],
                    'role_id = :role_id AND resource_id = :resource_id AND action_id = :action_id',
                    ['role_id' => $role_id, 'resource_id' => $resource_id, 'action_id' => $action_id]
                );
                break;
    
            case 'delete_role_resources':
                $role_id = $_POST['role_id'];
                $resource_id = $_POST['resource_id'];
                $action_id = $_POST['action_id'];
                deleteData('role_resources', 'role_id = :role_id AND resource_id = :resource_id AND action_id = :action_id', [
                    'role_id' => $role_id,
                    'resource_id' => $resource_id,
                    'action_id' => $action_id
                ]);
                break;

            case 'signalwire_setting':
                $project_id = $_POST['project_id'];
                $space_url = $_POST['space_url'];
                $api_token = $_POST['api_token'];
                $user_id = $_POST['user_id'];
                $dealer_purchase_number_limit = $_POST['dealer_purchase_number_limit'];
                $signawire_setting_id = $_POST['signawire_setting_id'];

                if (!empty($signawire_setting_id)) {
                    updateTable('signalwire_settings', 
                        [
                            'project_id' => $project_id,
                            'space_url' => $space_url,
                            'api_token' => $api_token,
                            'dealer_purchase_number_limit' => $dealer_purchase_number_limit
                        ], 
                        'id = :id', 
                        ['id' => $signawire_setting_id]
                    );
                } else {
                    insertData('signalwire_settings', [
                        'user_id' => $user_id,
                        'project_id' => $project_id,
                        'space_url' => $space_url,
                        'api_token' => $api_token
                    ]);
                }
                break;
            case 'stream_url':
                $url_id = $_POST['url_id'];
                $stream_url = $_POST['stream_url'];
                $user_id = $_POST['user_id'];

                if (!empty($url_id)) {
                    updateTable('stream_url', 
                        [
                            'user_id' => $user_id,
                            'stream_url' => $stream_url,
                        ], 
                        'id = :id', 
                        ['id' => $url_id]
                    );
                } else {
                    insertData('stream_url', [
                        'user_id' => $user_id,
                        'stream_url' => $stream_url,
                    ]);
                }
                break;

            case 'ftp_url':
                $ftp_label = $_POST['ftp_label'];
                $ftp_url = $_POST['ftp_url'];
                $ftp_port = $_POST['ftp_port'];
                $user_id = $_POST['user_id'];

                insertData('ftp_servers', [
                    'label' => $ftp_label,
                    'url' => $ftp_url,
                    'port' => $ftp_port,
                ]);

                break;

            case 'update_ftp':
                $ftp_label = $_POST['ftp_label'];
                $ftp_url = $_POST['ftp_url'];
                $ftp_port = $_POST['ftp_port'];
                $ftp_active = $_POST['ftp_active'];
                $url_id = $_POST['url_id'];

                updateTable('ftp_servers', 
                    [
                        'label' => $ftp_label,
                        'url' => $ftp_url,
                        'port' => $ftp_port,
                        'active' => $ftp_active,
                    ], 
                    'id = :id', 
                    ['id' => $url_id]
                );

                break;

            default:
                echo "Invalid action.";
                break;
        }
    
        if (!headers_sent()) {
            header("Location: ../admin/admin_panel.php");
        }
        exit;
    }
} catch (Throwable $th) {
    error_log("Exception caught in admin.php: " . $th->getMessage());
    echo "An unexpected error occurred. Please contact support.";
}
