<?php
session_start();

require '../../db.php';
require '../auth/auth_functions.php';

if (!currentUserHasAccess($pdo, 'admin_setup', 'write')) {
    if (isset($_SESSION['userid'])) {
        echo "Access denied! Please wait while being Re-Directed.";
        echo '<meta http-equiv="refresh" content="2">';
        exit();
    }else {
        if (!headers_sent()) {
            header("Location: ../../login.php");
        }
        exit();
    }
}
?>

<style>

    .col-9 {
        -ms-flex: 0 0 100%;
        flex: 0 0 100%;
        max-width: 100%;
        position:relative;
        width:100%;
        padding-right:15px;
        padding-left:15px;
    }

</style>

    <button type="button" class="btn btn-block btn-dark" data-toggle="modal" data-backdrop="static" data-keyboard="false" data-target="#adminmodal" style="margin:1rem 0 1rem .5rem;width:auto;">+ Administrator</button>
    <div class="col-9">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Admin Setup Area</h3>
                <div class="card-tools">
                <div class="input-group input-group-sm" style="width: 300px;">
                    <input type="text" id="searchAdminsInput" onkeyup="searchTable('adminsTable', 'searchAdminsInput')" class="form-control float-right" placeholder="Search Users">
                    <div class="input-group-append">
                        <button type="button" class="btn btn-default">
                            <i class="fas fa-search"></i>
                        </button>
                    </div>
                </div>
                </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover table-bordered" id="adminsTable">
                        <thead>
                            <tr>
                                <th>Company</th>
                                <th>Name</th>
                                <th>Role</th>
                                <th>Email</th>
                                <th>Slots</th>
                                <th>Used</th>
                                <th>Date Created</th>
                                <th>ID</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody id="admintble">
                        </tbody>
                    </table>
                </div>
            </div>
            <!-- /.card-body -->
        </div>
        <!-- /.card -->
    </div>
     <!-- Modal Start -->
    <div class="modal fade" id="adminmodal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalCenterTitle">Add New Administrator</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="inviteA" action="include/admin/admin_db.php" method="post">
                        <div class="input-group mb-3">
                            <input type="text" id="companyname" name="companyname" class="form-control" title="Comapny Name" placeholder="Company Name" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card" title="Email Address"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="email" id="email" name="email" class="form-control" title="Email Address" placeholder="Email Address" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-envelope" title="Email Address"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="number" id="initialslots" name="initialslots" class="form-control" title="Initial Slots" placeholder="Initial Slots" required">
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-building" title="Initial Slots"></span>
                                </div>
                            </div>
                        </div>
                        
                        <button type="submit" name="submitnewadmin" class="btn btn-primary btn-block">Send Invite</button>
                    </form>

                </div> 
            </div>
        </div>
    </div>

    <!-- Update Admin Modal -->

    <div class="modal fade" id="updateadminmodal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalCenterTitle">Update Admin</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="updateAdmin" method="post" action="include/admin/admin_db.php" onsubmit="confirmAdminUpdate(event);">
                        <div class="input-group mb-3">
                            <input type="text" id="companyname" name="companyname" class="form-control" title="Comapny Name" placeholder="Company Name" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card" title="Company Name"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="text" id="aFname" name="aFname" class="form-control" title="First Name" placeholder="First Name" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card" title="First Name"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="text" id="aLname" name="aLname" class="form-control" title="Last Name" placeholder="Last Name" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card" title="Last Name"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="email" id="email" name="email" class="form-control" title="Email Address" placeholder="Email Address" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-envelope" title="Email Address"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="number" id="dealerslots" name="dealerslots" class="form-control" title="Slots" placeholder="Slots" disabled>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-building" title="Initial Slots"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="number" id="dealerUslots" name="dealerUslots" class="form-control" title="Slots Used" placeholder="Slots Used" disabled>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-building" title="Initial Slots"></span>
                                </div>
                            </div>
                        </div>
                        <input type="submit" name="submit" class="btn btn-primary btn-block" value="Update Admin">
                    </form>
                </div> 
            </div>
        </div>
    </div>