<?php
session_start();

require '../../db.php';
require '../auth/auth_functions.php';

if (!currentUserHasAccess($pdo, 'dealer_setup', 'write')) {
    if (isset($_SESSION['userid'])) {
        echo "Access denied! Please wait while being Re-Directed.";
        echo '<meta http-equiv="refresh" content="2">';
        exit();
    }else {
        header("Location: ../../login.php");
        exit();
    }
}
?>

<style>

    .col-9 {
        -ms-flex: 0 0 100%;
        flex: 0 0 100%;
        max-width: 100%;
        position:relative;
        width:100%;
        padding-right:15px;
        padding-left:15px;
    }

</style>

    <button type="button" class="btn btn-block btn-dark" data-toggle="modal" data-backdrop="static" data-keyboard="false" data-target="#dealermodal" style="margin:1rem 0 1rem .5rem;width:auto;">+ Add Dealer</button>
    <div class="col-9">
        <div class="card">
            <h4 class="alert alert-success" id="dealer_setup_success_message" style="display: none;"></h4>
            <div class="card-header">
                <h3 class="card-title">Dealer Setup Area</h3>
                <div class="card-tools">
                <div class="input-group input-group-sm" style="width: 300px;">
                    <input type="text" id="searchDealersInput" onkeyup="searchTable('dealersTable', 'searchDealersInput')" class="form-control float-right" placeholder="Search Delaer">
                    <div class="input-group-append">
                        <button type="button" class="btn btn-default">
                            <i class="fas fa-search"></i>
                        </button>
                    </div>
                </div>
                </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
                <div class="">
                    <table class="table table-hover table-bordered" id="dealersTable">
                        <thead>
                            <tr>
                                <th>Logo</th>
                                <th>Company</th>
                                <th>Name</th>
                                <th>Role</th>
                                <th>Email</th>
                                <th>Slots</th>
                                <th>Used</th>
                                <th>Date Created</th>
                                <th>ID</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody id="dealertble">
                        </tbody>
                    </table>
                </div>
            </div>
            <!-- /.card-body -->
        </div>
        <!-- /.card -->
    </div>
     <!-- Modal Start -->
    <div class="modal fade" id="dealermodal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalCenterTitle">Add New Dealer</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="inviteD" action="include/admin/dealer_db.php" method="post" enctype="multipart/form-data">
                        <div class="input-group mb-3">
                            <input type="text" id="companyname" name="companyname" class="form-control" title="Comapny Name" placeholder="Company Name" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card" title="Email Address"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="email" id="email" name="email" class="form-control" title="Email Address" placeholder="Email Address" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-envelope" title="Email Address"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="number" id="initialslots" name="initialslots" class="form-control" title="Initial Slots" placeholder="Initial Slots" required">
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-building" title="Initial Slots"></span>
                                </div>
                            </div>
                        </div>
                        <button type="submit" name="submitnewdealer" class="btn btn-primary btn-block">Send Invite</button>

                    </form>
                </div> 
            </div>
        </div>
    </div>

    <div class="modal fade" id="updatedealermodal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalCenterTitle">Update Dealer</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="updateDealer" method="post" action="include/admin/dealer_db.php" onsubmit="confirmDealerUpdate(event);" enctype="multipart/form-data">
                        <div class="d-flex align-items-center mb-2">
                            <div class="door_images dealer_logo showHide"><img id="dealer_logo"
                                    class="w-full h-full object-contain rounded-full"
                                    src="" alt="selected image">
                            </div>
                            <div class="ml-2">
                                <div class="text-center mb-2">
                                    <label for="dealerLogo" class="form-label"><small class="text-muted">(Dealer Logo Max file size: 4MB)</small></label>
                                </div>
                                <input type="file" id="dealerLogo" name="dealer_logo" onchange="onFileChange(event, 'dealer_logo')" accept="image/*" class="hidden" />
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="text" id="companyname" name="companyname" class="form-control" title="Comapny Name" placeholder="Company Name" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card" title="Company Name"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="text" id="dFname" name="dFname" class="form-control" title="First Name" placeholder="First Name" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card" title="First Name"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="text" id="dLname" name="dLname" class="form-control" title="Last Name" placeholder="Last Name" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card" title="Last Name"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="email" id="email" name="email" class="form-control" title="Email Address" placeholder="Email Address" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-envelope" title="Email Address"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="number" id="dealerslots" name="dealerslots" class="form-control" title="Slots" placeholder="Slots" disabled>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-building" title="Initial Slots"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="number" id="dealerUslots" name="dealerUslots" class="form-control" title="Slots Used" placeholder="Slots Used" disabled>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-building" title="Initial Slots"></span>
                                </div>
                            </div>
                        </div>
                        <input type="submit" name="submit" class="btn btn-primary btn-block" value="Update Dealer">
                    </form>
                </div> 
            </div>
        </div>
    </div>

    <div class="modal fade" id="dealer_signal_setting_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Dealer VOIP Setting</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <input type="hidden" name="dealer_signal_setting_id" id="dealer_signal_setting_id">
                <div class="modal-body">
                    
                        <div class="form-group">
                            <label>Project ID</label>
                            <input type="text" name="dealer_sg_project_id" id="dealer_sg_project_id" class="form-control" >
                        </div>
                        <div class="form-group">
                            <label>Space URL</label>
                            <input type="text" name="dealer_sg_space_url" id="dealer_sg_space_url" class="form-control" >
                        </div>
                        <div class="form-group">
                            <label>API Token</label>
                            <input type="text" name="dealer_sg_api_token" id="dealer_sg_api_token" class="form-control" >
                        </div>
                        <div class="form-group">
                            <label>Number Buy Limit</label>
                            <input type="number" name="dealer_sg_number_buy_limit" id="dealer_sg_number_buy_limit" class="form-control" >
                        </div>
                        <div class="modal-footer">
                            <button type="button" name="assign" onclick="assignDealerSgData()" class="btn btn-primary">Add</button>
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        </div>
                    </form>  
                </div> 
            </div>
        </div>
    </div>

    <div class="modal fade" id="billingmodal" tabindex="-1" role="dialog" aria-labelledby="billingmodalTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="billingmodalTitle">Billing Info</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="include/admin/dealer_db.php" method="post">
                        <div class="input-group mb-3">
                            <input type="text" id="bconame" name="bconame" class="form-control" title="Company Name" placeholder="Company Name" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card" title="Company Name"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="text" id="billingaddress" name="billingaddress" class="form-control" title="Street Address" placeholder="Street Address" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-map-location-dot" title="Street Address"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="text" id="billingapt" name="billingapt" class="form-control" title="Apartment/Suite" placeholder="Apartment/Suite">
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-map-location-dot" title="Apartment/Suite"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="text" id="billingcity" name="billingcity" class="form-control" title="City" placeholder="City" required>
                            <div class="input-group-append">
                                <select name="billingstate" class="form-control select2bs4" style="width: 100%;" title="State" required>
                                        <option value="" selected="selected">Select a State</option>
                                        <option value="AL">Alabama</option>
                                        <option value="AK">Alaska</option>
                                        <option value="AZ">Arizona</option>
                                        <option value="AR">Arkansas</option>
                                        <option value="CA">California</option>
                                        <option value="CO">Colorado</option>
                                        <option value="CT">Connecticut</option>
                                        <option value="DE">Delaware</option>
                                        <option value="DC">District Of Columbia</option>
                                        <option value="FL">Florida</option>
                                        <option value="GA">Georgia</option>
                                        <option value="HI">Hawaii</option>
                                        <option value="ID">Idaho</option>
                                        <option value="IL">Illinois</option>
                                        <option value="IN">Indiana</option>
                                        <option value="IA">Iowa</option>
                                        <option value="KS">Kansas</option>
                                        <option value="KY">Kentucky</option>
                                        <option value="LA">Louisiana</option>
                                        <option value="ME">Maine</option>
                                        <option value="MD">Maryland</option>
                                        <option value="MA">Massachusetts</option>
                                        <option value="MI">Michigan</option>
                                        <option value="MN">Minnesota</option>
                                        <option value="MS">Mississippi</option>
                                        <option value="MO">Missouri</option>
                                        <option value="MT">Montana</option>
                                        <option value="NE">Nebraska</option>
                                        <option value="NV">Nevada</option>
                                        <option value="NH">New Hampshire</option>
                                        <option value="NJ">New Jersey</option>
                                        <option value="NM">New Mexico</option>
                                        <option value="NY">New York</option>
                                        <option value="NC">North Carolina</option>
                                        <option value="ND">North Dakota</option>
                                        <option value="OH">Ohio</option>
                                        <option value="OK">Oklahoma</option>
                                        <option value="OR">Oregon</option>
                                        <option value="PA">Pennsylvania</option>
                                        <option value="RI">Rhode Island</option>
                                        <option value="SC">South Carolina</option>
                                        <option value="SD">South Dakota</option>
                                        <option value="TN">Tennessee</option>
                                        <option value="TX">Texas</option>
                                        <option value="UT">Utah</option>
                                        <option value="VT">Vermont</option>
                                        <option value="VA">Virginia</option>
                                        <option value="WA">Washington</option>
                                        <option value="WV">West Virginia</option>
                                        <option value="WI">Wisconsin</option>
                                        <option value="WY">Wyoming</option>
                                    </select>
                            </div>
                            <input type="text" id="billingzip" name="billingzip" class="form-control" oninput="validateAndLimitInput(this)" title="ZipCode" pattern="[0-9]{5}" placeholder="ZipCode" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-map-location-dot" title="City, State and Zip"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <!-- <input type="text" name="billingcontact" class="form-control" title="Contact Name" placeholder="Contact Name"> -->
                            <input type="text" id="billingcontactphone" name="billingcontactphone" class="form-control" title="Contact Number" oninput="formatPhoneNumber(this)" onpaste="handlePaste(event)" placeholder="Contact Number">
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card" title="Contact Name and Number"></span>
                                </div>
                            </div>
                        </div>
                        <button type="submit" name="billingUpdate" class="btn btn-primary btn-block">Update Billing</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="dealer_logo_modal" tabindex="-1" role="dialog" aria-labelledby="snapImageModalTitle" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" style="width: 600px;height: 650px;" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">User Proile Image</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body text-center">
                    <img id="dealer_logo_image" src="" alt="Property" class="img-fluid" style="max-width: 100%; object-fit: contain;">
                </div>
            </div>
        </div>
    </div>