<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');

if (!isset($_SESSION['userid'])) {
    throw new Exception('Unauthorized');
}

require_once('../helper_functions/data_request.php');
include '../../db.php';
include '../auth/auth_functions.php';

$response = [];

try {
    ob_start();

    if (isset($_POST['getSettingsData']) && isset($_SESSION['userid'])) {
        if (empty($_POST['property_id'])) $_POST['property_id'] = $_SESSION['property'];
        if (empty($_POST['property_id'])) {
            sendJsonResponse(500, ["error" => 'Property id is missing']);
            exit;
        }

        $data = fetchData('live_camera_streaming_data', ['property_id' => $_POST['property_id']]);
        $login_role = fetchDataWithId("roles", $_SESSION["role"]);

        if (!empty($login_role) && $login_role['name'] == "user") {
            $global = fetchDataSingle("camera_permissions_global", ['property_id' => $_POST['property_id']]);
            $camera_permissions = fetchData("camera_permissions", ['property_id' => $_POST['property_id'], "property_user_email"=> $_SESSION["email"]]);

            $user_camera_rules = [];
            foreach ($camera_permissions as $perm) {
                $user_camera_rules[$perm['camera_id']] = (int)$perm['have_view_permission'];
            }
            $user_permitted_cameras = array_keys(
                array_filter($user_camera_rules, function($flag) {
                    return $flag === 1;
                })
            );
            if (!empty($global) && !empty($global['camera_ids'])) {
                $global_camera_ids = json_decode($global['camera_ids'], true) ?: [];
                foreach ($global_camera_ids as $camId) {
                    $camId = (int)$camId;
                    if (!array_key_exists($camId, $user_camera_rules)) {
                        $user_permitted_cameras[] = $camId;
                    }
                }
            }

            $user_permitted_cameras = array_unique($user_permitted_cameras);

            $filtered_data = [];
            // foreach ($data as $camera) {
            //     if (in_array($camera['id'], $user_permitted_cameras, true)) {
            //         $filtered_data[] = $camera;
            //     }
            // }
            $ftpServerCache = [];
            $ftpCredCache = [];

            foreach ($data as $camera) {
                if (in_array($camera['id'], $user_permitted_cameras, true)) {

                    if (!empty($camera['ftp_mode']) && $camera['ftp_mode'] === 'managed' && !empty($camera['ftp_managed_id'])) {
                        $id = $camera['ftp_managed_id'];

                        if (!isset($ftpServerCache[$id])) {
                            $ftpServerCache[$id] = fetchDataSingle('ftp_servers', ['id' => $id, 'active' => 1]);
                        }
                        $ftpServer = $ftpServerCache[$id] ?? null;

                        if (!isset($ftpCredCache[$id])) {
                            $ftpCredCache[$id] = fetchDataSingle('ftp_credentials', ['ftp_server_id' => $id, 'role' => 'camera']);
                        }
                        $ftpCreds = $ftpCredCache[$id] ?? null;

                        if (!empty($ftpServer)) {
                            $camera['ftp_host'] = $ftpServer['url'];
                            $camera['ftp_port'] = $ftpServer['port'];
                        }

                        if (!empty($camera['ftp_password'])) {
                            // $camera['ftp_user'] = $ftpCreds['username'];
                            $camera['ftp_password'] = decryptFtpPassword($camera['ftp_password']);
                        }
                    }

                    $filtered_data[] = $camera;
                }
            }

            sendJsonResponse(200, [
                "success" => true,
                "data"    => $filtered_data ?? null,
            ]);
            exit;
        }

        $ftpServerCache = [];
        $ftpCredCache = [];

        foreach ($data as &$camera) {
            if (!empty($camera['ftp_mode']) && $camera['ftp_mode'] === 'managed' && !empty($camera['ftp_managed_id'])) {
                $id = $camera['ftp_managed_id'];

                if (!isset($ftpServerCache[$id])) {
                    $ftpServerCache[$id] = fetchDataSingle('ftp_servers', ['id' => $id, 'active' => 1]);
                }
                $ftpServer = $ftpServerCache[$id] ?? null;

                if (!isset($ftpCredCache[$id])) {
                    $ftpCredCache[$id] = fetchDataSingle('ftp_credentials', ['ftp_server_id' => $id, 'role' => 'camera']);
                }
                $ftpCreds = $ftpCredCache[$id] ?? null;

                if (!empty($ftpServer)) {
                    $camera['ftp_host'] = $ftpServer['url'];
                    $camera['ftp_port'] = $ftpServer['port'];
                }

                if (!empty($camera['ftp_password'])) {
                    // $camera['ftp_user'] = $ftpCreds['username'];
                    $camera['ftp_password'] = decryptFtpPassword($camera['ftp_password']);
                }
            }
        }
        unset($camera);

        sendJsonResponse(200, [
            "success" => true,
            "data"    => $data ?? null,
        ]);
        exit;
    }

    if (isset($_POST['deleteSetting'])) {
        if (!currentUserHasAccess($pdo, 'property_builder', 'delete')) {
            sendJsonResponse(500, ["error" => "You are not authorized to delete"]);
            exit;
        }

        $_POST['property_id'] = $_POST['property_id'] ?? $_SESSION['property_id'] ?? null;

        $deleted_camera_data = fetchDataSingle(
            'live_camera_streaming_data',
            ['id' => $_POST['settingId']]
        );

        if (!empty($deleted_camera_data['ftp_mode']) && strtolower($deleted_camera_data['ftp_mode']) === 'managed') {
            deleteCameraAndFtpArtifacts(
                $deleted_camera_data['id'],
                $deleted_camera_data['property_id']
            );
        }
        $today_date = date('Y-m-d');
        $created_date = date('Y-m-d', strtotime($deleted_camera_data['created_at'] . ' +1 month'));
        if($created_date < $today_date){
            $created_at = date('Y-m-d H:i:s', strtotime($created_date));
            insertData('delete_live_camera_streaming_data', [
                'data' => json_encode($deleted_camera_data),
                'property_id' => $deleted_camera_data['property_id'],
                'created_at' => $created_at,
                'deleted_at' => date('Y-m-d H:i:s'),
            ]);
        }

        
        $data = deleteData('live_camera_streaming_data', 'id', $_POST['settingId']);
        $response = $data;

        createAuditLog(
            $_SESSION["userid"],
            "delete",
            "live_camera_streaming_data",
            $_POST['settingId'] ?? null,
            $_SESSION["email"] ?? null,
            $_POST['property_id'] ?? null,
            json_encode($deleted_camera_data),
            null,
            "Camera deleted",
            "high",
            "Hardware"
        );
    }

    if (isset($_POST['getSettingDataById'])) {
        $data = fetchDataWithId('live_camera_streaming_data', $_POST['settingId']);
        $response1 = $data;

        if (!empty($response1['ftp_mode']) && $response1['ftp_mode'] === 'managed' && !empty($response1['ftp_managed_id'])) {
            $id = $response1['ftp_managed_id'];

            $ftpServer = fetchDataSingle('ftp_servers', ['id' => $id, 'active' => 1]);
            if (!empty($ftpServer)) {
                $response1['ftp_host'] = $ftpServer['url'];
                $response1['ftp_port'] = $ftpServer['port'];
            }
        }

        if ($response1['ftp_mode'] === 'managed' && !empty($response1['ftp_password'])) {
            $response1['ftp_password'] = decryptFtpPassword($response1['ftp_password']);
        }

        $response = $response1;
    }

    if (isset($_POST['get_camera_by_id'])) {
        if (!currentUserHasAccess($pdo, 'property_builder', 'read')) {
            sendJsonResponse(500, ["error" => "You are not authorized to read"]);
            exit;
        }

        if (empty($_POST['property_id'])) $_POST['property_id'] = $_SESSION['property'];
        if (!$_POST['property_id']) {
            sendJsonResponse(400, ["error" => "Property ID is required."]);
            exit;
        }

        // $response = fetchDataWithId('live_camera_streaming_data', $_POST['settingId']);
        $response = fetchDataSingle('live_camera_streaming_data', ['id' => $_POST['settingId'],'property_id' => $_POST['property_id']]);
        if ($response['ftp_mode'] === 'managed' && !empty($response['ftp_password'])) {
            $response['ftp_password'] = decryptFtpPassword($response['ftp_password']);
        }
        sendJsonResponse(200, [
            "success" => true,
            "data" => $response
        ]);
        exit;
    }

    if (isset($_POST['updateSettings'])) {
        if (!currentUserHasAccess($pdo, 'property_builder', 'write')) {
            sendJsonResponse(500, ["error" => "You are not authorized to write"]);
            exit;
        }
        if ($_POST['ftp_mode'] === 'managed' && empty($_POST['ftp_managed_id'])) {
            sendJsonResponse(500, ["error" => "Managed FTP selected, but no managed server was chosen"]);
            exit;
        }
        if (empty($_POST['ftp_mode']) || empty($_POST['ftp_managed_id']) || empty($_POST['ftp_managed_folder'])){
            $_POST['ftp_mode'] = null;
            $_POST['ftp_managed_id'] = null;
            $_POST['ftp_managed_folder'] = null;
        }
        $_POST['property_id'] = $_POST['property_id'] ?? $_SESSION['property_id'] ?? null;
        $formattedUpdatedAt = (new DateTime())->format('Y-m-d H:i:s');
        $_POST['user'] = $_SESSION['userid'];

        $existing = fetchDataSingle('live_camera_streaming_data', ['id' => $_POST['settingsId']]);
        if (!$existing) {
            sendJsonResponse(500, ["error" => "Camera record not found"]);
            exit;
        }

        $origMode = strtolower(trim($_POST['original_ftp_mode'] ?? ($existing['ftp_mode'] ?? '')));
        $newMode  = strtolower(trim($_POST['ftp_mode'] ?? ''));

        if ($existing['ftp_mode'] === 'managed'  && $newMode === 'managed') {
            if ($_POST['ftp_managed_id'] != $existing['ftp_managed_id']) {
                sendJsonResponse(500, ["error" => "Changing FTP server for managed mode is not allowed"]);
                exit;
            }
            if (!empty($_POST['ftp_managed_folder']) && $_POST['ftp_managed_folder'] !== $existing['ftp_managed_folder']) {
                sendJsonResponse(500, ["error" => "Changing folder name for managed mode is not allowed"]);
                exit;
            }
        }

        if ($origMode !== 'managed' && $newMode === 'managed') {
            sendJsonResponse(500, ["error" => "Switching to Managed via edit is not supported. Delete and re-add the camera with Managed FTP."]);
            exit;
        }

        if ($origMode === 'managed' && $newMode === 'custom') {
            $confirm = (string)($_POST['confirm_switch_ftp'] ?? '0');
            if ($confirm !== '1') {
                sendJsonResponse(409, [
                    "error" => "Switching from Managed to Custom requires confirmation.",
                    "code"  => "CONFIRM_SWITCH_FTP"
                ]);
                exit;
            }

            try {
                deleteCameraAndFtpArtifacts(
                    (int)$existing['id'],
                    (int)$existing['property_id']
                );
            } catch (\Throwable $t) {
                error_log("deleteCameraAndFtpArtifacts failed for camera {$existing['id']}: " . $t->getMessage());
                sendJsonResponse(500, ["error" => "FTP cleanup failed; camera not updated."]);
                exit;
            }

            $missing = [];
            foreach (['ftp_host','ftp_user','ftp_password','ftp_port'] as $k) {
                if (empty($_POST[$k])) $missing[] = $k;
            }
            if ($missing) {
                sendJsonResponse(400, ["error" => "Custom FTP requires: " . implode(', ', $missing)]);
                exit;
            }
        }

        $keys = ['streamingUrl', 'camera_ftp_folder', 'ftp_host', 'ftp_user', 'ftp_user', 'ftp_password', 'ftp_port', 'cameraName', 'userName', 'password', 'user', 'cameraModel', 'RTSP_PORT', 'IP', 'liveImagePort', 'liveImageURL', 'ftp_mode', 'ftp_managed_id', 'ftp_managed_folder'];
        $data = array_intersect_key($_POST, array_flip($keys));
        if ($newMode === 'managed') {
            unset($data['ftp_user'], $data['ftp_password'], $data['ftp_host'], $data['ftp_port']);
        } else {
            if (!empty($data['ftp_password'])) {
                $data['ftp_password'] = encryptFtpPassword($data['ftp_password']);
            }

            if ($origMode === 'managed' && $newMode === 'custom') {
                $data['ftp_password'] = encryptFtpPassword($_POST['ftp_password']);
                $data['ftp_managed_id']      = null;
                $data['ftp_managed_folder']  = null;
            }
        }
        $where = 'id = :id';
        $params = ['id' => $_POST['settingsId']];
        $old_camera_data = fetchDataSingle('live_camera_streaming_data', ['id' => $_POST['settingsId']]);
        try {
            $updateSuccess = updateTable('live_camera_streaming_data', $data, $where, $params);
            if ($updateSuccess === false) {
                error_log("[$trace] updateTable returned false.");
                sendJsonResponse(500, ["error" => "Failed to save camera record"]);
                exit;
            }
        } catch (Throwable $e) {
            error_log("updateTable threw: " . $e->getMessage() . "Data = " . json_encode($data));
            sendJsonResponse(500, ["error" => "Failed to save camera record"]);
            exit;
        }

        $updated_camera_data = fetchDataSingle('live_camera_streaming_data', ['id' => $_POST['settingsId']]);
        $response = $updateSuccess;
        $response = $data;

        createAuditLog(
            $_SESSION["userid"],
            "update",
            "live_camera_streaming_data",
            $_POST['settingsId'] ?? null,
            $_SESSION["email"] ?? null,
            $_POST['property_id'] ?? null,
            json_encode($old_camera_data),
            json_encode($updated_camera_data),
            "Camera updated",
            "high",
            "Hardware"
        );

        sendJsonResponse(200, ["success" => true, "data" => $updated_camera_data]);
    }
    if (isset($_POST['addForm'])) {
        if (!currentUserHasAccess($pdo, 'property_builder', 'write')) {
            sendJsonResponse(500, ["error" => "You are not authorized to write"]);
            exit;
        }
        $_POST['user'] = $_SESSION['userid'];
        if (empty($_POST['property_id'])) $_POST['property_id'] = $_SESSION['property'];
        if (empty($_POST['property_id'])) {
            sendJsonResponse(500, ["error" => 'Property id is missing']);
            exit;
        }

        $trace = $trace ?? bin2hex(random_bytes(8));
        // if(empty($_POST['streamingUrl'])){
        //     $duplicateFound=fetchDataSingle("live_camera_streaming_data",["property_id"=>$_POST['property_id'],"liveImageURL"=>$_POST['liveImageURL']]);
        //     if(!empty($duplicateFound) && empty($duplicateFound['streamingUrl'])){
        //         sendJsonResponse(500, ["error" => 'Already found the camera with the same url '.$_POST['liveImageURL']]);
        //         exit;
        //     }
        // }else {
        //     $duplicateFound=fetchDataSingle("live_camera_streaming_data",["property_id"=>$_POST['property_id'],"liveImageURL"=>$_POST['liveImageURL'],"streamingUrl"=>$_POST['streamingUrl']]);
        //     if(!empty($duplicateFound)){
        //         sendJsonResponse(500, ["error" => 'Already found the camera with the same url '.$_POST['streamingUrl']]);
        //         exit;
        //     }
        // }
        if ($_POST['ftp_mode'] === 'managed' && empty($_POST['ftp_managed_id'])) {
            sendJsonResponse(500, ["error" => "Managed FTP selected, but no managed server was chosen"]);
            exit;
        }

        if ($_POST['ftp_mode'] === 'managed' && !empty($_POST['ftp_managed_id'])) {

            $virtualUser = null;
            $virtualPass = null;

            $propertyId = (int)$_POST['property_id'];
            $ftpServerId = (int)$_POST['ftp_managed_id'];

            $dealerRow = fetchSingleDataWithJoins("
                SELECT o.dealer_id
                FROM properties p
                JOIN organizations o ON p.organization_id = o.id
                WHERE p.id = :pid
            ", ['pid' => $propertyId]);

            $dealerId = (int)($dealerRow['dealer_id'] ?? 0);
            if (!$dealerId) {
                error_log("[$trace] Dealer not found for property_id=$propertyId");
                sendJsonResponse(500, ["error" => "Dealer not linked to property"]);
                exit;
            }

            $allocation = fetchDataSingle('dealer_ftp_allocations', [
                'dealer_id'    => $dealerId,
                'ftp_server_id'=> $ftpServerId
            ]);

            if (!$allocation) {
                error_log("[$trace] No allocation row for dealer_id=$dealerId server_id=$ftpServerId");
                sendJsonResponse(409, ["error" => "No camera slots found for this property"]);
                exit;
            }

            $used  = (int)($allocation['camera_slots_used'] ?? 0);
            $limit = (int)($allocation['camera_slots_allowed'] ?? 0);

            if ($limit <= 0) {
                error_log("[$trace] Invalid or zero camera_slots_allowed for allocation id={$allocation['id']}");
                sendJsonResponse(409, ["error" => "Property has no available camera slots"]);
                exit;
            }

            if ($used >= $limit) {
                error_log("[$trace] Dealer out of slots (used=$used limit=$limit) for dealer_id=$dealerId server_id=$ftpServerId");
                sendJsonResponse(409, ["error" => "No camera slots available for this property on the selected server"]);
                exit;
            }

            $existingCreds = fetchDataSingle('ftp_credentials', [
                'property_id' => $propertyId,
                'ftp_server_id' => $ftpServerId,
                'role' => 'camera'
            ]);

            $ftpEnv = getEnvVars();
            $ftpUsername = $ftpEnv['ftp_env'] . '_ftp_prop_' . $propertyId;
            $ftpServer = fetchDataSingle('ftp_servers', ['id' => $ftpServerId]);
            if (empty($ftpServer['url'])) {
                error_log("[$trace] Missing or invalid FTP host for server ID: $ftpServerId , :" . json_encode($ftpServer));
                sendJsonResponse(500, ["error" => "Invalid FTP server configuration"]);
                exit;
            }
            $ftpHost = $ftpServer['url'];

            if (!$existingCreds) {
                $ftpPassword = bin2hex(random_bytes(6));
                $encryptedPassword = encryptFtpPassword($ftpPassword);

                $sshCmd = sprintf(
                    'ssh -i %s -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -T %s@%s',
                    escapeshellarg($ftpEnv['ftp_cred_key']),
                    escapeshellarg($ftpEnv['ftp_cred_user']),
                    escapeshellarg($ftpHost)
                );

                $descriptors = [
                    0 => ['pipe', 'r'], // stdin
                    1 => ['pipe', 'w'], // stdout
                    2 => ['pipe', 'w']  // stderr
                ];

                $process = proc_open($sshCmd, $descriptors, $pipes, null, null, ['bypass_shell' => true]);

                if (is_resource($process)) {
                    fwrite($pipes[0], "$ftpUsername $ftpPassword\n");
                    fclose($pipes[0]);

                    $stdout = stream_get_contents($pipes[1]);
                    fclose($pipes[1]);

                    $stderr = stream_get_contents($pipes[2]);
                    fclose($pipes[2]);

                    $status = proc_close($process);

                    if ($status === 0) {
                        insertData('ftp_credentials', [
                            'property_id' => $propertyId,
                            'ftp_server_id' => $ftpServerId,
                            'ftp_username' => $ftpUsername,
                            'ftp_password' => $encryptedPassword,
                            'role' => 'camera'
                        ]);

                    } else {
                        error_log("[$trace] Failed to create FTP user for property $propertyId (Exit: $status). STDERR: $stderr | STDOUT: $stdout");
                        sendJsonResponse(500, ["error" => "Failed to create FTP user on remote server"]);
                        exit;
                    }
                } else {
                    error_log("[$trace] proc_open failed for property $propertyId");
                    sendJsonResponse(500, ["error" => "Internal error initializing FTP user creation"]);
                    exit;
                }
            }
        }

        $ftpFolder = trim($_POST['ftp_managed_folder']);
        if (!empty($ftpFolder)) {
            $cameraFolderCmd = sprintf(
                'ssh -i %s -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -T %s@%s',
                escapeshellarg($ftpEnv['ftp_fold_key']),
                escapeshellarg($ftpEnv['ftp_fold_user']),
                escapeshellarg($ftpHost)
            );

            $descriptors = [
                0 => ['pipe', 'r'],
                1 => ['pipe', 'w'],
                2 => ['pipe', 'w']
            ];

            $proc = proc_open($cameraFolderCmd, $descriptors, $pipes, null, null, ['bypass_shell' => true]);

            if (is_resource($proc)) {
                fwrite($pipes[0], "$ftpUsername $ftpFolder\n");
                fclose($pipes[0]);

                $stdout = stream_get_contents($pipes[1]);
                fclose($pipes[1]);

                $stderr = stream_get_contents($pipes[2]);
                fclose($pipes[2]);

                $exit = proc_close($proc);

                if ($exit !== 0) {
                    error_log("[$trace] Camera folder script failed (exit=$exit). STDERR: $stderr | STDOUT: $stdout");
                    sendJsonResponse(500, ["error" => "Failed to create camera folder"]);
                    exit;
                }

                $cmd = sprintf(
                    'ssh -i %s -o StrictHostKeyChecking=no -T %s@%s',
                    escapeshellarg($ftpEnv['ftp_vcred_key']),
                    escapeshellarg($ftpEnv['ftp_vcred_user']),
                    escapeshellarg($ftpHost)
                );

                $descriptors = [
                    0 => ['pipe','r'],
                    1 => ['pipe','w'],
                    2 => ['pipe','w'],
                ];

                $proc = proc_open($cmd, $descriptors, $pipes, null, null, ['bypass_shell' => true]);

                if (!is_resource($proc)) {
                    error_log("[$trace] add_virtual_ftp_user: proc_open failed host=$ftpHost user={$ftpEnv['ftp_vcred_user']}");
                } else {

                    fwrite($pipes[0], "$ftpUsername $ftpFolder {$ftpEnv['ftp_env']} $propertyId\n");
                    fclose($pipes[0]);

                    $stdout = stream_get_contents($pipes[1]); fclose($pipes[1]);
                    $stderr = stream_get_contents($pipes[2]); fclose($pipes[2]);
                    $exit   = proc_close($proc);

                    if ($exit !== 0) {

                        $hint = '';
                        if (stripos($stderr, 'sudo') !== false && stripos($stderr, 'password') !== false) {
                            $hint = ' (sudo likely missing NOPASSWD or forced-command not using -n)';
                        } elseif (stripos($stderr, 'db_load') !== false && stripos($stderr, 'not found') !== false) {
                            $hint = ' (db_load not in PATH; use /usr/bin/db_load in script)';
                        } elseif (stripos($stderr, 'Usage:') !== false) {
                            $hint = ' (script did not receive required arguments via stdin/argv)';
                        } elseif (stripos($stderr, 'Permission denied (publickey') !== false) {
                            $hint = ' (wrong key/user or authorized_keys restriction)';
                        }
                        error_log("[$trace] add_virtual_ftp_user failed (exit=$exit)$hint host=$ftpHost user={$ftpEnv['ftp_vcred_user']} STDERR: $stderr | STDOUT: $stdout");

                    } else {

                        foreach (explode("\n", $stdout) as $line) {
                            $line = trim($line);
                            if ($line === '') continue;
                            if (strpos($line, 'virtual_username:') === 0) {
                                $virtualUser = trim(substr($line, strlen('virtual_username:')));
                            } elseif (strpos($line, 'virtual_password:') === 0) {
                                $virtualPass = trim(substr($line, strlen('virtual_password:')));
                            }
                        }

                        if ($virtualUser && $virtualPass) {
                            error_log("[$trace] add_virtual_ftp_user success vuser=$virtualUser host=$ftpHost");
                        } else {
                            error_log("[$trace] add_virtual_ftp_user: credentials not found in stdout. host=$ftpHost STDOUT: $stdout | STDERR: $stderr");
                        }
                    }
                }

            } else {
                error_log("[$trace] proc_open for camera folder failed");
                sendJsonResponse(500, ["error" => "Internal error creating camera folder"]);
                exit;
            }
        }
        
        $virtualUser = $virtualUser ?? null;
        $virtualPass = $virtualPass ?? null;

        $ftpMode = $_POST['ftp_mode'] === '' ? null : $_POST['ftp_mode'];
        $ftpPort = $_POST['ftp_port'] === '' ? null : $_POST['ftp_port'];
        $ftpManagedId = $_POST['ftp_managed_id'] === '' ? null : $_POST['ftp_managed_id'];
        $ftpManagedFolder = $_POST['ftp_managed_folder'] === '' ? null : $_POST['ftp_managed_folder'];

        $keys = ['streamingUrl', 'camera_ftp_folder', 'ftp_host', 'ftp_user', 'ftp_password', 'ftp_port', 'property_id', 'cameraName', 'userName', 'password', 'user', 'cameraModel', 'RTSP_PORT', 'IP', 'liveImagePort', 'liveImageURL'];
        $data = array_intersect_key($_POST, array_flip($keys));
        $data['ftp_mode'] = $ftpMode;
        $data['ftp_managed_id'] = $ftpManagedId;
        $data['ftp_managed_folder'] = $ftpManagedFolder;
        if (empty($data['camera_ftp_folder']) && !empty($ftpManagedFolder)) {
            $data['camera_ftp_folder'] = $ftpManagedFolder;
        }
        if ($ftpMode === 'managed' && $virtualUser && $virtualPass) {
           $data['ftp_host'] = $ftpHost;
           $data['ftp_user'] = $virtualUser;
           $data['ftp_password'] = encryptFtpPassword($virtualPass);
           $data['ftp_port'] = $ftpPort;
        }

        try {
            $inserted = insertData('live_camera_streaming_data', $data);
            if ($inserted === false) {
                error_log("[$trace] insertData returned false. Data=" . json_encode($data));
                sendJsonResponse(500, ["error" => "Failed to save camera record"]);
                exit;
            }
        } catch (Throwable $e) {
            error_log("[$trace] insertData threw: " . $e->getMessage() . " | Data=" . json_encode($data));
            sendJsonResponse(500, ["error" => "Failed to save camera record"]);
            exit;
        }
        $last_camera_id = getLastInsertId();
        $last_camera_data = fetchDataSingle('live_camera_streaming_data', ['id' => $last_camera_id]);
        $response = $data;

        if ($_POST['ftp_mode'] === 'managed' && !empty($_POST['ftp_managed_id'])) {
            $ftpServerId = (int)$_POST['ftp_managed_id'];

            $propertyId = (int)$_POST['property_id'];

            $sql = "
                SELECT o.dealer_id
                FROM properties p
                JOIN organizations o ON p.organization_id = o.id
                WHERE p.id = :property_id
            ";

            $result = fetchSingleDataWithJoins($sql, ['property_id' => $propertyId]);
            $dealerId = (int)($result['dealer_id'] ?? 0);

            if ($dealerId) {
                $allocation = fetchDataSingle('dealer_ftp_allocations', [
                    'dealer_id' => $dealerId,
                    'ftp_server_id' => $ftpServerId
                ]);

                if ($allocation) {
                    updateTable('dealer_ftp_allocations', [
                        'camera_slots_used' => $allocation['camera_slots_used'] + 1
                    ], 'id = :id', ['id' => $allocation['id']]);
                } else {
                    error_log("No dealer_ftp_allocations record found for dealer $dealerId and ftp_server $ftpServerId when trying to increment slot.");
                }
            }
        }

        createAuditLog(
            $_SESSION["userid"],
            "create",
            "live_camera_streaming_data",
            $_POST['settingsId'] ?? null,
            $_SESSION["email"] ?? null,
            $_POST['property_id'] ?? null,
            null,
            json_encode($last_camera_data),
            "New camera added",
            "high",
            "Hardware"
        );

    }
    if (isset($_POST['getFtpServers'])) {
        $ftpServers = fetchData('ftp_servers', ['active' => 1, 'is_managed' => 1]);
        sendJsonResponse(200, $ftpServers);
        exit;
    }

    if (isset($_POST['getFtpCreds'])) {
        try {
            if (!currentUserHasAccess($pdo, 'property_builder', 'read')) {
                sendJsonResponse(403, ["error" => "Not authorized"]);
                exit;
            }

            $cameraId = (int)($_POST['camera_id'] ?? 0);
            if (!$cameraId) {
                sendJsonResponse(400, ["error" => "camera_id missing"]);
                exit;
            }

            $cam = fetchDataSingle('live_camera_streaming_data', ['id' => $cameraId, 'property_id' => $_SESSION['property']]);
            if (!$cam) {
                sendJsonResponse(404, ["error" => "Camera not found"]);
                exit;
            }

            if (strtolower($cam['ftp_mode'] ?? '') !== 'managed') {
                sendJsonResponse(400, ["error" => "Camera is not in managed FTP mode"]);
                exit;
            }

            $host = $cam['ftp_host'] ?? '';
            $user = $cam['ftp_user'] ?? '';
            $encp = $cam['ftp_password'] ?? '';
            $port = (int)($cam['ftp_port'] ?? 21);
            $fold = $cam['ftp_managed_folder'] ?? '';

            if (!$host || !$user || !$encp) {
                sendJsonResponse(409, ["error" => "Managed credentials not yet available"]);
                exit;
            }

            $pass = decryptFtpPassword($encp);

            createAuditLog(
                $_SESSION["userid"],
                "read",
                "live_camera_streaming_data",
                $cameraId,
                $_SESSION["email"] ?? null,
                $cam['property_id'] ?? null,
                null, null,
                "Viewed managed FTP credentials",
                "medium",
                "Hardware"
            );

            sendJsonResponse(200, [
                "host"    => $host,
                "port"    => $port,
                "user"    => $user,
                "password"=> $pass,
                "folder"  => $fold
            ]);
        } catch (Throwable $e) {
            error_log("getFtpCreds error: " . $e->getMessage());
            sendJsonResponse(500, ["error" => "Internal error"]);
        }
        exit;
    }

    if (!empty($_POST['get_csrf_token'])) {
        sendJsonResponse(200, [
            "success" => true,
            "data" => $_SESSION['csrf_token'] ?? null
        ]);
        exit;
    }

} catch (Exception $e) {
    http_response_code(500); // OK
    echo json_encode([
        "success" => false,
        "error" => "server error occurred in setting_request.php"
    ]);

    createAuditLog(
        $_SESSION["userid"] ?? null,
        $_POST['addForm'] ?? $_POST['updateSettings'] ?? $_POST['deleteSetting'] ?? $_POST['getSettingDataById'] ?? $_POST['getSettingsData'] ?? null,
        null,
        null,
        $_SESSION["email"] ?? null,
        $_POST['property_id'],
        null,
        null,
        "server error occurred in setting_request.php",
        'highest',
        'Error'
    );

    exit;
}

echo json_encode($response);