<?php
    try {
        session_start();
        //code...
        require '../../db.php';
        require '../auth/auth_functions.php';
        
        if (!currentUserHasAccess($pdo, 'payment_invoice', 'read')) {
            echo "Access denied.";
            exit();
        }
    } catch (\Throwable $th) {
        // throw $th;
    }
?>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.4.0/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>

<div>
    <div class="container max_w" >
        <!-- <ul class="nav nav-tabs" id="myTab" role="tablist">
            <li class="nav-item">
                <a class="nav-link active" id="admin-invoice-tab" data-toggle="tab" href="#admin-invoice" role="tab" aria-controls="admin-invoice" aria-selected="true">Invoice</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="admin-products-tab" data-toggle="tab" href="#admin-products" role="tab" aria-controls="admin-products" aria-selected="false" onclick="getAdminProducts()">Products</a>
            </li>
        </ul>
        <div class="tab-content" id="admin-invoice-tab">
            <div class="tab-pane fade show active" id="admin-invoice" role="tabpanel" aria-labelledby="admin-invoice-tab"> -->
                <div class="row mt-4">
                  <div class="col-12">

                    <!-- Main content -->
                    <div class="invoice p-3 mb-3" id="payment_page">
                      <!-- title row -->
                      <div class="row">
                        <div class="col-12">
                          <h4 class="pb-4">
                            <img src="/include/images/Invisible_Intercom.png" alt="Invisible Logo"  style="height:100%;width:15%;margin-top:1%;">
                            <p class="float-right "><span class="badge badge-primary" id="payment_date_formatted"><?php echo date('F Y'); ?></span></p>
                            <input type="hidden" name="payment_date" id="payment_date" value="<?php echo date("Y-m"); ?>">
                            <input type="hidden" id="current_payment_date" value="<?php echo date("Y-m"); ?>">

                          </h4>
                        </div>
                        <!-- /.col -->
                      </div>
                      <!-- info row -->
                      <div class="row invoice-info">
                        <div class="col-sm-4 invoice-col">
                          From
                          <address>
                            <div ><strong id="from_invoice_name"></strong><div>
                            <div id="from_invoice_address">
                            </div>

                            <div id="from_invoice_phone"></div>
                            <div id="from_invoice_email"></div>
                          </address>
                        </div>
                        <!-- /.col -->
                        
                        <div class="col-sm-4 invoice-col">
                          To
                          <address>
                            <div ><strong id="to_invoice_name"></strong></div>
                            <div id="to_invoice_email"></div>
                          </address>
                        </div>
                        <div class="col-sm-4 invoice-col">
                          To
                          <address>
                            <div ><strong id="to_invoice_name_property"></strong></div>
                            <div id="to_invoice_property"></div>
                            <div id="to_invoice_contact"></div>
                          </address>
                        </div>
                      </div>
                      <div class="row">
                        <div class="col-12 table-responsive">
                          <table class="table table-striped">
                            <thead>
                            <tr>
                              <th>Qty</th>
                              <th>Product</th>
                              <th>Description</th>
                              <th>Unit Price</th>
                              <?php 
                                if($_SESSION['layer'] == "admin"){ ?>
                                    <th>MSRP Price</th>
                                <?php 
                                }
                              ?>
                              <th>Subtotal</th>
                              <?php 
                                if($_SESSION['layer'] == "admin"){ ?>
                                  <th>MSRP Subtotal</th>
                                  <th>Action</th>
                                <?php 
                                }
                              ?> 
                            </tr>
                            </thead>
                            <tbody id="payment_invoice_tbody_content">
                            
                            </tbody>
                          </table>
                        </div>
                        <!-- /.col -->
                      </div>
                      <!-- /.row -->

                      <div class="row">
                        <!-- accepted payments column -->
                        <div class="col-6">
                          
                        </div>
                        <!-- /.col -->
                        <div class="col-6">
                          <!-- <p class="lead">Amount Due 2/22/2014</p> -->

                          <div class="table-responsive">
                            <table class="table">
                              <tbody><tr>
                                <th style="width:50%">Subtotal:</th>
                                <td>$250.30</td>
                              </tr>
                              <tr>
                                <th>Total:</th>
                                <td>$265.24</td>
                              </tr>
                            </tbody></table>
                          </div>
                        </div>
                      </div>
                      <div class="row no-print">
                        <div class="col-12">
                          <button onclick="window.print()" rel="noopener" target="_blank" class="btn btn-success"><i class="fas fa-print"></i> Print</button>
                            <button id="payment_download" type="button" class="btn btn-primary " style="margin-right: 5px;">
                            <i class="fas fa-download"></i> Generate PDF
                            </button>
                            <button class="btn btn-default float-right" id="call_next_btn" onclick="my_payments('next')" style="display: none;">Next</button>
                            <button class="btn btn-default float-right" id="call_previous_btn" onclick="my_payments('previous')">Previous</button>
                        </div>
                      </div>
                    </div>
                    <!-- /.invoice -->
                  </div><!-- /.col -->
                </div><!-- /.row -->
            <!-- </div>
            <div class="tab-pane fade" id="admin-products" role="tabpanel" aria-labelledby="admin-products-tab"> -->
                <!-- <button type="button" class="btn btn-dark" data-toggle="modal" data-backdrop="static" data-keyboard="false" data-target="#sgproductmodel" style="margin:1rem 0 1rem .5rem;width:auto;">+ Add Product</button>
                <div class="row mt-2">
                  <div class="col-12">
                    <div class="invoice p-3 mb-3">
                      <div class="row">
                        <div class="col-12 table-responsive">
                          <table class="table table-striped">
                            <thead>
                            <tr>
                              <th>Product</th>
                              <th>Description</th>
                              <th>Unit Price</th>
                            </tr>
                            </thead>
                            <tbody id="calling_products_content">
                            
                            </tbody>
                          </table>
                        </div>
                      </div>
                    </div>
                  </div>
                </div> -->
            </div>
        </div>
    </div>
</div>
<!-- <div class="modal fade" id="sgproductmodel" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalCenterTitle">Add New Product</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="productForm" action="include/payment_invoice/payment_invoice.php" method="post" enctype="multipart/form-data">
                        <div class="input-group mb-3">
                            <input type="text" name="product_name" class="form-control" title="Product Name" placeholder="Product Name" required>
                        </div>
                        <div class="input-group mb-3">
                            <input type="text" name="product_dsciption" class="form-control" title="Product Description" placeholder="Product Description" required>
                        </div>
                        <div class="input-group mb-3">
                            <input type="number" name="unit_price" class="form-control" title="Unit Price" placeholder="Unit Price" required>
                        </div>
                        <div class="input-group mb-3">
                            <input type="number" name="msrp_price" class="form-control" title="MSRP Price" placeholder="MSRP Price" required>
                        </div>
                        <button type="submit" id="propertyModalSubmitButton" name="submitnew" class="btn btn-primary btn-block">Add Product</button>
                    </form>  
                </div> 
            </div>
        </div>
</div> -->

<div class="modal fade" id="edit_price_model" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalCenterTitle">Edit Price</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group mb-3">
                    <label>Qty :</label>
                    <input type="text" name="qty" id="product_qty_sg" class="form-control" title="Qty" placeholder="Qty" value="1" required>
                </div>
                <div class="form-group mb-3">
                    <label>Dealer Unit Price :</label>
                    <input type="text" name="unit_price" id="product_unit_price" class="form-control" title="Unit Price" placeholder="Unit Price" required>
                </div>

                <div class="form-group mb-3">
                    <label>MSRP Unit Price :</label>
                    <input type="text" name="msrp_price" id="product_msrp_price" class="form-control" title="MSRP Price" placeholder="MSRP Price" required>
                </div>
                <input type="hidden" name="product_id" id="product_id_sg">
                <input type="hidden" name="page" id="product_page_sg">
                <!-- <input type="hidden" name="product_name" id="product_name_sg"> -->
                <button type="button" id="edit_product_price" onclick="update_product_price()" class="btn btn-primary btn-block">Update Price</button> 
            </div> 
        </div>
    </div>
</div>
<script>
    document.getElementById('payment_download').addEventListener('click', async () => {
        const { jsPDF } = window.jspdf;
        const doc = new jsPDF();

        // Convert the HTML content to canvas using html2canvas
        const content = document.getElementById('payment_page');
        const canvas = await html2canvas(content);

        // Convert canvas to image
        const imgData = canvas.toDataURL('image/png');
        const imgWidth = 190; // Adjust to fit A4
        const pageHeight = 297; // A4 page height in mm
        const imgHeight = (canvas.height * imgWidth) / canvas.width;

        doc.addImage(imgData, 'PNG', 10, 10, imgWidth, imgHeight);
        var dealer_name = $("#to_invoice_name").html();
        var invoice_m= $("#payment_date_formatted").html();
        doc.save(dealer_name  + " " + invoice_m + '.pdf');
    });
</script>




