<?php

    try {
        session_start();
        //code...
        require '../../db.php';
        require '../auth/auth_functions.php';
        
        if (!currentUserHasAccess($pdo, 'my_properties', 'read')) {
            echo "Access denied.";
            exit();
        }
        
    } catch (\Throwable $th) {
        // throw $th;
    }

?>
<style>

    .table-responsive {
        transition: none !important;
        height: auto !important;
        padding: 0 !important;
    }

    .expandable-body {
        display: none;
        transition: none !important;
        animation: none !important;
        overflow: visible !important;
    }

    .col-13 {
        -ms-flex: 0 0 100%;
        flex: 0 0 100%;
        max-width: 100%;
        position: relative;
        width: 100%;
        padding-right: 15px;
        padding-left: 15px;
    }
</style>

<div>

    <div class="d-flex flex-wrap justify-content-between align-items-center">
        <div class="buttons">
            <?php if ($_SESSION['layer'] === 'super_admin' || $_SESSION['layer'] === 'admin' || $_SESSION['layer'] === 'dealer' || $_SESSION['layer'] === 'sub_dealer'): ?>
                <button type="button" class="btn btn-dark" data-toggle="modal" data-backdrop="static" data-keyboard="false" data-target="#propmodal" style="margin:1rem 0 1rem .5rem;width:auto;">+ Property</button>
                <button type="button" class="btn btn-dark" data-toggle="modal" data-backdrop="static" data-keyboard="false" data-target="#orgmodal" style="margin:1rem 0 1rem .5rem;width:auto;">+ Organization</button>
            <?php endif; ?>
    <?php if ($_SESSION['layer'] === 'super_admin' || $_SESSION['layer'] === 'admin'): ?>
                <button type="button" class="btn btn-dark" id="slotModalBtn" data-toggle="modal" data-backdrop="static" data-keyboard="false" data-target="#dealerslotsmodal" style="margin:1rem 0 1rem .5rem;width:auto;">Manage Dealer Slots</button>
            <?php endif; ?>
        </div>
    </div>
    
    <script src="js/cards_responsive/organization.js"></script>

    <div id="organization_card_view" style="display: none;">
    </div>

    <!-- <img src="/include/images/Invisible_Intercom.png" alt="" srcset=""> -->

    <!-- original -->
    <!-- <div class="col-12">
        <div class="row">
            <div class="col-12" style="margin-top: 20px;">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">My Organizations</h3>
                        <div class="card-tools">
                            <div class="input-group input-group-sm" style="width: 250px;">
                                <input type="text" id="searchOrgInput" onkeyup="searchTable('orgTable', 'searchOrgInput')" class="form-control float-right" placeholder="Search">
                                <div class="input-group-append">
                                    <button type="button" class="btn btn-default">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover table-bordered" id="orgTable">
                                <thead>
                                    <tr>
                                        <th>Id</th>
                                        <th>Organization</th>
                                        <th>Address</th>
                                        <th>City</th>
                                        <th>State</th>
                                        <th>Zip</th>
                                        <th>Contact</th>
                                        <th>Contact Phone</th>
                                        <th>Created Date</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody id="orgtble">
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-12">
        <div class="row">
            <div class="col-12" style="margin-top: 20px;">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">My Properties</h3>
                        <div class="card-tools">
                            <div class="input-group input-group-sm" style="width: 250px;">
                                <input type="text" id="searchPropertiesInput" onkeyup="searchTable('propertiesTable', 'searchPropertiesInput')" class="form-control float-right" placeholder="Search">
                                <div class="input-group-append">
                                    <button type="button" class="btn btn-default">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover table-bordered" id="propertiesTable">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Property Name</th>
                                        <th>Address</th>
                                        <th>City</th>
                                        <th>State</th>
                                        <th>Zip</th>
                                        <th>Contact</th>
                                        <th>Contact Phone</th>
                                        <th>Org ID</th>
                                        <th>Property Type</th>
                                        <th>Created</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody id="proptble"></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div> -->
    <?php 
        $colClass = ($_SESSION['layer'] === 'super_admin' || $_SESSION['layer'] === 'admin') ? 'col-13' : 'col-12'; 
    ?>
    <div id="organization_table_view" class="<?php echo $colClass; ?>">
        <div class="row">
            <div class="<?php echo $colClass; ?>" style="margin-top: 20px;">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">My Organizations</h3>
                        <div class="card-tools">
                            <div class="input-group input-group-sm" style="width: 250px;">
                                <input type="text" id="searchOrgInput" onkeyup="searchExpandableTable('orgTable', 'searchOrgInput')" class="form-control float-right" placeholder="Search">
                                <div class="input-group-append">
                                    <button type="button" class="btn btn-default">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover table-bordered" id="orgTable">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <!-- <th>Id</th> -->
                                        <th>Organization</th>
                                        
                                        <th>Address</th>
                                        <th>City</th>
                                        <th>State</th>
                                        <th>Zip</th>
                                        <th>Contact</th>
                                        <th>Contact Phone</th>
                                        <th>Created Date</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody id="orgtble"></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!--  Add Property Modal Start -->
    <div class="modal fade" id="propmodal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalCenterTitle">Add New Property</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="propertyForm" action="include/properties/property.php" method="post" enctype="multipart/form-data">
                        <div class="d-flex justify-content-center align-items-center pb-3">
                            <div id="imagePreviewContainer" class="selectedImagePreviewContainer" style="margin-top: 10px;">
                                <img id="imagePreview" src="/include/images/no-image.png" alt="Image Preview" />
                            </div>
                            <div class="mb-3">
                                <div class="text-center mb-2">
                                    <label for="propImageInput" class="form-label"><small class="text-muted">(Max file size: 4MB)</small></label>
                                </div>
                                <input type="file" name="propImage" id="propImage" class="form-control" accept="image/*" title="Upload an Image" onchange="triggerImagePreviewAndCrop(event, 'prop')">
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="text" name="propLink" class="form-control" title="Property link" placeholder="Property link" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card" title="Property Link"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <select name="proptype" class="form-control select2bs4" title="Property Type" required>
                                <option selected="selected">Please Select a Property Type</option>
                                <option value="1">Residential</option>
                                <option value="2">Multi Family</option>
                                <option value="3">Light Commercial</option>
                                <option value="4">Commercial</option>
                            </select>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-building-columns" title="Property Type"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="text" name="propname" class="form-control" title="Property Name" placeholder="Property Name" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card" title="Property Name"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="text" name="propaddress" class="form-control" title="Property Address" placeholder="Property Address" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-map-location-dot" title="Property Address"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="text" name="propcity" class="form-control" title="City" placeholder="City" required>
                            <div class="input-group-append">
                                <select name="propstate" class="form-control select2bs4" style="width: 100%;" title="State" required>
                                    <option value="" selected="selected">Select a State</option>
                                    <option value="AL">Alabama</option>
                                    <option value="AK">Alaska</option>
                                    <option value="AZ">Arizona</option>
                                    <option value="AR">Arkansas</option>
                                    <option value="CA">California</option>
                                    <option value="CO">Colorado</option>
                                    <option value="CT">Connecticut</option>
                                    <option value="DE">Delaware</option>
                                    <option value="DC">District Of Columbia</option>
                                    <option value="FL">Florida</option>
                                    <option value="GA">Georgia</option>
                                    <option value="HI">Hawaii</option>
                                    <option value="ID">Idaho</option>
                                    <option value="IL">Illinois</option>
                                    <option value="IN">Indiana</option>
                                    <option value="IA">Iowa</option>
                                    <option value="KS">Kansas</option>
                                    <option value="KY">Kentucky</option>
                                    <option value="LA">Louisiana</option>
                                    <option value="ME">Maine</option>
                                    <option value="MD">Maryland</option>
                                    <option value="MA">Massachusetts</option>
                                    <option value="MI">Michigan</option>
                                    <option value="MN">Minnesota</option>
                                    <option value="MS">Mississippi</option>
                                    <option value="MO">Missouri</option>
                                    <option value="MT">Montana</option>
                                    <option value="NE">Nebraska</option>
                                    <option value="NV">Nevada</option>
                                    <option value="NH">New Hampshire</option>
                                    <option value="NJ">New Jersey</option>
                                    <option value="NM">New Mexico</option>
                                    <option value="NY">New York</option>
                                    <option value="NC">North Carolina</option>
                                    <option value="ND">North Dakota</option>
                                    <option value="OH">Ohio</option>
                                    <option value="OK">Oklahoma</option>
                                    <option value="OR">Oregon</option>
                                    <option value="PA">Pennsylvania</option>
                                    <option value="RI">Rhode Island</option>
                                    <option value="SC">South Carolina</option>
                                    <option value="SD">South Dakota</option>
                                    <option value="TN">Tennessee</option>
                                    <option value="TX">Texas</option>
                                    <option value="UT">Utah</option>
                                    <option value="VT">Vermont</option>
                                    <option value="VA">Virginia</option>
                                    <option value="WA">Washington</option>
                                    <option value="WV">West Virginia</option>
                                    <option value="WI">Wisconsin</option>
                                    <option value="WY">Wyoming</option>
                                </select>
                            </div>
                            <input type="text" name="propzip" class="form-control" oninput="validateAndLimitInput(this)" title="ZipCode" pattern="[0-9]{5}" placeholder="ZipCode" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-map-location-dot" title="ZipCode"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="text" name="propCon" class="form-control" title="Contact Name" placeholder="Contact Name">
                            <input type="text" name="propConPh" class="form-control" title="Contact Number" oninput="formatPhoneNumber(this)" onpaste="handlePaste(event)" placeholder="Contact Number">
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card" title="Contact Name and Number"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <select name="organization_id" id="organization_id" class="form-control select2bs4" title="Organization" required></select>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-sitemap" title="Organization"></span>
                                </div>
                            </div>
                        </div>
                        <!-- <div class="input-group mb-3">
                            <label>Demo Expiry Date</label>
                            <input type="date" name="propdemo" class="form-control" placeholder="Enter Demo Expiry Date">
                        </div> -->
                        <div class="input-group mb-3">
                            <input type="text" name="propnotes" class="form-control" title="Notes" placeholder="Enter Notes">
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-comment-dots" title="Notes"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="text" name="propreferral" class="form-control" title="Referral Code" placeholder="Enter Referral Code">
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-user" title="Notes"></span>
                                </div>
                            </div>
                        </div>
                        <button type="submit" id="propertyModalSubmitButton" name="submitnew" class="btn btn-primary btn-block">Add Property</button>
                    </form>  
                </div> 
            </div>
        </div>
    </div>

    <div class="modal fade" id="upropmodal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalCenterTitle">Update Property</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="upropertyForm" action="include/properties/property.php" method="post" enctype="multipart/form-data">
                        <div class="d-flex justify-content-center align-items-center pb-3">
                            <div id="uimagePreviewContainer" class="selectedImagePreviewContainer" style="margin-top: 10px;">
                                <img id="uimagePreview" src="/include/images/no-image.png" alt="Image Preview" />
                            </div>
                            <div class="mb-3">
                                <div class="text-center mb-2">
                                    <label for="profileImageInput" class="form-label"><small class="text-muted">(Max file size: 4MB)</small></label>
                                </div>
                                <input type="file" name="upropImage" id="upropImage" class="form-control" accept="image/*" title="Upload an Image" onchange="triggerImagePreviewAndCrop(event, 'uprop')">
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="text" name="upropLink" class="form-control" title="Property link" placeholder="Property link">
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-link" title="Property Link"></span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="input-group mb-3">
                            <select name="uproptype" class="form-control select2bs4" title="Property Type" required>
                                <option selected="selected">Please Select a Property Type</option>
                                <option value="1">Residential</option>
                                <option value="2">Multi Family</option>
                                <option value="3">Light Commercial</option>
                                <option value="4">Commercial</option>
                            </select>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-building-columns" title="Property Type"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="text" name="upropname" class="form-control" title="Property Name" placeholder="Property Name" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card" title="Property Name"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="text" name="upropaddress" class="form-control" title="Property Address" placeholder="Property Address" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-map-location-dot" title="Property Address"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="text" name="upropcity" class="form-control" title="City" placeholder="City" required>
                            <div class="input-group-append">
                                <select name="upropstate" class="form-control select2bs4" style="width: 100%;" title="State" required>
                                    <option value="" selected="selected">Select a State</option>
                                    <option value="AL">Alabama</option>
                                    <option value="AK">Alaska</option>
                                    <option value="AZ">Arizona</option>
                                    <option value="AR">Arkansas</option>
                                    <option value="CA">California</option>
                                    <option value="CO">Colorado</option>
                                    <option value="CT">Connecticut</option>
                                    <option value="DE">Delaware</option>
                                    <option value="DC">District Of Columbia</option>
                                    <option value="FL">Florida</option>
                                    <option value="GA">Georgia</option>
                                    <option value="HI">Hawaii</option>
                                    <option value="ID">Idaho</option>
                                    <option value="IL">Illinois</option>
                                    <option value="IN">Indiana</option>
                                    <option value="IA">Iowa</option>
                                    <option value="KS">Kansas</option>
                                    <option value="KY">Kentucky</option>
                                    <option value="LA">Louisiana</option>
                                    <option value="ME">Maine</option>
                                    <option value="MD">Maryland</option>
                                    <option value="MA">Massachusetts</option>
                                    <option value="MI">Michigan</option>
                                    <option value="MN">Minnesota</option>
                                    <option value="MS">Mississippi</option>
                                    <option value="MO">Missouri</option>
                                    <option value="MT">Montana</option>
                                    <option value="NE">Nebraska</option>
                                    <option value="NV">Nevada</option>
                                    <option value="NH">New Hampshire</option>
                                    <option value="NJ">New Jersey</option>
                                    <option value="NM">New Mexico</option>
                                    <option value="NY">New York</option>
                                    <option value="NC">North Carolina</option>
                                    <option value="ND">North Dakota</option>
                                    <option value="OH">Ohio</option>
                                    <option value="OK">Oklahoma</option>
                                    <option value="OR">Oregon</option>
                                    <option value="PA">Pennsylvania</option>
                                    <option value="RI">Rhode Island</option>
                                    <option value="SC">South Carolina</option>
                                    <option value="SD">South Dakota</option>
                                    <option value="TN">Tennessee</option>
                                    <option value="TX">Texas</option>
                                    <option value="UT">Utah</option>
                                    <option value="VT">Vermont</option>
                                    <option value="VA">Virginia</option>
                                    <option value="WA">Washington</option>
                                    <option value="WV">West Virginia</option>
                                    <option value="WI">Wisconsin</option>
                                    <option value="WY">Wyoming</option>
                                </select>
                            </div>
                            <input type="text" name="upropzip" class="form-control" title="ZipCode" placeholder="ZipCode" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-map-location-dot" title="ZipCode"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="text" name="upropCon" class="form-control" title="Contact Name" placeholder="Contact Name">
                            <input type="text" name="upropConPh" class="form-control" title="Contact Number" oninput="formatPhoneNumber(this)" onpaste="handlePaste(event)" placeholder="Contact Number">
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card" title="Contact Name and Number"></span>
                                </div>
                            </div>
                        </div>
                        <?php if ($_SESSION['layer'] === 'super_admin' || $_SESSION['layer'] === 'admin' || $_SESSION['layer'] === 'dealer'): ?>
                            <div class="input-group mb-3">
                                <select name="uorganization_id" id="uorganization_id" class="form-control select2bs4" title="Organization" required></select>
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fa-solid fa-sitemap" title="Organization"></span>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>

                        <!-- <div class="input-group mb-3">
                            <label>Demo Expiry Date</label>
                            <input type="date" name="propdemo" class="form-control" placeholder="Enter Demo Expiry Date">
                        </div> -->
                        <div class="input-group mb-3">
                            <input type="text" name="upropnotes" class="form-control" title="Notes" placeholder="Enter Notes">
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-comment-dots" title="Notes"></span>
                                </div>
                            </div>
                        </div>
                        <button type="submit" id="updateprop" name="updateprop" class="btn btn-primary btn-block">Update Property</button>
                    </form>  
                </div> 
            </div>
        </div>
    </div>

    <!-- Cropping modal -->
    <div id="cropModal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Crop Image</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <div class="img-container">
                        <img id="imageToCrop" src="" alt="Image for cropping">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" id="cropImage">Crop</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <div id="ucropModal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Crop Image</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <div class="img-container">
                        <img id="uimageToCrop" src="" alt="Image for cropping">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" id="ucropImage">Crop</button>
                    <button type="button" class="btn btn-secondary" id="fullImage" data-dismiss="modal">Full</button>
                </div>
            </div>
        </div>
    </div>

      <!-- Add Organization Modal Start -->
    <div class="modal fade" id="orgmodal" tabindex="-1" role="dialog" aria-labelledby="orgmodalTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="orgmodalTitle">Add New Organization</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="include/properties/organization.php" method="post">
                        <div class="input-group mb-3">
                            <input type="text" name="orgname" class="form-control" title="Organization Name" placeholder="Organization Name" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card" title="Organization Name"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="text" name="orgaddress" class="form-control" title="Address" placeholder="Address" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-map-location-dot" title="Address"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="text" name="orgcity" class="form-control" title="City" placeholder="City" required>
                            <div class="input-group-append">
                                <select name="orgstate" class="form-control select2bs4" style="width: 100%;" title="State" required>
                                        <option value="" selected="selected">Select a State</option>
                                        <option value="AL">Alabama</option>
                                        <option value="AK">Alaska</option>
                                        <option value="AZ">Arizona</option>
                                        <option value="AR">Arkansas</option>
                                        <option value="CA">California</option>
                                        <option value="CO">Colorado</option>
                                        <option value="CT">Connecticut</option>
                                        <option value="DE">Delaware</option>
                                        <option value="DC">District Of Columbia</option>
                                        <option value="FL">Florida</option>
                                        <option value="GA">Georgia</option>
                                        <option value="HI">Hawaii</option>
                                        <option value="ID">Idaho</option>
                                        <option value="IL">Illinois</option>
                                        <option value="IN">Indiana</option>
                                        <option value="IA">Iowa</option>
                                        <option value="KS">Kansas</option>
                                        <option value="KY">Kentucky</option>
                                        <option value="LA">Louisiana</option>
                                        <option value="ME">Maine</option>
                                        <option value="MD">Maryland</option>
                                        <option value="MA">Massachusetts</option>
                                        <option value="MI">Michigan</option>
                                        <option value="MN">Minnesota</option>
                                        <option value="MS">Mississippi</option>
                                        <option value="MO">Missouri</option>
                                        <option value="MT">Montana</option>
                                        <option value="NE">Nebraska</option>
                                        <option value="NV">Nevada</option>
                                        <option value="NH">New Hampshire</option>
                                        <option value="NJ">New Jersey</option>
                                        <option value="NM">New Mexico</option>
                                        <option value="NY">New York</option>
                                        <option value="NC">North Carolina</option>
                                        <option value="ND">North Dakota</option>
                                        <option value="OH">Ohio</option>
                                        <option value="OK">Oklahoma</option>
                                        <option value="OR">Oregon</option>
                                        <option value="PA">Pennsylvania</option>
                                        <option value="RI">Rhode Island</option>
                                        <option value="SC">South Carolina</option>
                                        <option value="SD">South Dakota</option>
                                        <option value="TN">Tennessee</option>
                                        <option value="TX">Texas</option>
                                        <option value="UT">Utah</option>
                                        <option value="VT">Vermont</option>
                                        <option value="VA">Virginia</option>
                                        <option value="WA">Washington</option>
                                        <option value="WV">West Virginia</option>
                                        <option value="WI">Wisconsin</option>
                                        <option value="WY">Wyoming</option>
                                    </select>
                            </div>
                            <input type="text" name="orgzip" class="form-control" oninput="validateAndLimitInput(this)" title="ZipCode" pattern="[0-9]{5}" placeholder="ZipCode" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-map-location-dot" title="City, State and Zip"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="text" name="orgcontact" class="form-control" title="Contact Name" placeholder="Contact Name">
                            <input type="text" name="orgcontactphone" class="form-control" title="Contact Number" oninput="formatPhoneNumber(this)" onpaste="handlePaste(event)" placeholder="Contact Number">
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card" title="Contact Name and Number"></span>
                                </div>
                            </div>
                        </div>
                        <button type="submit" name="submitneworg" class="btn btn-primary btn-block">Add Organization</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="uorgmodal" tabindex="-1" role="dialog" aria-labelledby="orgmodalTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="uorgmodalTitle">Update Organization</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="include/properties/organization.php" method="post">
                        <div class="input-group mb-3">
                            <input type="text" name="uorgname" class="form-control" title="Organization Name" placeholder="Organization Name" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card" title="Organization Name"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="text" name="uorgaddress" class="form-control" title="Address" placeholder="Address" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-map-location-dot" title="Address"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="text" name="uorgcity" class="form-control" title="City" placeholder="City" required>
                            <div class="input-group-append">
                                <select name="uorgstate" class="form-control select2bs4" style="width: 100%;" title="State" required>
                                        <option value="" selected="selected">Select a State</option>
                                        <option value="AL">Alabama</option>
                                        <option value="AK">Alaska</option>
                                        <option value="AZ">Arizona</option>
                                        <option value="AR">Arkansas</option>
                                        <option value="CA">California</option>
                                        <option value="CO">Colorado</option>
                                        <option value="CT">Connecticut</option>
                                        <option value="DE">Delaware</option>
                                        <option value="DC">District Of Columbia</option>
                                        <option value="FL">Florida</option>
                                        <option value="GA">Georgia</option>
                                        <option value="HI">Hawaii</option>
                                        <option value="ID">Idaho</option>
                                        <option value="IL">Illinois</option>
                                        <option value="IN">Indiana</option>
                                        <option value="IA">Iowa</option>
                                        <option value="KS">Kansas</option>
                                        <option value="KY">Kentucky</option>
                                        <option value="LA">Louisiana</option>
                                        <option value="ME">Maine</option>
                                        <option value="MD">Maryland</option>
                                        <option value="MA">Massachusetts</option>
                                        <option value="MI">Michigan</option>
                                        <option value="MN">Minnesota</option>
                                        <option value="MS">Mississippi</option>
                                        <option value="MO">Missouri</option>
                                        <option value="MT">Montana</option>
                                        <option value="NE">Nebraska</option>
                                        <option value="NV">Nevada</option>
                                        <option value="NH">New Hampshire</option>
                                        <option value="NJ">New Jersey</option>
                                        <option value="NM">New Mexico</option>
                                        <option value="NY">New York</option>
                                        <option value="NC">North Carolina</option>
                                        <option value="ND">North Dakota</option>
                                        <option value="OH">Ohio</option>
                                        <option value="OK">Oklahoma</option>
                                        <option value="OR">Oregon</option>
                                        <option value="PA">Pennsylvania</option>
                                        <option value="RI">Rhode Island</option>
                                        <option value="SC">South Carolina</option>
                                        <option value="SD">South Dakota</option>
                                        <option value="TN">Tennessee</option>
                                        <option value="TX">Texas</option>
                                        <option value="UT">Utah</option>
                                        <option value="VT">Vermont</option>
                                        <option value="VA">Virginia</option>
                                        <option value="WA">Washington</option>
                                        <option value="WV">West Virginia</option>
                                        <option value="WI">Wisconsin</option>
                                        <option value="WY">Wyoming</option>
                                    </select>
                            </div>
                            <input type="text" name="uorgzip" class="form-control" title="ZipCode" placeholder="ZipCode" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-map-location-dot" title="City, State and Zip"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="text" name="uorgcontact" class="form-control" title="Contact Name" placeholder="Contact Name">
                            <input type="text" name="uorgcontactphone" class="form-control" title="Contact Number" oninput="formatPhoneNumber(this)" onpaste="handlePaste(event)" placeholder="Contact Number">
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card" title="Contact Name and Number"></span>
                                </div>
                            </div>
                        </div>
                        <?php if ($_SESSION['layer'] === 'super_admin' || $_SESSION['layer'] === 'admin'): ?>
                        <div class="input-group mb-3">
                            <select name="udealerid" id="udealerid" class="form-control select2bs4" title="Dealer" required></select>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-user" title="Dealer"></span>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                        <button type="submit" id="uupdateOrg" name="uupdateorg" class="btn btn-primary btn-block">Update Organization</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- Dealer Slots Modal -->
    <div class="modal fade" id="dealerslotsmodal" tabindex="-1" role="dialog" aria-labelledby="dealerslotsmodalTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="dealerslotsmodalTitle">Manage Dealer Slots</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="dealerslotsform">
                        <div class="form-group">
                            <label for="dealer">Dealer</label>
                            <select id="dealer" name="dealer_id" class="form-control" required></select>
                        </div>
                        <div class="form-group">
                            <label for="slots">Slots</label>
                            <input type="number" id="slots" name="slots" class="form-control" required>
                        </div>
                        <button type="button" class="btn btn-primary" onclick="addSlots()">Add Slots</button>
                        <button type="button" class="btn btn-danger" onclick="removeSlots()">Remove Slots</button>
                    </form>

                    <hr>

                    <form id="dealerCameraSlotForm">
                        <div class="form-group">
                            <input type="hidden" name="dealer_id" id="cameraDealerId">
                            <label for="ftpServerSlotContainer">Camera Slot Allocation by FTP Server</label>
                            <div id="ftpServerSlotContainer"></div>
                        </div>
                        <button type="button" class="btn btn-success" onclick="updateCameraSlots()">Update Camera Slot Allocation</button>
                    </form>
                    <div id="dealerslotsresult"></div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="confirm_voip_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="delete_number_modal_content"></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                    <p>Are you sure you want to add VOIP Setting of <span id="voip_property_name"></span> </p>
                    <div class="modal-footer">
                        <input type="hidden" name="voip_prop_id" id="voip_prop_id">
                        <button type="button" name="assign" onclick="add_property_voip_setting()" class="btn btn-success">Confirm</button>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    </div>
                </form>  
            </div> 
        </div>
    </div>
</div>

<div class="modal fade" id="property_image_modal" tabindex="-1" role="dialog" aria-labelledby="snapImageModalTitle" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" style="width: 600px;height: 650px;" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Property Image</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body text-center">
                    <img id="property_image" src="" alt="Property" class="img-fluid" style="max-width: 100%; object-fit: contain;">
                </div>
            </div>
        </div>
    </div>
<script src="js/my_properties_help.js"></script>