<?php

    try {
        session_start();
        //code...
        require '../../db.php';
        require '../auth/auth_functions.php';
        
        if (!currentUserHasAccess($pdo, 'my_roles', 'read')) {
            echo "Access denied.";
            // echo '<meta http-equiv="refresh" content="2">';
            exit();
        }
    } catch (\Throwable $th) {
        // throw $th;
    }

?>

<button type="button" id="addRole" class="btn btn-block btn-dark" data-toggle="modal" data-backdrop="static" data-keyboard="false" data-target="#rolemodal" style="margin:1rem 0 1rem .5rem;width:auto;">+ Add Role</button>
<!-- /.row -->
<div class="col-12">
    <div class="row">
        <div class="col-12" style="margin-top: 20px;">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Role Templates</h3>
                </div>
                <!-- ./card-header -->
                <div class="card-body">
                    <table class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>Role</th>
                                <th>Description</th>
                            </tr>
                        </thead>
                        <tbody id='roleTemplates'></tbody>
                    </table>
                </div>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->
        </div>
    </div>
</div>
<!-- /.row -->
<!-- /.row -->
<div class="col-12">
    <div class="row">
        <div class="col-12" style="margin-top: 20px;">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Your Custom Roles</h3>
                </div>
                <!-- ./card-header -->
                <div class="card-body">
                    <table class="table table-bordered table-hover">
                        <thead>
                            <?php
                                if ($_SESSION['layer'] === 'super_admin' || $_SESSION['layer'] === 'admin' || $_SESSION['layer'] === 'dealer' || $_SESSION['layer'] === 'sub_dealer' || $_SESSION['layer'] === 'organization admin') {
                                    ?>
                                        <tr id="multi">
                                            <th>Role Name</th>
                                            <th>Template Used</th>
                                            <th>Created By</th>
                                            <th>Usage</th>
                                            <th>Site ID</th>
                                        </tr>
                                    <?php
                                }else {
                                    ?>
                                        <tr id="single">
                                            <th>Role Name</th>
                                            <th>Template Used</th>
                                            <th>Usage</th>
                                        </tr>
                                    <?php
                                }
                            ?>
                        </thead>
                        <tbody id='currentRoles'></tbody>
                    </table>
                </div>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->
        </div>
    </div>
</div>
<!-- /.row -->
<div class="modal fade" id="rolemodal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalCenterTitle">Create a new Role</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <!-- Main content -->
                    <div class="col-12" style="margin-top: 20px;">
                          
                            <!-- /.card-header -->
                            <form id="roleForm" action="include/properties/customrole.php" method="post">
                                <label style="margin:2%;">Name Your New Role</label>
                                <input type="test" name="roleName" required>
                                <br>
                                <label style="margin:2%;">Select Your Template</label>
                                <select id="layerlist" name ="layerList" required><option disabled selected>Please Select</option></select>
                                <br>
                                <label style="margin:2%;">Select Property</label>
                                <select id="proplist" name ="propList" required><option disabled selected>Please Select</option></select>
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">Role Builder</h3>
                                    </div>
                                    <div id="jsGrid1"></div>
                                </div>
                                <button type="submit">Submit</button>
                            </form>
                            <!-- /.card-body -->
                        
                        <!-- /.card -->
                    </div>
                    <!-- /.content -->
                <!-- <form id="customrole" method="post">
                    <label for="email">Role Name:</label>
                    <input type="text" id="rname" name="rname" required>
                    <select id="role" name="role" required>
                        <option value="" selected disabled>Please Select Layer</option>
                        <option value="property_admin">Property Admin</option>
                        <option value="user">User</option>
                        <option value="visitor">Visitor</option>
                    </select>
                    <input type="submit" value="Create Role">
                </form> -->

                </div> 
            </div>
        </div>
    </div>
