<?php

function get_hardware_devices() {
    // Get doors/gates with their hardware device info (only web_Relay devices)
    $doors_query = "
        SELECT 
            hs.*, 
            gd.id AS door_id, 
            gd.door_name, 
            gd.door_image,
            hd.device_type AS hardware_device_type,
            hd.model AS hardware_model,
            hd.user_name AS hardware_username,
            hd.password AS hardware_password,
            hd.complete_url AS hardware_complete_url,
            'door' AS device_type
        FROM hardwares_settings hs
        LEFT JOIN gate_doors gd 
            ON hs.assigned_door = gd.id
        LEFT JOIN hardware_devices hd 
            ON hs.device_id = hd.id
        WHERE hs.property_id = :property_id
          AND hd.device_type = 'web_Relay'
    ";
    
    $doors = fetchDataWithJoins($doors_query, ['property_id' => $_SESSION['property']]);
    return $doors;
}

try {
    if (session_status() === PHP_SESSION_NONE) session_start();
    include '../../helper_functions/data_request.php';
    include '../../../db.php';
    $hardware_devices=get_hardware_devices();

} catch (\Throwable $th) {
    echo $th->getMessage();
}
?>

<script src="js/property_builder/hardware_automations.js"></script>

<div class="d-flex justify-content-between align-items-center">
    <div>
        <button type="button" onclick="resetAutomationForm()" data-toggle="modal" data-target="#addNewAutomation" class="btn btn-block btn-dark mt-3"><i class="fa-solid fa-plus"></i> Automation</button>
    </div>
</div>

<div class="automations-container">   

    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Input Automations</h3>
            <!-- Search bar -->
            <div class="card-tools">
                <div class="input-group input-group-sm" style="width: 250px;">
                    <input type="text" id="searchInputAutomationInput" onkeyup="searchInputAutomations()" class="form-control float-right" placeholder="Search automations">
                    <div class="input-group-append">
                        <button type="button" class="btn btn-default">
                            <i class="fas fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div id="automations_container" class="table-responsive" style="overflow-x: auto !important;">
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="addNewAutomation" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalCenterTitle">Hardware Automation</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="addAutomationForm">
                    <input type="hidden" id="automationId" name="automationId">
                    <div class="form-group">
                        <label for="hardware_device_id">Door name*</label>
                        <select class="form-control" id="hardware_device_id" name="hardware_device_id" onchange="get_hardware_device_details(this.value)">
                            <option value="" disabled selected>Select Hardware Device</option>
                            <?php foreach ($hardware_devices as $hardware_device) { ?>
                                <option value="<?php echo $hardware_device['id']; ?>"><?php echo $hardware_device['door_name']; ?></option>
                            <?php } ?>
                        </select>
                    </div>

                    <div id="automation_fields">
                        
                    </div>
                                

                    <div class="modal-footer">
                        <button type="button" id="addAutomation_button" class="btn btn-secondary">Add Automation</button>
                    </div>

                </form>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="editAutomationModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalCenterTitle">Edit Hardware Automation</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="addAutomationForm">
                    <input type="hidden" id="automationId" name="automationId">
                    <input type="hidden" id="automation_input" name="automation_input">
                    <input type="hidden" id="automation_output" name="automation_output">
                    <div id="edit_automation_fields">
                    </div>
                    <div class="modal-footer">
                        <button type="button" id="addAutomation_button" onclick="updateAutomation()" class="btn btn-secondary">Update Automation</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

