<?php

try {
    if (session_status() === PHP_SESSION_NONE) session_start();
    require './qr_code_essentials.php';
    // print_r($allProperties);
} catch (\Throwable $th) {
    // throw $th;
}
?>


<script src="../../../js/settings/property-builders.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/fabric.js/4.6.0/fabric.min.js"></script>
<script src="https://uicdn.toast.com/tui-color-picker/latest/tui-color-picker.js"></script>
<script src="https://uicdn.toast.com/tui-image-editor/latest/tui-image-editor.js"></script>

<div id="qrCode_view">

    <div class="d-flex justify-content-between align-items-center flex-wrap my-3">
        <div class="d-flex flex-wrap">
            <button type="button" id="qrCodeAddButton" onclick="addNewQrCode()" class="btn btn-block btn-dark" data-toggle="modal" data-backdrop="static" data-keyboard="false" data-target="#addQrCode" style="margin:0.35rem 0;width:110px;"> <i class="fa-solid fa-plus"></i> QR Code</button>
            <button type="button" id="viewTemplates" onclick="viewAllTemplates()" class="btn btn-block btn-dark ml-2" style="margin:0.35rem 0;width:138px;">View Templates</button>
            <button type="button" id="viewTemplates" onclick="viewAllOrders()" class="btn btn-block btn-dark ml-2" style="margin:0.35rem 0;width:138px;">View Order</button>
        </div>
    </div>

    <div class="d-flex flex-wrap align-items-center justify-content-center" id="qrCodeWrap">
    </div>
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">My QR Codes</h3>
            <!-- Search bar -->
            <div class="card-tools">
                <div class="input-group input-group-sm" style="width: 250px;">
                    <input type="text" id="search_qr_code_value" onkeyup="searchQrCodes()" class="form-control float-right" placeholder="Search QR Code">
                    <div class="input-group-append">
                        <button type="button" class="btn btn-default">
                            <i class="fas fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="justify-content-center" id="qrCodeLoader" style="display: none;">
                <div class="loader_image">
                    <img src="/include/images/loader.gif" alt="">
                </div>
            </div>

            <div class="" id="QR_Code_table"> </div>
        </div>
    </div>
</div>

<div id="downloadAreaQrCode"></div>

<div id="order_view" style="display:none;">
    <div class="d-flex justify-content-between align-items-center flex-wrap my-3">
        <div class="d-flex">
            <button type="button" id="viewTemplates" onclick="goBackToQrView()" class="btn btn-block btn-dark ml-2" style="margin:1rem 0 1rem 0rem;width:auto;">Back</button>
        </div>

        <div class="" id="changeOrdersSwitchViewEleContainer">
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <h3 class="card-title">My Vinyl Orders</h3>
            <!-- Search bar -->
            <div class="card-tools">
                <div class="input-group input-group-sm" style="width: 250px;">
                    <input type="text" id="search_qr_order_value" onkeyup="searchQrOrders()" class="form-control float-right" placeholder="Search Vinyl Order">
                    <div class="input-group-append">
                        <button type="button" class="btn btn-default">
                            <i class="fas fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="justify-content-center" id="qrCodeLoader" style="display: none;">
                <div class="loader_image">
                    <img src="/include/images/loader.gif" alt="">
                </div>
            </div>

            <div class="" id="vinylOrderTable"> </div>
        </div>
    </div>
</div>


<!-- View template Modal -->
<div class="modal fade" id="QrCodePreviewModal" tabindex="-1" role="dialog" aria-labelledby="addEditQrCode" aria-hidden="true">
    <div class="modal-dialog modal-dialog-area" role="document" style="min-height:90vh">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Qr Code Design</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

                <div id="QrCodeDesignPreviewContainer" style="width: 56vh;height: 60vh;margin: auto;"></div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>


<!--Qr code modals here -->
<div class="modal fade" id="addQrCode" tabindex="-1" role="dialog" aria-labelledby="addEditQrCode" aria-hidden="true">
    <div class="modal-dialog modal-dialog-area modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addEditQrCode">Add Qr Code</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" style="overflow-y: auto; max-height: calc(100vh - 200px);">
                <form>
                    <!-- Hidden input for the QR code ID -->
                    <input type="hidden" name="qr_id" id="qr_id" value="">
                    <div class="form-group">
                        <label for="templateId">Template</label>
                        <select name="type" id="templateId" required="required" class="form-control select2bs4" style="width: 100%;">
                            <option value="" disabled>Select a theme for qr code</option>
                            <?php foreach ($allTemplates as $template) : ?>
                                <option value="<?= htmlspecialchars($template['id']) ?>">
                                    <?= htmlspecialchars($template['templateName']) ?>
                                </option>
                            <?php endforeach; ?>
                            <!-- <option value="phone" selected="selected">Phone</option> -->
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="qr_phone_number">Phone Number*</label>
                        <select class="form-control custom-select" id="qr_phone_number">
                            <option selected disabled>Select one</option>
                        </select>
                    </div>
                    
                    <button type="button" class="btn btn-secondary" onclick="generatePreviewForQrCode()">Preview</button>
                    <!-- The preview will be inserted here by JavaScript -->
                    <div id="qr_code_design_preview"></div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" name="submitNewHardware" id="submitQrCodeButton" class="btn btn-primary" onclick="addQrCode()">Save</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Vinyl order Modal-->

<div class="modal fade" id="addVinylOrder" tabindex="-1" role="dialog" aria-labelledby="addVinylOrder" aria-hidden="true">
    <div class="modal-dialog modal-dialog-area modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addVinylOrder">Order Qr Code</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form>
                    <input type="hidden" name="QRCodeCodeId" id="QRCodeCodeId" value="">
                    <input type="hidden" name="order_id" id="order_id" value="">

                    <div class="form-group">
                        <label for="printQuantity">Quantity*</label>
                        <input type="number" name="printQuantity" id="printQuantity" class="form-control" min="1" value="1" required>
                    </div>

                    <div class="form-group">
                        <label for="vinylType">Vinyl Print Type*</label>
                        <select name="type" id="vinylType" required="required" class="form-control select2bs4" style="width: 100%;">
                            <option value="" disabled selected>Select a type of vinyl print</option>
                            <?php foreach ($vinylTypes as $value => $label) : ?>
                                <option value="<?= htmlspecialchars($value) ?>">
                                    <?= htmlspecialchars($label) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="size">Size*</label>
                        <div class="d-flex align-items-center  ">
                            <select name="type" id="vinylSize" required class="form-control select2bs4" style="width: 100%;">
                                <option value="" disabled selected>Select size</option>
                                <option value="letter">Letter</option>
                                <option value="A4">A4</option>
                            </select>
                            <!-- <input type="number" name="size" id="qrWidth" class="form-control" min="4" value="12" required>
                            <span class="px-3">X</span>
                            <input type="number" name="size" id="qrHeight" class="form-control" min="4" value="12" required> -->
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="shippingAddress">Shipping Address*</label>
                        <textarea name="shippingAddress" id="shippingAddress" class="form-control"></textarea>
                    </div>

                    <div class="modal-footer">
                        <button type="button" name="submitOrder" id="submitOrderButton" class="btn btn-primary" onclick="addVinylOrder()">Save</button>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="toast-container position-fixed p-3" id="qr_code_toastMessage" style="display:none;z-index: 99999; top: 20px; right: 0px;width:300px">
    <div id="qr_code_Toast" class="toast bg-danger text-white" role="alert" aria-live="assertive" aria-atomic="true">
        <div class="toast-header d-flex justify-content-between  ">
            <strong class="me-auto">Error</strong>
            <button onclick="closeQR_ToastMessage()" type="button" class="close " data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="toast-body" id="qr_code_ErrorMessage">
            An error occurred! Please check the details and try again.
        </div>
    </div>
</div>