<?php

function generate_qr_code_template($template_name, $template_html) {
    $template_html_edit='';
    if ($template_name == 'Default 1') {
        $decoded_html = urldecode($template_html);
        $template_html_edit=template_one_edit_mode($decoded_html);
        return $template_html_edit;
    } elseif ($template_name == 'Default 2') {
        $decoded_html = urldecode($template_html);
        $template_html_edit=template_two_edit_mode($decoded_html);
        return $template_html_edit;
    } elseif ($template_name == 'Default 3') {
        $decoded_html = urldecode($template_html);
        $template_html_edit=template_three_edit_mode($decoded_html);
        return $template_html_edit;
    }elseif ($template_name == 'Default 4') {
        $decoded_html = urldecode($template_html);
        $template_html_edit=template_three_edit_mode($decoded_html);
        return $template_html_edit;
    }
}

function get_template_table_html($QrTemplates) {
    ob_start();
    ?>
    <div class="table-responsive p-0">
        <table id="qrCodeTemplateDataTable" class="table table-bordered table-head-fixed text-nowrap table-hover">
            <thead>
                <tr>
                    <th>Template Name</th>
                    <th>Preview</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach ($QrTemplates as $template): ?>
                <tr>
                    <td style="vertical-align: middle;">
                        <?php echo htmlspecialchars($template['templateName']); ?>
                    </td>
                    <td style="vertical-align: middle;">
                        <div class="image_container">
                            <?php
                            if (isset($template['template_image']) && $template['template_image']) {
                                if (strpos($template['template_image'], '/include') !== false) {
                                    $template_image = $template['template_image'];
                                } else {
                                    $template_image = '/shared/serve_image.php?path=' . urlencode($template['template_image']) . '&type=all_images';
                                }
                                echo "<img src='" . htmlspecialchars($template_image) . "' alt='template image'/>";
                            } else {
                                echo "<img src='/include/images/qr-code.svg' alt='template image'/>";
                            }
                            ?>
                        </div>
                    </td>
                    <td style="vertical-align: middle;">
                        <i class="fas fa-eye text-info mx-1 cursor_pointer getDataForTemplatePreviewButton"
                           data-id="<?php echo $template['id']; ?>"
                           title="Preview"
                           onclick="getDataForTemplatePreview('<?php echo $template['id']; ?>')"></i>
                        <i class="fas fa-edit text-primary templatesDataGetByIdButton cursor_pointer"
                           data-id="<?php echo $template['id']; ?>"
                           onclick="changeTemplateModeToEdit('<?php echo $template['id']; ?>')"></i>
                        <?php if ($template['is_default'] == 0): ?>
                            <i class="fa-solid fa-rotate text-danger cursor_pointer"
                                title="Revert Changes"
                                onclick="revertTemplateChanges('<?php echo $template['id']; ?>')"></i>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php
    return ob_get_clean();
}

function get_template_html_card($QrTemplates) {
    ob_start();
    if (!$QrTemplates || count($QrTemplates) === 0) { ?>
        <div class="no-data-card" style="text-align: center; margin: 20px;">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">No Data Available</h5>
                    <p class="card-text">There are no QR code templates to display at the moment.</p>
                </div>
            </div>
        </div>
    <?php } else { ?>
        <div class="" style="display:flex; gap:15px; flex-wrap:wrap">
            <?php foreach ($QrTemplates as $item): ?>
                <?php
                if (isset($item['template_image']) && strpos($item['template_image'], '/include') !== false) {
                    $template_image = $item['template_image'];
                } else {
                    $template_image = '/shared/serve_image.php?path=' . urlencode($item['template_image']) . '&type=all_images';
                }
                ?>
                <div>
                    <div class="card mb-3">
                        <div class="card-header d-flex align-items-center">
                            <h5 class="mb-0"><?php echo htmlspecialchars($item['templateName'] ?? 'N/A'); ?></h5>
                            <div class="ml-auto">
                                <i class="fas fa-eye text-info mx-1 cursor_pointer getDataForTemplatePreviewButton"
                                   data-id="<?php echo htmlspecialchars($item['id']); ?>"
                                   title="Preview"
                                   onclick="getDataForTemplatePreview('<?php echo htmlspecialchars($item['id']); ?>')"></i>
                                <i class="fas fa-edit text-primary templatesDataGetByIdButton cursor_pointer"
                                   data-id="<?php echo htmlspecialchars($item['id']); ?>"
                                   onclick="changeTemplateModeToEdit('<?php echo htmlspecialchars($item['id']); ?>')"></i>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="image_container">
                                <img src="<?php echo htmlspecialchars($template_image); ?>" alt="template image"/>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php }
    return ob_get_clean();
}

function template_one_edit_mode($template_html){
    $editIconTemplate = '<svg class="edit-icon" data-edit-id="EDIT_ID" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#888" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="vertical-align:middle; margin-left:8px; cursor:pointer;"><path d="M12 20h9"/><path d="M16.5 3.5a2.121 2.121 0 0 1 3 3L7 19.5 3 21l1.5-4L16.5 3.5z"/></svg>';
    
    $imageEditIconTemplate = '<svg class="edit-icon" data-edit-id="EDIT_ID" data-edit-type="image" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#888" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="vertical-align:middle; margin-left:8px; cursor:pointer;"><path d="M12 20h9"/><path d="M16.5 3.5a2.121 2.121 0 0 1 3 3L7 19.5 3 21l1.5-4L16.5 3.5z"/></svg>';

    $doc = new DOMDocument();
    libxml_use_internal_errors(true);
    $doc->loadHTML('<?xml encoding="utf-8" ?>' . $template_html);

    $xpath = new DOMXPath($doc);
    $editId = 1;
    
    // Add icon to the welcome image
    $welcomeImageElement = $xpath->query('//img[@id="welcome-image-img"]')->item(0);
    if ($welcomeImageElement) {
        $outerDiv = $doc->createElement('div');
        $divId = 'edit-' . $editId;
        $outerDiv->setAttribute('id', $divId);
        $outerDiv->setAttribute('class', 'welcome-image');
        $outerDiv->setAttribute('style', 'display: inline-block; position: relative;');
        $welcomeImageElement->parentNode->replaceChild($outerDiv, $welcomeImageElement);
        $outerDiv->appendChild($welcomeImageElement);
        $editIcon = str_replace('EDIT_ID', $divId, $imageEditIconTemplate);
        $fragment = $doc->createDocumentFragment();
        $fragment->appendXML($editIcon);
        if ($outerDiv->nextSibling) {
            $outerDiv->parentNode->insertBefore($fragment, $outerDiv->nextSibling);
        } else {
            $outerDiv->parentNode->appendChild($fragment);
        }
        $editId++;
    }
    
    // Add icon to the welcome image
    $logoImageElement = $xpath->query('//img[@id="logo-image-img"]')->item(0);
    if ($logoImageElement) {
        $outerDiv = $doc->createElement('div');
        $divId = 'edit-' . $editId;
        $outerDiv->setAttribute('id', $divId);
        $outerDiv->setAttribute('class', 'logo-image');
        $outerDiv->setAttribute('style', 'display: inline-block; position: relative;');
        $logoImageElement->parentNode->replaceChild($outerDiv, $logoImageElement);
        $outerDiv->appendChild($logoImageElement);
        $editIcon = str_replace('EDIT_ID', $divId, $imageEditIconTemplate);
        $fragment = $doc->createDocumentFragment();
        $fragment->appendXML($editIcon);
        if ($outerDiv->nextSibling) {
            $outerDiv->parentNode->insertBefore($fragment, $outerDiv->nextSibling);
        } else {
            $outerDiv->parentNode->appendChild($fragment);
        }
        $editId++;
    }
    
    // Add icon to the for_access_please_call span
    $accessElement = $xpath->query('//span[@id="for_access_please_call"]')->item(0);
    if ($accessElement) {
        // Wrap the span in another span with a unique id
        $outerSpan = $doc->createElement('span');
        $spanId = 'edit-' . $editId;
        $outerSpan->setAttribute('id', $spanId);
        $accessElement->parentNode->replaceChild($outerSpan, $accessElement);
        $outerSpan->appendChild($accessElement);
        // Add the edit icon after the outer span
        $editIcon = str_replace('EDIT_ID', $spanId, $editIconTemplate);
        $fragment = $doc->createDocumentFragment();
        $fragment->appendXML($editIcon);
        if ($outerSpan->nextSibling) {
            $outerSpan->parentNode->insertBefore($fragment, $outerSpan->nextSibling);
        } else {
            $outerSpan->parentNode->appendChild($fragment);
        }
        $editId++;
    }

    // Add icon to the or span
    $orElement = $xpath->query('//span[@id="or"]')->item(0);
    if ($orElement) {
        // Wrap the span in another span with a unique id
        $outerSpan = $doc->createElement('span');
        $spanId = 'edit-' . $editId;
        $outerSpan->setAttribute('id', $spanId);
        $orElement->parentNode->replaceChild($outerSpan, $orElement);
        $outerSpan->appendChild($orElement);
        // Add the edit icon after the outer span
        $editIcon = str_replace('EDIT_ID', $spanId, $editIconTemplate);
        $fragment = $doc->createDocumentFragment();
        $fragment->appendXML($editIcon);
        if ($outerSpan->nextSibling) {
            $outerSpan->parentNode->insertBefore($fragment, $outerSpan->nextSibling);
        } else {
            $outerSpan->parentNode->appendChild($fragment);
        }
        $editId++;
    }
    
    // Add icon to the scan_to_call span
    $scanElement = $xpath->query('//span[@id="scan_to_call"]')->item(0);
    if ($scanElement) {
        // Wrap the span in another span with a unique id
        $outerSpan = $doc->createElement('span');
        $spanId = 'edit-' . $editId;
        $outerSpan->setAttribute('id', $spanId);
        $scanElement->parentNode->replaceChild($outerSpan, $scanElement);
        $outerSpan->appendChild($scanElement);
        // Add the edit icon after the outer span
        $editIcon = str_replace('EDIT_ID', $spanId, $editIconTemplate);
        $fragment = $doc->createDocumentFragment();
        $fragment->appendXML($editIcon);
        if ($outerSpan->nextSibling) {
            $outerSpan->parentNode->insertBefore($fragment, $outerSpan->nextSibling);
        } else {
            $outerSpan->parentNode->appendChild($fragment);
        }
        $editId++;
    }
    
    // Add icon to the logo image
    $logoImageElement = $xpath->query('//img[@id="logo-image-img"]')->item(0);
    if ($logoImageElement) {
        $outerDiv = $doc->createElement('div');
        $divId = 'edit-' . $editId;
        $outerDiv->setAttribute('id', $divId);
        $outerDiv->setAttribute('class', 'logo-image');
        $outerDiv->setAttribute('style', 'display: inline-block; position: relative;');
        $logoImageElement->parentNode->replaceChild($outerDiv, $logoImageElement);
        $outerDiv->appendChild($logoImageElement);
        $editIcon = str_replace('EDIT_ID', $divId, $imageEditIconTemplate);
        $fragment = $doc->createDocumentFragment();
        $fragment->appendXML($editIcon);
        if ($outerDiv->nextSibling) {
            $outerDiv->parentNode->insertBefore($fragment, $outerDiv->nextSibling);
        } else {
            $outerDiv->parentNode->appendChild($fragment);
        }
        $editId++;
    }
    
    // Extract the inner HTML of the body
    $body = $doc->getElementsByTagName('body')->item(0);
    $innerHTML = '';
    foreach ($body->childNodes as $child) {
        $innerHTML .= $doc->saveHTML($child);
    }
    return $innerHTML;
}

function template_two_edit_mode($template_html){
    $editIconTemplate = '<svg class="edit-icon" data-edit-id="EDIT_ID" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#888" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="vertical-align:middle; margin-left:8px; cursor:pointer;"><path d="M12 20h9"/><path d="M16.5 3.5a2.121 2.121 0 0 1 3 3L7 19.5 3 21l1.5-4L16.5 3.5z"/></svg>';
    
    $imageEditIconTemplate = '<svg class="edit-icon" data-edit-id="EDIT_ID" data-edit-type="image" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#888" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="vertical-align:middle; margin-left:8px; cursor:pointer;"><path d="M12 20h9"/><path d="M16.5 3.5a2.121 2.121 0 0 1 3 3L7 19.5 3 21l1.5-4L16.5 3.5z"/></svg>';

    $doc = new DOMDocument();
    libxml_use_internal_errors(true);
    $doc->loadHTML('<?xml encoding="utf-8" ?>' . $template_html);

    $xpath = new DOMXPath($doc);
    $editId = 1;
    
    // Add icon to the welcome_home span
    $welcomeElement = $xpath->query('//span[@id="welcome_home"]')->item(0);
    if ($welcomeElement) {
        // Wrap the span in another span with a unique id
        $outerSpan = $doc->createElement('span');
        $spanId = 'edit-' . $editId;
        $outerSpan->setAttribute('id', $spanId);
        $welcomeElement->parentNode->replaceChild($outerSpan, $welcomeElement);
        $outerSpan->appendChild($welcomeElement);
        // Add the edit icon after the outer span
        $editIcon = str_replace('EDIT_ID', $spanId, $editIconTemplate);
        $fragment = $doc->createDocumentFragment();
        $fragment->appendXML($editIcon);
        if ($outerSpan->nextSibling) {
            $outerSpan->parentNode->insertBefore($fragment, $outerSpan->nextSibling);
        } else {
            $outerSpan->parentNode->appendChild($fragment);
        }
        $editId++;
    }

    $logoImageElement = $xpath->query('//img[@id="logo-image-img"]')->item(0);
    if ($logoImageElement) {
        $outerDiv = $doc->createElement('div');
        $divId = 'edit-' . $editId;
        $outerDiv->setAttribute('id', $divId);
        $outerDiv->setAttribute('class', 'logo-image');
        $outerDiv->setAttribute('style', 'display: inline-block; position: relative;');
        $logoImageElement->parentNode->replaceChild($outerDiv, $logoImageElement);
        $outerDiv->appendChild($logoImageElement);
        $editIcon = str_replace('EDIT_ID', $divId, $imageEditIconTemplate);
        $fragment = $doc->createDocumentFragment();
        $fragment->appendXML($editIcon);
        if ($outerDiv->nextSibling) {
            $outerDiv->parentNode->insertBefore($fragment, $outerDiv->nextSibling);
        } else {
            $outerDiv->parentNode->appendChild($fragment);
        }
        $editId++;
    }
    
    // Add icon to the for_access_please_call span
    $accessElement = $xpath->query('//span[@id="for_access_please_call"]')->item(0);
    if ($accessElement) {
        // Wrap the span in another span with a unique id
        $outerSpan = $doc->createElement('span');
        $spanId = 'edit-' . $editId;
        $outerSpan->setAttribute('id', $spanId);
        $accessElement->parentNode->replaceChild($outerSpan, $accessElement);
        $outerSpan->appendChild($accessElement);
        // Add the edit icon after the outer span
        $editIcon = str_replace('EDIT_ID', $spanId, $editIconTemplate);
        $fragment = $doc->createDocumentFragment();
        $fragment->appendXML($editIcon);
        if ($outerSpan->nextSibling) {
            $outerSpan->parentNode->insertBefore($fragment, $outerSpan->nextSibling);
        } else {
            $outerSpan->parentNode->appendChild($fragment);
        }
        $editId++;
    }
    
    // Add icon to the or_text span
    $orElement = $xpath->query('//span[@id="or_text"]')->item(0);
    if ($orElement) {
        // Wrap the span in another span with a unique id
        $outerSpan = $doc->createElement('span');
        $spanId = 'edit-' . $editId;
        $outerSpan->setAttribute('id', $spanId);
        $orElement->parentNode->replaceChild($outerSpan, $orElement);
        $outerSpan->appendChild($orElement);
        // Add the edit icon after the outer span
        $editIcon = str_replace('EDIT_ID', $spanId, $editIconTemplate);
        $fragment = $doc->createDocumentFragment();
        $fragment->appendXML($editIcon);
        if ($outerSpan->nextSibling) {
            $outerSpan->parentNode->insertBefore($fragment, $outerSpan->nextSibling);
        } else {
            $outerSpan->parentNode->appendChild($fragment);
        }
        $editId++;
    }
    
    // Add icon to the scan_to_call span
    $scanElement = $xpath->query('//span[@id="scan_to_call"]')->item(0);
    if ($scanElement) {
        // Wrap the span in another span with a unique id
        $outerSpan = $doc->createElement('span');
        $spanId = 'edit-' . $editId;
        $outerSpan->setAttribute('id', $spanId);
        $scanElement->parentNode->replaceChild($outerSpan, $scanElement);
        $outerSpan->appendChild($scanElement);
        // Add the edit icon after the outer span
        $editIcon = str_replace('EDIT_ID', $spanId, $editIconTemplate);
        $fragment = $doc->createDocumentFragment();
        $fragment->appendXML($editIcon);
        if ($outerSpan->nextSibling) {
            $outerSpan->parentNode->insertBefore($fragment, $outerSpan->nextSibling);
        } else {
            $outerSpan->parentNode->appendChild($fragment);
        }
        $editId++;
    }
    
    // Add icon to the logo image
    $logoImageElement = $xpath->query('//img[@id="logo-image-img"]')->item(0);
    if ($logoImageElement) {
        $outerDiv = $doc->createElement('div');
        $divId = 'edit-' . $editId;
        $outerDiv->setAttribute('id', $divId);
        $outerDiv->setAttribute('class', 'logo-image');
        $outerDiv->setAttribute('style', 'display: inline-block; position: relative;');
        $logoImageElement->parentNode->replaceChild($outerDiv, $logoImageElement);
        $outerDiv->appendChild($logoImageElement);
        $editIcon = str_replace('EDIT_ID', $divId, $imageEditIconTemplate);
        $fragment = $doc->createDocumentFragment();
        $fragment->appendXML($editIcon);
        if ($outerDiv->nextSibling) {
            $outerDiv->parentNode->insertBefore($fragment, $outerDiv->nextSibling);
        } else {
            $outerDiv->parentNode->appendChild($fragment);
        }
        $editId++;
    }
    
    // Extract the inner HTML of the body
    $body = $doc->getElementsByTagName('body')->item(0);
    $innerHTML = '';
    foreach ($body->childNodes as $child) {
        $innerHTML .= $doc->saveHTML($child);
    }
    return $innerHTML;
}

function template_three_edit_mode($template_html){
    $editIconTemplate = '<svg class="edit-icon" data-edit-id="EDIT_ID" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#888" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="vertical-align:middle; margin-left:8px; cursor:pointer;"><path d="M12 20h9"/><path d="M16.5 3.5a2.121 2.121 0 0 1 3 3L7 19.5 3 21l1.5-4L16.5 3.5z"/></svg>';
    
    $imageEditIconTemplate = '<svg class="edit-icon" data-edit-id="EDIT_ID" data-edit-type="image" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#888" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="vertical-align:middle; margin-left:8px; cursor:pointer;"><path d="M12 20h9"/><path d="M16.5 3.5a2.121 2.121 0 0 1 3 3L7 19.5 3 21l1.5-4L16.5 3.5z"/></svg>';

    $doc = new DOMDocument();
    libxml_use_internal_errors(true);
    $doc->loadHTML('<?xml encoding="utf-8" ?>' . $template_html);

    $xpath = new DOMXPath($doc);
    $editId = 1;
    
    // Add icon to the welcome image
    $welcomeImageElement = $xpath->query('//img[@id="welcome-image-img"]')->item(0);
    if ($welcomeImageElement) {
        $outerDiv = $doc->createElement('div');
        $divId = 'edit-' . $editId;
        $outerDiv->setAttribute('id', $divId);
        $outerDiv->setAttribute('class', 'welcome-image');
        $outerDiv->setAttribute('style', 'display: inline-block; position: relative;');
        $welcomeImageElement->parentNode->replaceChild($outerDiv, $welcomeImageElement);
        $outerDiv->appendChild($welcomeImageElement);
        $editIcon = str_replace('EDIT_ID', $divId, $imageEditIconTemplate);
        $fragment = $doc->createDocumentFragment();
        $fragment->appendXML($editIcon);
        if ($outerDiv->nextSibling) {
            $outerDiv->parentNode->insertBefore($fragment, $outerDiv->nextSibling);
        } else {
            $outerDiv->parentNode->appendChild($fragment);
        }
        $editId++;
    }
    
    // Add icon to the logo image
    $logoImageElement = $xpath->query('//img[@id="logo-image-img"]')->item(0);
    if ($logoImageElement) {
        $outerDiv = $doc->createElement('div');
        $divId = 'edit-' . $editId;
        $outerDiv->setAttribute('id', $divId);
        $outerDiv->setAttribute('class', 'logo-image');
        $outerDiv->setAttribute('style', 'display: inline-block; position: relative;');
        $logoImageElement->parentNode->replaceChild($outerDiv, $logoImageElement);
        $outerDiv->appendChild($logoImageElement);
        $editIcon = str_replace('EDIT_ID', $divId, $imageEditIconTemplate);
        $fragment = $doc->createDocumentFragment();
        $fragment->appendXML($editIcon);
        if ($outerDiv->nextSibling) {
            $outerDiv->parentNode->insertBefore($fragment, $outerDiv->nextSibling);
        } else {
            $outerDiv->parentNode->appendChild($fragment);
        }
        $editId++;
    }

    $logoImageElement = $xpath->query('//img[@id="logo-image-img"]')->item(0);
    if ($logoImageElement) {
        $outerDiv = $doc->createElement('div');
        $divId = 'edit-' . $editId;
        $outerDiv->setAttribute('id', $divId);
        $outerDiv->setAttribute('class', 'logo-image');
        $outerDiv->setAttribute('style', 'display: inline-block; position: relative;');
        $logoImageElement->parentNode->replaceChild($outerDiv, $logoImageElement);
        $outerDiv->appendChild($logoImageElement);
        $editIcon = str_replace('EDIT_ID', $divId, $imageEditIconTemplate);
        $fragment = $doc->createDocumentFragment();
        $fragment->appendXML($editIcon);
        if ($outerDiv->nextSibling) {
            $outerDiv->parentNode->insertBefore($fragment, $outerDiv->nextSibling);
        } else {
            $outerDiv->parentNode->appendChild($fragment);
        }
        $editId++;
    }
    
    // Add icon to the welcome_home span
    $welcomeElement = $xpath->query('//span[@id="welcome_home"]')->item(0);
    if ($welcomeElement) {
        // Wrap the span in another span with a unique id
        $outerSpan = $doc->createElement('span');
        $spanId = 'edit-' . $editId;
        $outerSpan->setAttribute('id', $spanId);
        $welcomeElement->parentNode->replaceChild($outerSpan, $welcomeElement);
        $outerSpan->appendChild($welcomeElement);
        // Add the edit icon after the outer span
        $editIcon = str_replace('EDIT_ID', $spanId, $editIconTemplate);
        $fragment = $doc->createDocumentFragment();
        $fragment->appendXML($editIcon);
        if ($outerSpan->nextSibling) {
            $outerSpan->parentNode->insertBefore($fragment, $outerSpan->nextSibling);
        } else {
            $outerSpan->parentNode->appendChild($fragment);
        }
        $editId++;
    }
    
    // Add icon to the for_access_please_call span
    $accessElement = $xpath->query('//span[@id="for_access_please_call"]')->item(0);
    if ($accessElement) {
        // Wrap the span in another span with a unique id
        $outerSpan = $doc->createElement('span');
        $spanId = 'edit-' . $editId;
        $outerSpan->setAttribute('id', $spanId);
        $accessElement->parentNode->replaceChild($outerSpan, $accessElement);
        $outerSpan->appendChild($accessElement);
        // Add the edit icon after the outer span
        $editIcon = str_replace('EDIT_ID', $spanId, $editIconTemplate);
        $fragment = $doc->createDocumentFragment();
        $fragment->appendXML($editIcon);
        if ($outerSpan->nextSibling) {
            $outerSpan->parentNode->insertBefore($fragment, $outerSpan->nextSibling);
        } else {
            $outerSpan->parentNode->appendChild($fragment);
        }
        $editId++;
    }

    // Add icon to the or span
    $orElement = $xpath->query('//span[@id="or"]')->item(0);
    if ($orElement) {
        // Wrap the span in another span with a unique id
        $outerSpan = $doc->createElement('span');
        $spanId = 'edit-' . $editId;
        $outerSpan->setAttribute('id', $spanId);
        $orElement->parentNode->replaceChild($outerSpan, $orElement);
        $outerSpan->appendChild($orElement);
        // Add the edit icon after the outer span
        $editIcon = str_replace('EDIT_ID', $spanId, $editIconTemplate);
        $fragment = $doc->createDocumentFragment();
        $fragment->appendXML($editIcon);
        if ($outerSpan->nextSibling) {
            $outerSpan->parentNode->insertBefore($fragment, $outerSpan->nextSibling);
        } else {
            $outerSpan->parentNode->appendChild($fragment);
        }
        $editId++;
    }
    
    // Add icon to the scan_to_call span
    $scanElement = $xpath->query('//span[@id="scan_to_call"]')->item(0);
    if ($scanElement) {
        // Wrap the span in another span with a unique id
        $outerSpan = $doc->createElement('span');
        $spanId = 'edit-' . $editId;
        $outerSpan->setAttribute('id', $spanId);
        $scanElement->parentNode->replaceChild($outerSpan, $scanElement);
        $outerSpan->appendChild($scanElement);
        // Add the edit icon after the outer span
        $editIcon = str_replace('EDIT_ID', $spanId, $editIconTemplate);
        $fragment = $doc->createDocumentFragment();
        $fragment->appendXML($editIcon);
        if ($outerSpan->nextSibling) {
            $outerSpan->parentNode->insertBefore($fragment, $outerSpan->nextSibling);
        } else {
            $outerSpan->parentNode->appendChild($fragment);
        }
        $editId++;
    }
    
    // Extract the inner HTML of the body
    $body = $doc->getElementsByTagName('body')->item(0);
    $innerHTML = '';
    foreach ($body->childNodes as $child) {
        $innerHTML .= $doc->saveHTML($child);
    }
    return $innerHTML;
}

function get_page_class($template_name  ){
    if ($template_name == 'Default 1' || $template_name == 'Default 2' || $template_name == 'Default 3') {
        return 'letter_layout_portrait';
    }elseif ($template_name == 'Default 4') {
        return 'letter_layout_landscape';
    }
}

