<script src="https://cdn.jsdelivr.net/npm/mdtimepicker/mdtimepicker.min.js"></script>

<style>
/* Additional mobile responsiveness for schedule calendar */
@media screen and (max-width: 768px) {
  #schedule_calendar .card-body {
    padding: 0.5rem !important;
  }
  
  #schedule_calendar .fc {
    font-size: 12px !important;
  }
  
  /* Ensure calendar container is responsive */
  #calendar {
    min-height: 400px !important;
    overflow-x: auto !important;
    -webkit-overflow-scrolling: touch !important;
  }
  
  /* Force calendar to be scrollable horizontally */
  .fc-view-harness {
    min-width: 500px !important;
    overflow-x: auto !important;
  }
  
  /* Ensure day headers don't overlap */
  .fc-timegrid-col-header .fc-col-header-cell {
    min-width: 65px !important;
    padding: 1px !important;
  }
  
  /* Make day headers ultra-compact */
  .fc-col-header-cell .fc-col-header-cell-cushion {
    font-size: 9px !important;
    line-height: 1.0 !important;
    padding: 1px !important;
    min-height: 30px !important;
  }
  
  /* Ultra-compact day names */
  .fc-col-header-cell .fc-col-header-cell-cushion .fc-day-name {
    font-size: 8px !important;
    margin-bottom: 1px !important;
    letter-spacing: -1px !important;
  }
  
  /* Ultra-compact dates */
  .fc-col-header-cell .fc-col-header-cell-cushion .fc-day-number {
    font-size: 9px !important;
    letter-spacing: -1px !important;
  }
  
  /* Fix table responsiveness in schedule form */
  .schedule_form .table-responsive {
    overflow-x: auto !important;
    -webkit-overflow-scrolling: touch !important;
  }
  
  /* Adjust form elements for mobile */
  .schedule_form .form-control {
    font-size: 14px !important;
  }
  
  .schedule_form .btn {
    font-size: 14px !important;
    padding: 8px 16px !important;
  }
  
  /* Stack form columns on mobile */
  .schedule_form .col-md-6 {
    margin-bottom: 15px !important;
  }
}

@media screen and (max-width: 480px) {
  #schedule_calendar .card-body {
    padding: 0.25rem !important;
  }
  
  .schedule_form .btn {
    width: 100% !important;
    margin-bottom: 10px !important;
  }
  
  /* Make modal more mobile-friendly */
  #createCalendarEventModal .modal-dialog {
    margin: 10px !important;
    max-width: calc(100% - 20px) !important;
  }
  
  #createCalendarEventModal .modal-body {
    padding: 15px !important;
  }
}
</style>

<h3 class="px-3">Schedules</h3>
<!-- <div class="d-flex align-items-center">
</div> -->

<div class="hold-transition sidebar-mini">

    <div class="schedule_form container-fluid" id="schedule_form" style="display:none">
        <form >
            <input type="hidden" name="schedule_id" id="schedule_id" value="">
            <div class="schedule_container">
                <h4>General</h4>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="schedule_title">Title*</label>
                            <input type="text" name="schedule_title" id="schedule_title" class="form-control">
                        </div>
                    </div>

                    <div class="col-md-6">
                        <label for="schedule_type">Type*</label>
                        <select class="form-control" id="schedule_type" name="schedule_type">
                            <option value="" disabled selected>Select schedule type</option>
                            <option value="door">Door</option>
                            <option value="visitor">User/Visitor</option>
                            <option value="Access control">Access control</option>
                        </select>
                    </div>

                    <div class="col-md-6">
                        <label for="schedule_priority">Priority*</label>
                        <select class="form-control" id="schedule_priority" name="schedule_priority">
                            <option value="" disabled selected>Select priority</option>
                            <option value="#0056b3" style="color:#0056b3">Normal</option>
                            <option value="#ba8b00" style="color:#ba8b00">High</option>
                            <option value="#a71d2a" style="color:#a71d2a">Highest</option>
                        </select>
                    </div>
                </div>

            </div>
            <div class="schedule_container">
                <div class="d-flex justify-content-end">
                    <div class="" id="changeCalendarTypeViewEleContainer">
                    </div>
                </div>
                <div id="weekly_schedule" >
                    <h4>Time periods and groups</h4>
                    <div id="time_spans">
                        <div class="table-responsive" style="overflow-x: auto !important; -webkit-overflow-scrolling: touch;">
                            <table id="Schedule_table" class="table table-bordered table-head-fixed text-nowrap table-hover" style="width: 100%; min-width: 1000px;">
                                <thead>
                                    <tr>
                                        <th style="min-width: 80px;">Period</th>
                                        <th style="min-width: 120px;">Start date</th>
                                        <th style="min-width: 120px;">End date</th>
                                        <th style="min-width: 120px;">Day Start time</th>
                                        <th style="min-width: 120px;">Day End time</th>
                                        <th style="min-width: 60px;">Sun</th>
                                        <th style="min-width: 60px;">Mon</th>
                                        <th style="min-width: 60px;">Tue</th>
                                        <th style="min-width: 60px;">Wed</th>
                                        <th style="min-width: 60px;">Thu</th>
                                        <th style="min-width: 60px;">Fri</th>
                                        <th style="min-width: 60px;">Sat</th>
                                        <th style="min-width: 80px;">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="vertical-align: middle;" data-period="1">Period 1</td>
                                        <td style="vertical-align: middle;">
                                            <input type="date" name="dayStartDate" id="dayStartDate" oninput="validateTime(this,false)" class="form-control" />
                                        </td>
                                        <td style="vertical-align: middle;">
                                            <input type="date" id="dayEndDate" name="dayEndDate" oninput="validateTime(this,false)" class="form-control" />
                                        </td>
                                        <td style="vertical-align: middle;">
                                            <input type="time" name="start_time" oninput="validateTime(this,true)" class="form-control" />
                                        </td>
                                        <td style="vertical-align: middle;">
                                            <input type="time" id="end_time" oninput="validateTime(this,true)" name="end_time" class="form-control" />
                                        </td>
                                        <td style="vertical-align: middle; text-align: center;">
                                            <input id="sun_check_period_1" type="checkbox" onchange="checkDayIsInGivenDates(this)">
                                        </td>
                                        <td style="vertical-align: middle; text-align: center;">
                                            <input id="mon_check_period_1" type="checkbox" onchange="checkDayIsInGivenDates(this)">
                                        </td>
                                        <td style="vertical-align: middle; text-align: center;">
                                            <input id="tue_check_period_1" type="checkbox" onchange="checkDayIsInGivenDates(this)">
                                        </td>
                                        <td style="vertical-align: middle; text-align: center;">
                                            <input id="wed_check_period_1" type="checkbox" onchange="checkDayIsInGivenDates(this)">
                                        </td>
                                        <td style="vertical-align: middle; text-align: center;">
                                            <input id="thu_check_period_1" type="checkbox" onchange="checkDayIsInGivenDates(this)">
                                        </td>
                                        <td style="vertical-align: middle; text-align: center;">
                                            <input id="fri_check_period_1" type="checkbox" onchange="checkDayIsInGivenDates(this)">
                                        </td>
                                        <td style="vertical-align: middle; text-align: center;">
                                            <input id="sat_check_period_1" type="checkbox" onchange="checkDayIsInGivenDates(this)">
                                        </td>
                                        <td style="vertical-align: middle; text-align: center;">
                                            <!-- <button type="button" class="btn btn-danger btn-sm" onclick="deleteScheduleRow(this)">Delete</button> -->
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <button  type="button" onclick="getDataAndAddNewRowForSchedule()" class="btn btn-primary">Add new </button>
                        </div>
                    </div>

                    <div class="text-right py-5">
                        <button type="button" onclick="openCreateCalendarEventModal(true,true)" class="btn btn-secondary">Cancel</button>
                        <button type="button" class="btn btn-primary" onclick="submitScheduleData()">Submit</button>
                    </div>
                </div>

                <div id="custom_date_schedule_view" style="display: none;">
                    <div class="form-group custom-w-md-50" id="dateTimeRange">
                        <label>Date and time range:</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text"><i class="far fa-clock"></i></span>
                            </div>
                            <input type="text" class="form-control float-right" id="reservationtime">
                        </div>
                    </div>
                    <div class="text-right py-5">
                        <button type="button" onclick="openCreateCalendarEventModal(true,true)" class="btn btn-secondary">Cancel</button>
                        <button type="button" class="btn btn-primary" onclick="submitCustomScheduleData()">Submit</button>
                    </div>

                </div>
            </div>
        </form>
    </div>

    <div class="" id="schedule_calendar">
    
        <div class="">
            <section class="content">
                <div class="container-fluid">
                <button type="button" onclick="openCreateCalendarEventModal(true,false)" class="btn btn-block btn-dark" style="margin:1rem 0 1rem 0rem;width:auto;"><i class="fa-solid fa-plus"></i> Schedule</button>
                    <div class="row">
                        <div class="col-md-3 d-none">
                            <div class="sticky-top mb-3">
                                <div class="card">
                                    <div class="card-header">
                                        <h4 class="card-title">Events</h4>
                                    </div>
                                    <div class="card-body">
                                        <div id="external-events">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="card card-primary">
                                <div class="card-body p-0">
                                    <div id="calendar"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>

    </div>

    <div class="modal fade" id="createCalendarEventModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalCenterTitle">Create event</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body" style="overflow-y: scroll;">
                    <div class="">
                        <div class="card-body">
                            <input type="hidden" name="calendarAddedEventId" id="calendarAddedEventId" value="">
                            <div class="btn-group" style="width: 100%; margin-bottom: 10px;">
                                <ul class="fc-color-picker" id="color-chooser">
                                    <li><a class="text-primary" href="#"><i class="fas fa-square"></i></a></li>
                                    <li><a class="text-warning" href="#"><i class="fas fa-square"></i></a></li>
                                    <li><a class="text-success" href="#"><i class="fas fa-square"></i></a></li>
                                    <li><a class="text-danger" href="#"><i class="fas fa-square"></i></a></li>
                                    <li><a class="text-muted" href="#"><i class="fas fa-square"></i></a></li>
                                </ul>
                            </div>
                            <div class="pb-2">
                                <label for="new-event">Title*</label>
                                <input id="new-event" type="text" class="form-control" placeholder="Event Title">
                            </div>

                            <div class="pb-2">
                                <label for="schedule_type">Type*</label>
                                <select class="form-control" id="schedule_type" name="schedule_type">
                                    <option value="" disabled selected>Select schedule type</option>
                                    <option value="door">Door</option>
                                    <option value="user">User</option>
                                </select>
                            </div>

                            <div class="pb-2" id="startDateForAllDay">
                                <label for="start_day_input">Start day*</label>
                                <input id="start_day_input" type="date" class="form-control" placeholder="Event Title">
                            </div>


                            <div class="form-check pt-2 pb-3">
                                <input class="form-check-input" id="isAllDay" for="isAllDay" type="checkbox" checked onchange="isAllDayChecked()">
                                <label for="isAllDay" class="form-check-label" style="cursor:pointer">Is all day</label>
                            </div>

                            <div class="form-group" id="dateTimeRange">
                                <label>Date and time range:</label>

                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="far fa-clock"></i></span>
                                    </div>
                                    <input type="text" class="form-control float-right" id="reservationtime">
                                </div>
                            </div>

                            <div class="input-group-append">
                                <button id="add-new-event" type="button" class="btn btn-primary">Add</button>
                            </div>
                            <p id="event_update_error" class="text-danger fs-6"></p>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <div class="toast-container position-fixed p-3" id="scheduleToastMessage" style="display:none;z-index: 99999; top: 20px; right: 0px;width:300px">
        <div id="scheduleToast" class="toast bg-danger text-white" role="alert" aria-live="assertive" aria-atomic="true">
            <div class="toast-header d-flex justify-content-between  ">
                <strong class="me-auto">Error</strong>
                <button onclick="closeScheduleToastMessage()" type="button" class="close " data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="toast-body" id="scheduleToastErrorMessage">
                An error occurred! Please check the details and try again.
            </div>
        </div>
    </div>

    <script src="js/fullcalendar/calendar_custom_functions.js"></script>
    <script src="js/moment/moment.min.js"></script>
    <script src="js/fullcalendar/jquery.inputmask.min.js"></script>
    <script src="js/fullcalendar/daterangepicker.js"></script>
    <script src="js/fullcalendar/bootstrap-colorpicker.min.js"></script>
    <script src="js/fullcalendar/tempusdominus-bootstrap-4.min.js"></script>
</div>