<?php

    try {
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }

        require '../../db.php';
        require '../auth/auth_functions.php';
        
        if (!currentUserHasAccess($pdo, 'users', 'read')) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Access denied! Please wait while being Re-Directed.',
                'redirect' => '../../dashboard.php'
            ]);
            exit();
        }
    } catch (\Throwable $th) {
        // throw $th;
    }

?>

<style>

    /* Custom styles for tab colors */
    .nav-tabs .nav-link {
        color: black;
        /* Default color for inactive tabs */
    }

    .nav-tabs .nav-link.active {
        color: blue;
        /* Color for active tab */
    }

    .nav-tabs .nav-link:hover {
        color: blue;
        /* Hover color for tabs */
    }

    .nav-tabs .nav-link.active {
        background-color: #f8f9fa;
        /* Background color for active tab */
        border-color: #dee2e6 #dee2e6 #fff;
        /* Border color adjustments */
    }

</style>

<script src="js/cards_responsive/users_responsive.js"></script>

<div id="usersContent">
    <ul class="nav nav-tabs" id="myTab" role="tablist">
        <li class="nav-item">
            <a class="nav-link active" id="users-tab" data-toggle="tab" href="#users" role="tab" aria-controls="users" aria-selected="true">Users</a>
        </li>
        <?php if ($_SESSION['layer'] === 'super_admin' || $_SESSION['layer'] === 'admin' || $_SESSION['layer'] === 'dealer' || $_SESSION['layer'] === 'sub_dealer' || $_SESSION['layer'] === 'organization admin' || $_SESSION['layer'] === 'property admin'): ?>
            <li class="nav-item">
                <a class="nav-link" id="operators-tab" data-toggle="tab" href="#operators" role="tab" aria-controls="operators" aria-selected="false">Operators</a>
            </li>
        <?php endif;
            if ($_SESSION['layer'] === 'super_admin' || $_SESSION['layer'] === 'admin' || $_SESSION['layer'] === 'dealer' || $_SESSION['layer'] === 'sub_dealer'): ?>
                <li class="nav-item">
                    <a class="nav-link" id="admins-tab" data-toggle="tab" href="#admins" role="tab" aria-controls="admins" aria-selected="false">Admins</a>
                </li>
        <?php endif;
        if ($_SESSION['layer'] === 'super_admin' || $_SESSION['layer'] === 'admin'): ?>
            <li class="nav-item">
                <a class="nav-link" id="manage-tab" data-toggle="tab" href="#manage" role="tab" aria-controls="manage" aria-selected="false">Manage</a>
            </li>
        <?php endif;  ?>
    </ul>
</div>

<div class="tab-content">
    <!-- Users tab pane -->
    <div class="tab-pane fade show active" id="users" role="tabpanel" aria-labelledby="users-tab">
        <div class="d-flex justify-content-between align-items-center">
            <button type="button" id="addUser" class="btn btn-dark" data-toggle="modal" data-backdrop="static" data-keyboard="false" data-target="#usermodal" style="margin:1rem 0 1rem .5rem;width:auto;">+ User</button>
            <div id="changePropertyUserViewEleContainer">
            </div>
        </div>

        <!-- card view start  -->
        <div class="card" id="property_users_card_container" style="display:none">
            <div class="card-header">
                <h3 class="card-title">Users</h3>
                <div class="card-tools">
                    <div class="input-group input-group-sm" style="width: 250px;">
                        <input type="text" id="searchCardsUsersInput" onkeyup="searchUsersCard()" class="form-control float-right" placeholder="Search Users">
                        <div class="input-group-append">
                            <button type="button" class="btn btn-default">
                                <i class="fas fa-search"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive" id="property_users_card_view">
                </div>
            </div>
        </div>

        <!-- card view end  -->
        <!-- table view  -->
        <div class="col-12" id="property_users_table_view" style="display:none">
            <div class="row">
                <div class="col-12" style="margin-top: 20px;">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Users</h3>
                            <!-- Search bar for Users -->
                            <div class="card-tools">
                                <div class="input-group input-group-sm" style="width: 250px;">
                                    <input type="text" id="searchUsersInput" onkeyup="searchTable('usersTable', 'searchUsersInput')" class="form-control float-right" placeholder="Search Users">
                                    <div class="input-group-append">
                                        <button type="button" class="btn btn-default">
                                            <i class="fas fa-search"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover" id="usersTable" style="width: 100%;">
                                    <thead>
                                        <tr>
                                            <!-- <th>User ID</th> -->
                                            <th>Photo</th>
                                            <th>User</th>
                                            <th>Address</th>
                                            <th>Registered</th>
                                            <th>Phone #'s</th>
                                            <!-- <th>License Plate #</th> -->
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id='propertyUsers'></tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Operators tab pane -->
    <div class="tab-pane fade" id="operators" role="tabpanel" aria-labelledby="operators-tab">
        <div class="d-flex justify-content-between align-items-center">
            <?php if ($_SESSION['layer'] === 'super_admin' || $_SESSION['layer'] === 'admin' || $_SESSION['layer'] === 'dealer' || $_SESSION['layer'] === 'sub_dealer'|| $_SESSION['layer'] === 'organization admin' || $_SESSION['layer'] === 'property admin'): ?>
                <button type="button" class="btn btn-dark" id="operatorModalBtn" data-toggle="modal" data-backdrop="static" data-keyboard="false" data-target="#operatormodal" style="margin:1rem 0 1rem .5rem;width:auto;">+ Operator</button>
            <?php endif; ?>
        </div>
        <!-- <?php if ($_SESSION['layer'] === 'super_admin' || $_SESSION['layer'] === 'admin' || $_SESSION['layer'] === 'dealer' || $_SESSION['layer'] === 'organization admin' || $_SESSION['layer'] === 'property admin'): ?>
            <button type="button" class="btn btn-dark" id="operatorModalBtn" data-toggle="modal" data-backdrop="static" data-keyboard="false" data-target="#operatormodal" style="margin:1rem 0 1rem .5rem;width:auto;">+ Add Operator</button>
        <?php endif; ?> -->


        <!-- card view start  -->
        <div class="card" id="property_operators_card_container" style="display:none" >
            <div class="card-header">
                <h3 class="card-title">Operators</h3>
                <div class="card-tools">
                    <div class="input-group input-group-sm" style="width: 250px;">
                        <input type="text" id="searchCardsOperatorsInput" onkeyup="searchOperatorsCard()" class="form-control float-right" placeholder="Search operators">
                        <div class="input-group-append">
                            <button type="button" class="btn btn-default">
                                <i class="fas fa-search"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive" id="property_operators_card_view" style="display:flex;flex-wrap:wrap;">
                </div>
            </div>
        </div>

        <!-- card view end  -->


        <div class="col-12" id="operators_table_container">
            <div class="row">
                <div class="col-12" style="margin-top: 20px;">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Operators</h3>
                            <!-- Search bar for Operators -->
                            <div class="card-tools">
                                <div class="input-group input-group-sm" style="width: 250px;">
                                    <input type="text" id="searchOperatorsInput" onkeyup="searchTable('operatorsTable', 'searchOperatorsInput')" class="form-control float-right" placeholder="Search Operators">
                                    <div class="input-group-append">
                                        <button type="button" class="btn btn-default">
                                            <i class="fas fa-search"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover" id="operatorsTable" style="width: 100%;">
                                    <thead>
                                        <tr>
                                            <th>Photo</th>
                                            <th>Name</th>
                                            <th>Role</th>
                                            <th>Email</th>
                                            <th>Registered</th>
                                            <th>Created By</th>
                                            <th>Last Logged In</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id='propertyOperators'></tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Admins tab pane -->
    <div class="tab-pane fade" id="admins" role="tabpanel" aria-labelledby="admins-tab">
        <?php if ($_SESSION['layer'] === 'super_admin' || $_SESSION['layer'] === 'admin' || $_SESSION['layer'] === 'dealer'  || $_SESSION['layer'] === 'sub_dealer'): ?>
            <button type="button" id="addAdmins" class="btn btn-dark" data-toggle="modal" data-backdrop="static" data-keyboard="false" data-target="#adminsmodal" style="margin:1rem 0 1rem .5rem;width:auto;">+ Admin</button>

            <!-- card view start  -->
            <div class="card" id="orgadmins_card_container" style="display:none" >
                <div class="card-header">
                    <h3 class="card-title">Organization Admins</h3>
                    <div class="card-tools">
                        <div class="input-group input-group-sm" style="width: 250px;">
                            <input type="text" id="searchCardsOrgAdminsInput" onkeyup="searchOrgAdminsCard()" class="form-control float-right" placeholder="Search org admins">
                            <div class="input-group-append">
                                <button type="button" class="btn btn-default">
                                    <i class="fas fa-search"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive" id="orgadmins_card_view">
                    </div>
                </div>
            </div>
            <!-- card view end  -->

            <div class="col-12" id="orgadmins_table_container">
                <div class="row">
                     <div class="col-12" style="margin-top: 20px;">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Organization Admins</h3>
                                <div class="card-tools">
                                    <div class="input-group input-group-sm" style="width: 250px;">
                                        <input type="text" id="searchAdminsInput" onkeyup="searchTable('adminsTbl', 'searchAdminsInput')" class="form-control float-right" placeholder="Search Admins">
                                        <div class="input-group-append">
                                            <button type="button" class="btn btn-default">
                                                <i class="fas fa-search"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table id="orgadminsTbl" class="table table-bordered table-hover" style="width: 100%;">
                                        <thead>
                                            <tr>
                                                <th>Photo</th>
                                                <th>Name</th>
                                                <th>Role</th>
                                                <th>Email</th>
                                                <th>Registered</th>
                                                <th>Last Logged In</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody id='orgadminsTd'></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <?php if ($_SESSION['layer'] === 'super_admin' || $_SESSION['layer'] === 'admin' || $_SESSION['layer'] === 'dealer' || $_SESSION['layer'] === 'sub_dealer'): ?>
            <!-- card view start  -->
            <div class="card" id="dealer_admins_card_container" style="display:none" >
                <div class="card-header">
                    <h3 class="card-title">Dealer Admins</h3>
                    <div class="card-tools">
                        <div class="input-group input-group-sm" style="width: 250px;">
                            <input type="text" id="searchCardsDealerAdminsInput" onkeyup="searchDealerAdminsCard()" class="form-control float-right" placeholder="Search dealer admins">
                            <div class="input-group-append">
                                <button type="button" class="btn btn-default">
                                    <i class="fas fa-search"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive" id="dealer_admins_card_view">
                    </div>
                </div>
            </div>

            <!-- card view end  -->

            <!-- dealer admins table container -->
            <div class="col-12" id="dealer_admins_table_container">
                <div class="row">
                     <div class="col-12" style="margin-top: 20px;">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Dealer Admins</h3>
                                <div class="card-tools">
                                    <div class="input-group input-group-sm" style="width: 250px;">
                                        <input type="text" id="searchDealerAdminsInput" onkeyup="searchTable('dealeradminsTbl', 'searchDealerAdminsInput')" class="form-control float-right" placeholder="Search Dealer Admins">
                                        <div class="input-group-append">
                                            <button type="button" class="btn btn-default">
                                                <i class="fas fa-search"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table id="dealeradminsTbl" class="table table-bordered table-hover" style="width: 100%;">
                                        <thead>
                                            <tr>
                                                <th>Photo</th>
                                                <th>Name</th>
                                                <th>Role</th>
                                                <th>Email</th>
                                                <th>Registered</th>
                                                <th>Last Logged In</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody id='dealeradminsTd'></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <!-- Manage tab pane -->
    <div class="tab-pane fade" id="manage" role="tabpanel" aria-labelledby="manage-tab">
        <?php if ($_SESSION['layer'] === 'super_admin' || $_SESSION['layer'] === 'admin'): ?>
            <!-- card view start  -->
             <div class="col-12 pt-2" id="deleted_operators_card_container" style="display:none">
                <div class="row">
                    <div class="col-12">
                        <div class="card" >
                            <div class="card-header">
                                <h3 class="card-title">Deleted Operators</h3>
                                <div class="card-tools">
                                    <div class="input-group input-group-sm" style="width: 250px;">
                                        <input type="text" id="searchCardsDeletedOperatorsInput" onkeyup="searchDeletedOperatorsCard()" class="form-control float-right" placeholder="Search deleted operators">
                                        <div class="input-group-append">
                                            <button type="button" class="btn btn-default">
                                                <i class="fas fa-search"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive" id="deleted_operators_card_view">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
             </div>

            <!-- card view end  -->

            <!-- table view start  -->
            <div class="col-12 mt-3" id="deleted_operators_table_container" >
                <div class="row">
                     <div class="col-12" style="margin-top: 20px;">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Deleted Operators</h3>
                                <div class="card-tools">
                                    <div class="input-group input-group-sm" style="width: 250px;">
                                        <input type="text" id="searchDeletedOperatorsInput" onkeyup="searchTable('deletedOper', 'searchDeletedOperatorsInput')" class="form-control float-right" placeholder="Search Deleted Operators">
                                        <div class="input-group-append">
                                            <button type="button" class="btn btn-default">
                                                <i class="fas fa-search"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table id="deletedOper" class="table table-bordered table-hover" style="width: 100%;">
                                        <thead>
                                            <tr>
                                                <th>Photo</th>
                                                <th>Name</th>
                                                <th>Role</th>
                                                <th>Email</th>
                                                <th>Registered</th>
                                                <th>Created By</th>
                                                <th>Last Logged In</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody id='deletedOperators'></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- table view end  -->

            <div class="col-12">
                <div class="row">
                    <div class="col-12" style="margin-top: 20px;">

                        <!-- Deleted users card container -->
                        <div class="card" id="deleted_users_card_container" style="display:none">
                            <div class="card-header">
                                <h3 class="card-title">Deleted Users</h3>
                                <div class="card-tools">
                                    <div class="input-group input-group-sm" style="width: 250px;">
                                        <input type="text" id="searchCardsDeletedUsersInput" onkeyup="searchDeletedUsersCard()" class="form-control float-right" placeholder="Search deleted users">
                                        <div class="input-group-append">
                                            <button type="button" class="btn btn-default">
                                                <i class="fas fa-search"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive" id="deleted_users_card_view">
                                </div>
                            </div>
                        </div>

                        <!-- deleted users table container -->
                        <div class="card" id="deleted_users_table_container">
                            <div class="card-header">
                                <h3 class="card-title">Deleted Users</h3>
                                <div class="card-tools">
                                    <div class="input-group input-group-sm" style="width: 250px;">
                                        <input type="text" id="searchDeletedUsersInput" onkeyup="searchTable('deletedUser', 'searchDeletedUsersInput')" class="form-control float-right" placeholder="Search Deleted Users">
                                        <div class="input-group-append">
                                            <button type="button" class="btn btn-default">
                                                <i class="fas fa-search"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table id="deletedUser" class="table table-bordered table-hover" style="width: 100%;">
                                        <thead>
                                            <tr>
                                                <!-- <th>User ID</th> -->
                                                <th>Photo</th>
                                                <th>User</th>
                                                <th>Address</th>
                                                <th>Registered</th>
                                                <th>Phone #'s</th>
                                                <!-- <th>License Plate #</th> -->
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody id='deletedpropertyUsers'></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<div class="modal fade" id="usermodal" tabindex="-1" role="dialog" aria-labelledby="usermodalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="usermodalTitle">Create New User </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="newUserForm" action="include/users/users_db.php" method="post">
                    <div class="input-group mb-3">
                        <input type="text" name="firstname" class="form-control" placeholder="FirstName" required>
                        <input type="text" name="lastname" class="form-control" placeholder="LastName" required>
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fa-solid fa-address-card"></span>
                            </div>
                        </div>
                    </div>
                    <div class="input-group mb-3">
                        <input type="text" name="unit" class="form-control" placeholder="Unit" required>
                        <select class="form-control"id="streetlist" name ="streetList" required onchange="handle_change_addNewStreet()">
                            <option disabled selected>Please Select a Street</option>
                        </select>
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fa-solid fa-map-location-dot"></span>
                            </div>
                        </div>
                    </div>
                    <div class="input-group mb-3">
                        <input type="text" name="uemail" class="form-control" placeholder="Email Address" required>
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fa-solid fa-envelope"></span>
                            </div>
                        </div>
                    </div>
                    <div class="input-group mb-3">
                        <input type="text" name="mobile" class="form-control" style="max-width: 92%;" oninput="formatPhoneNumber(this)" onpaste="handlePaste(event)" placeholder="Mobile Number" required>
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-mobile-button fa-lg"></span>
                            </div>
                        </div>
                    </div>
                    <div class="input-group mb-3">
                        <input type="text" name="home" class="form-control" oninput="formatPhoneNumber(this)" onpaste="handlePaste(event)" placeholder="Alternate Number - Optional">
                        <input type="text" name="home_extension" class="form-control" placeholder="Extension">
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-phone"></span>
                            </div>
                        </div>
                        
                    </div>
                    <!-- <div class="input-group mb-3">
                        <input type="text" name="home" class="form-control" oninput="formatPhoneNumber(this)" onpaste="handlePaste(event)" placeholder="Home Number Optional">
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-phone"></span>
                            </div>
                        </div>
                    </div> -->
                    <div class="input-group mb-3">
                        <select class="form-control" id="rolelist" name ="roleList" required></select> <!-- Needs to have a prefix C for custom-->
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fa-solid fa-user-secret"></span>
                            </div>
                        </div>
                    </div>
                    <div>
                        <input type="hidden" name="form_id" value="form1">
                    </div>
                    <button type="submit" name="submitnewuser" class="btn btn-primary btn-block">Add User</button>
                </form>                
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="editusermodal" tabindex="-1" role="dialog" aria-labelledby="editusermodalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editusermodalTitle">Edit User </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="editUserForm" action="include/users/users_db.php" method="post">
                    <div class="input-group mb-3">
                        <input type="text" name="firstname" class="form-control" title="First Name" placeholder="FirstName" required>
                        <input type="text" name="lastname" class="form-control" title="Last Name" placeholder="LastName" required>
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fa-solid fa-address-card" title="Name"></span>
                            </div>
                        </div>
                    </div>
                    <div class="input-group mb-3">
                        <input type="text" name="unit" class="form-control" title="Unit" placeholder="Unit" required>
                        <select class="form-control"id="streetlist" name ="streetList" title="Street" required><option disabled selected>Please Select a Street</option></select>
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fa-solid fa-map-location-dot" title="Address"></span>
                            </div>
                        </div>
                    </div>
                    <div class="input-group mb-3">
                        <input type="text" name="uemail" class="form-control" title="Email Address" placeholder="Email Address" required>
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fa-solid fa-envelope" title="Email Address"></span>
                            </div>
                        </div>
                    </div>
                    <div class="input-group mb-3">
                        <input type="text" name="mobile" class="form-control" style="max-width: 92%;" oninput="formatPhoneNumber(this)" onpaste="handlePaste(event)" title="Mobile Number" placeholder="Mobile Number" readonly>
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-mobile-button" title="Mobile Number"></span>
                            </div>
                        </div>
                    </div>

                    <div class="input-group mb-3">
                        <input type="text" name="home" class="form-control" oninput="formatPhoneNumber(this)" onpaste="handlePaste(event)" placeholder="Alternate Number - Optional">
                        <input type="text" name="home_extension" id="home_extension_user" class="form-control" placeholder="Extension">
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-phone"></span>
                            </div>
                        </div>
                        
                    </div>

                    <!-- <div class="input-group mb-3">
                        <input type="text" name="home" class="form-control" oninput="formatPhoneNumber(this)" onpaste="handlePaste(event)" placeholder="Home Number Optional">
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-phone" title="Home Number"></span>
                            </div>
                        </div>
                    </div> -->
                    <?php if ($_SESSION['layer'] === 'super_admin' || $_SESSION['layer'] === 'admin' || $_SESSION['layer'] === 'dealer' || $_SESSION['layer'] === 'sub_dealer' || $_SESSION['layer'] === 'organization admin' || $_SESSION['layer'] === 'property admin'): ?>
                        <div class="input-group mb-3">
                            <select class="form-control" id="urolelist" name ="uroleList" title="Role" required><option disabled selected>Role to Assign</option></select>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-user-secret"></span>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div>
                        <input type="hidden" name="form_id" value="form1">
                    </div>
                    <button type="submit" name="updateUserBtn" class="btn btn-primary btn-block">Update User</button>
                </form>                
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="operatormodal" tabindex="-1" role="dialog" aria-labelledby="operatormodalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="operatormodalTitle">Create New Operator</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="newoperatorform" action="include/users/operators_db.php" method="post">
                    <div class="input-group mb-3">
                        <input type="email" name="opemail" class="form-control" title="Email Address" placeholder="Email Address" required>
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fa-solid fa-address-card" title="Email Address"></span>
                            </div>
                        </div>
                    </div>
                    <div class="input-group mb-3">
                        <input type="text" name="opmobile" class="form-control" style="max-width: 92%;" oninput="formatPhoneNumber(this)" onpaste="handlePaste(event)" placeholder="Mobile Number" required>
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-mobile-button fa-lg"></span>
                            </div>
                        </div>
                    </div>
                    <div class="input-group mb-3">
                        <select id="oprolelist" name ="opRoleList" class="form-control" title="Role" required></select>
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fa-solid fa-user-secret" title="Role"></span>
                            </div>
                        </div>
                    </div>
                    <div>
                        <input type="hidden" name="form_id" value="form2">
                    </div>
                    <button type="submit" name="submitnewoperator" class="btn btn-primary btn-block">Send Invite</button>
                </form>
                <div id="dealerslotsresult"></div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="updateoperatormodal" tabindex="-1" role="dialog" aria-labelledby="updateoperatormodalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="updateoperatormodalTitle">Update Operator</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="updateOperatorForm" action="include/users/operators_db.php" method="post">
                    <div class="input-group mb-3">
                        <input type="text" name="ofirstname" class="form-control" title="First Name" placeholder="First Name" required>
                        <input type="text" name="olastname" class="form-control" title="Last Name" placeholder="Last Name" required>
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fa-solid fa-address-card" title="Name"></span>
                            </div>
                        </div>
                    </div>
                    <div class="input-group mb-3">
                        <input type="text" name="ounit" class="form-control" title="Unit" placeholder="Unit" required>
                        <select id="ostreetlist" class="form-control" name ="ostreetList" title="Street" required><option disabled selected>Please Select</option></select>
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fa-solid fa-map-location-dot"></span>
                            </div>
                        </div>
                    </div>
                    <div class="input-group mb-3">
                        <input type="text" name="oemail" class="form-control" title="Email Address" placeholder="Email Address" required>
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fa-solid fa-envelope" title="Email Address"></span>
                            </div>
                        </div>
                    </div>
                    <div class="input-group mb-3">
                        <input type="text" name="omobile" class="form-control" style="max-width: 92%;" oninput="formatPhoneNumber(this)" onpaste="handlePaste(event) "title="Mobile Number" placeholder="Mobile Number" readonly>
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-mobile-button fa-lg" title="Mobile Number"></span>
                            </div>
                        </div>
                    </div>
                    <div class="input-group mb-3">
                        <input type="text" name="ohome" class="form-control" oninput="formatPhoneNumber(this)" onpaste="handlePaste(event)" title="Home Number" placeholder="Home Number Optional">
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-phone" title="Home Number"></span>
                            </div>
                        </div>
                    </div>
                    <div>
                        <input type="hidden" name="form_id" value="form3">
                    </div>
                    <button type="submit" name="updateOperatorsubmit" class="btn btn-primary btn-block">Update Operator</button>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="adminsmodal" tabindex="-1" role="dialog" aria-labelledby="adminsmodalTitle" aria-hidden="true">
    <div class="modal-dialog modal-md modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="adminsmodalTitle">Create New Admin</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="newAdminForm" action="include/users/admins_db.php" method="post">

                    <div class="input-group mb-3">
                        <div class="input-group">
                            <input type="text" name="firstname" class="form-control" placeholder="First Name" title="First Name" required>
                            <input type="text" name="lastname" class="form-control" placeholder="Last Name" title="Last Name" required>
                            <div class="input-group-append">
                                <span class="input-group-text"><i class="fa-solid fa-user" title="First and Last Name"></i></span>
                            </div>
                        </div>
                    </div>

                    <div class="input-group mb-3">
                        <div class="input-group">
                            <input type="email" name="newemail" class="form-control" placeholder="Email Address" title="Email Address" required>
                            <div class="input-group-append">
                                <span class="input-group-text"><i class="fa-solid fa-envelope" title="Email Address"></i></span>
                            </div>
                        </div>
                    </div>

                    <div class="input-group mb-3">
                        <div class="input-group">
                            <input type="text" name="mobile" class="form-control" oninput="formatPhoneNumber(this)" onpaste="handlePaste(event)" placeholder="Mobile Phone" title="Mobile Phone" required>
                            <div class="input-group-append">
                                <span class="input-group-text"><i class="fas fa-mobile-button fa-lg" title="Mobile Phone"></i></span>
                            </div>
                        </div>
                    </div>

                    <div class="input-group mb-3">
                        <div class="input-group">
                            <select class="form-control" id="adminslist" name="adminsList" title="Role" required>
                                <option value="0" selected disabled>Please Select a Role</option>
                                <option value="1">Organization Admin</option>
                                <?php if ($_SESSION['layer'] === 'super_admin' || $_SESSION['layer'] === 'admin' || $_SESSION['layer'] === 'dealer'): ?>
                                    <option value="2">Sub-Dealer</option>
                                <?php endif; ?>
                            </select>
                            <div class="input-group-append">
                                <span class="input-group-text"><i class="fa-solid fa-user-tie" title="Role"></i></span>
                            </div>
                        </div>
                    </div>

                    <div class="input-group mb-3 text-center">
                        <button type="button" id="setPermissions" class="btn btn-info form-control" data-toggle="modal" data-target="#permissionsModal" title="Set Permissions">
                            <i class="fa-solid fa-shield-alt"></i> Set Permissions
                        </button>
                    </div>

                    <input type="hidden" id="selectedOrganizations" name="organization_access">
                    <input type="hidden" id="selectedProperties" name="property_access">

                    <button type="submit" name="submitnewadmins" class="btn btn-primary btn-block">Add Admin</button>
                </form>                
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="editAdminModal" tabindex="-1" role="dialog" aria-labelledby="editAdminModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-md modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editAdminModalTitle">Edit Admin</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="editAdminForm" action="include/users/admins_db.php" method="post">
                    <input type="hidden" name="idstore" id="idstore">
                    <input type="hidden" id="permissionsUpdated" name="permissionsUpdated" value="false">
                    <div class="input-group mb-3">
                        <input type="text" name="firstname" class="form-control" placeholder="First Name" title="First Name" required>
                        <input type="text" name="lastname" class="form-control" placeholder="Last Name" title="Last Name" required>
                        <div class="input-group-append">
                            <span class="input-group-text"><i class="fa-solid fa-user" title="First and Last Name"></i></span>
                        </div>
                    </div>
                    <div class="input-group mb-3">
                        <input type="text" name="email" class="form-control" placeholder="Email Address" title="Email Address" readonly>
                        <div class="input-group-append">
                            <span class="input-group-text"><i class="fa-solid fa-envelope" title="Email Address"></i></span>
                        </div>
                    </div>
                    <div class="input-group mb-3">
                        <input type="text" name="mobile" class="form-control" oninput="formatPhoneNumber(this)" onpaste="handlePaste(event)" placeholder="Mobile Number" title="Mobile Phone" required>
                        <div class="input-group-append">
                            <span class="input-group-text"><i class="fas fa-mobile-button fa-lg" title="Mobile Phone"></i></span>
                        </div>
                    </div>
                    <div class="input-group mb-3">
                        <select class="form-control" id="adminslist" name="adminsList" title="Role" disabled required>
                            <option value="0" selected disabled>Select a Role</option>
                            <option value="1">Organization Admin</option>
                            <option value="2">Dealer Admin</option>
                        </select>
                        <div class="input-group-append">
                            <span class="input-group-text"><i class="fa-solid fa-user-tie" title="Role"></i></span>
                        </div>
                    </div>

                    <button type="button" class="btn btn-info btn-block mt-3" id="editPermissionsBtn">
                        <i class="fa-solid fa-shield-alt"></i> Set Permissions
                    </button>

                    <input type="hidden" id="uselectedOrganizations" name="organization_access">
                    <input type="hidden" id="uselectedProperties" name="property_access">

                    <button type="submit" name="updateDealerAdmin" class="btn btn-primary btn-block mt-3">Update Admin</button>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="permissionsModal" tabindex="-1" role="dialog" aria-labelledby="permissionsModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="permissionsModalTitle">Assign Organizations & Properties</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <!-- Organizations List -->
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title">Organizations</h5>
                            </div>
                            <div class="card-body">
                                <ul id="orgList" class="list-group">
                                    <!-- Organizations will be dynamically populated -->
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Properties List -->
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title">Properties</h5>
                            </div>
                            <div class="card-body">
                                <ul id="propList" class="list-group">
                                    <!-- Properties will be dynamically populated -->
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Save Button -->
                <div class="text-center mt-3">
                    <button type="button" class="btn btn-success" id="savePermissions">
                        <i class="fa-solid fa-save"></i> Save Permissions
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="editPermissionsModal" tabindex="-1" role="dialog" aria-labelledby="editPermissionsModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editPermissionsModalTitle">Edit Permissions</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title">Organizations</h5>
                            </div>
                            <div class="card-body">
                                <ul id="editOrgList" class="list-group">
                                </ul>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title">Properties</h5>
                            </div>
                            <div class="card-body">
                                <ul id="editPropList" class="list-group">
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="text-center mt-3">
                    <button type="button" class="btn btn-success" id="saveEditPermissions">
                        <i class="fa-solid fa-save"></i> Save Permissions
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="user_image_modal" tabindex="-1" role="dialog" aria-labelledby="snapImageModalTitle" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" style="width: 600px;height: 650px;" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">User Proile Image</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body text-center">
                    <img id="user_profile_image" src="" alt="Property" class="img-fluid" style="max-width: 100%; object-fit: contain;">
                </div>
            </div>
        </div>
    </div>



