<?php

include "../helper_functions/data_request.php";

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require '../phpmailer/PHPMailer.php';
require '../phpmailer/Exception.php';
require '../phpmailer/SMTP.php';

function sendInvitation($pdo, $email, $role, $custom, $invited_by, $creator_type, $type) {

    $token = bin2hex(random_bytes(16)); // Generate a unique token

    try {
        // Insert the invitation into the database using insertData
        $insertData = [
            'email' => $email,
            'token' => $token,
            'role' => $role,
            'role_type' => $custom,
            'invited_by' => $invited_by,
            'creator_type' => $creator_type
        ];
    
        if ($type === 'dealer_admins'){
            $result = insertData('dealer_invitations', $insertData);
            $link = "https://site.invisibletest.myagecam.net/admin_register.php?token=$token";
        }else {
            $result = insertData('property_invitations', $insertData);
            $link = "https://site.invisibletest.myagecam.net/register.php?token=$token";
        }
    
        if ($result) {
            // Send the email using PHPMailer
            $mail = new PHPMailer(true);
            try {
                // Server settings
                $mail->isSMTP();
                $mail->Host = 'invisibletest.myagecam.net';
                $mail->SMTPAuth = true;
                $mail->Username = 'email@invisibletest.myagecam.net';
                $mail->Password = 'Z}9W}_uhGcTv';
                $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
                $mail->Port = 587;
    
                // Recipients
                $mail->setFrom('email@invisibletest.myagecam.net', 'Your Application');
                $mail->addAddress($email);
    
                // Content
                $mail->isHTML(true);
                $mail->Subject = 'Invitation to Register';
                $mail->Body    = "Please click the link to complete your registration: <a href='$link'>Register</a>";
    
                $mail->send();
                return $token;
            } catch (Exception $e) {
                echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
                return false;
            }
        } else {
            return false;
        }
    } catch (Exception $e) {
        error_log("Database error: " . $e->getMessage());
        return false;
    }
    
}

function multipropInvitation($email, $property) {

    
    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host = 'invisibletest.myagecam.net';
        $mail->SMTPAuth = true;
        $mail->Username = 'email@invisibletest.myagecam.net';
        $mail->Password = 'Z}9W}_uhGcTv';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port = 587;

        // Recipients
        $mail->setFrom('email@invisibletest.myagecam.net', 'Your Application');
        $mail->addAddress($email);

        $mail->isHTML(true);
        $mail->Subject = 'Welcome';
        $mail->Body    = "You have been Invited to $property.";

        $mail->send();
        return;
    } catch (Exception $e) {
        echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
        return false;
    }

}

function resendInvitation($userId) {

    $userDatas = fetchData('property_users', ['id' => $userId]);
    $token = $userDatas[0]['password'];
    $email = $userDatas[0]['email'];

    $mail = new PHPMailer(true);
    try {
        // Server settings
        $mail->isSMTP();
        $mail->Host = 'invisibletest.myagecam.net';
        $mail->SMTPAuth = true;
        $mail->Username = 'email@invisibletest.myagecam.net';
        $mail->Password = 'Z}9W}_uhGcTv';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port = 587;

        // Recipients
        $mail->setFrom('email@invisibletest.myagecam.net', 'Your Application');
        $mail->addAddress($email);

        // Content
        $mail->isHTML(true);
        $mail->Subject = 'Invitation to Register';
        $mail->Body    = "Please click the link to complete your registration: <a href='https://site.invisibletest.myagecam.net/register.php?token=$token'>Register</a>";

        $mail->send();
        echo "Success";
    } catch (Exception $e) {
        echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
    }
}

