<?php

class Migration_20240712000002_intial_data
{
    public static function up(PDO $pdo)
    {
        $hashedPassword = password_hash('1234', PASSWORD_DEFAULT);

        $sql = "
            INSERT INTO users (firstname, lastname, password, email, layer) VALUES 
            ('super', 'admin', '$hashedPassword', 'superadmin@invisibleintercom.com', 'super_admin'),
            ('admin', 'admin', '$hashedPassword', 'admin@invisibleintercom.com', 'admin'),
            ('dealer', 'dealer', '$hashedPassword', 'dealer@invisibleintercom.com', 'dealer');

            INSERT INTO roles (name, created_by) VALUES 
            ('super_admin', 1), 
            ('admin', 1), 
            ('dealer', 1),
            ('organization admin', 1), 
            ('property admin', 1), 
            ('user', 1), 
            ('visitor', 1);

            INSERT INTO resources (name) VALUES 
            ('dashboard'), 
            ('my_iis'), 
            ('my_properties'), 
            ('property'), 
            ('integrations'), 
            ('my_roles'), 
            ('users'), 
            ('visitors'), 
            ('payment_invoice'), 
            ('command_center'), 
            ('events'), 
            ('settings'), 
            ('admin_panel'), 
            ('admin_setup'), 
            ('dealer_setup');

            INSERT INTO actions (name) VALUES 
            ('read'), 
            ('write'), 
            ('delete');

            INSERT INTO organizations (name, address, city, state, zipcode, contact, contact_phone_number, dealer_id) VALUES
            ('Acme Property Management', '123 Main St', 'Springfield', 'VA', '22151', 'John Doe', '(123)456-7890', '3');

            INSERT INTO properties (name, address, city, state, zipcode, contact, contact_phone_number, organization_id, property_type, demo_expiry_date, notes) VALUES
            ('Acme Property', '456 Main St', 'Springfield', 'VA', '22151', 'Jane Doe', '(123)456-7891', '1', 'Residential', '2030-05-31', '');

            INSERT INTO user_roles (user_id, role_id) VALUES 
            ('1', '1'),
            ('2', '2'),
            ('3', '3');
        ";

        $pdo->exec($sql);

        $roles = ['super_admin', 'admin', 'dealer', 'organization', 'property', 'user'];
        $resources = [
            'super_admin' => ['admin_panel', 'admin_setup', 'dashboard', 'my_iis', 'my_properties', 'property', 'integrations', 'my_roles', 'users', 'settings'],
            'admin' => ['dealer_setup', 'dashboard', 'my_iis', 'my_properties', 'property', 'integrations', 'my_roles', 'users', 'settings'],
            'dealer' => ['dashboard', 'my_iis', 'my_properties', 'property', 'integrations', 'my_roles', 'users', 'settings'],
            'organization admin' => ['dashboard', 'my_iis', 'my_properties', 'property', 'integrations', 'my_roles', 'users', 'settings'],
            'property admin' => ['dashboard', 'my_iis', 'property', 'integrations', 'my_roles', 'users', 'visitors', 'command_center', 'events', 'settings'],
            'user' => ['dashboard', 'visitors', 'command_center', 'events']
        ];
        $actions = ['read', 'write'];
        $sql = '';

        foreach ($roles as $role) {
            if (isset($resources[$role])) {
                foreach ($resources[$role] as $resource) {
                    foreach ($actions as $action) {
                        $sql .= "
                            INSERT INTO role_resources (role_id, resource_id, action_id)
                            VALUES (
                                (SELECT id FROM roles WHERE name = '$role'),
                                (SELECT id FROM resources WHERE name = '$resource'),
                                (SELECT id FROM actions WHERE name = '$action')
                            );\n";
                    }
                }
            }
        }

        $pdo->exec($sql);
    }

    public static function down(PDO $pdo)
    {
        $sql = "
            DELETE FROM role_resources;
            DELETE FROM roles;
            DELETE FROM actions;
            DELETE FROM resources;
            DELETE FROM users;
            DELETE FROM organizations;
            DELETE FROM properties;
            DELETE FROM user_roles;
        ";

        $pdo->exec($sql);
    }
}
