<?php

class Migration_20240712000004_create_preference_table
{
    public static function up(PDO $pdo)
    {
        // Create the app_settings table
        $sql = "
            CREATE TABLE IF NOT EXISTS `app_settings` (
                `id` INT NOT NULL AUTO_INCREMENT,
                `theme_mode` VARCHAR(50),
                `time_format` VARCHAR(50),
                `time_zone` VARCHAR(50),
                `auto_logout_time` VARCHAR(50),
                `app_start_page` VARCHAR(50),
                PRIMARY KEY (`id`)
            )
        ";

        $pdo->exec($sql);

        // Insert initial values into the app_settings table
        $insertSql = "
            INSERT INTO app_settings (theme_mode, time_format, time_zone, auto_logout_time, app_start_page) 
            VALUES (:theme_mode, :time_format, :time_zone, :auto_logout_time, :app_start_page)
        ";

        $stmt = $pdo->prepare($insertSql);
        $stmt->execute([
            'theme_mode' => 'light',
            'time_format' => '12h',
            'time_zone' => 'UTC',
            'auto_logout_time' => '86400000',
            'app_start_page' => ''
        ]);
    }

    public static function down(PDO $pdo)
    {
        $sql = "DROP TABLE IF EXISTS `app_settings`";
        $pdo->exec($sql);
    }
}
