<?php

class Migration_20240712000006_create_schedule_tables
{
    public static function up(PDO $pdo)
    {
        $sql = "
            CREATE TABLE IF NOT EXISTS schedule_events (
                id INT AUTO_INCREMENT PRIMARY KEY,
                color VARCHAR(255) NOT NULL,
                title VARCHAR(255) NOT NULL UNIQUE,
                description TEXT,
                eventStartDate TEXT,
                eventEndDate TEXT,
                isAllDay TEXT,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            );

            CREATE TABLE IF NOT EXISTS calendar_added_events (
                id INT AUTO_INCREMENT PRIMARY KEY,
                title VARCHAR(255) NOT NULL,
                start TEXT NOT NULL,
                end TEXT,
                backgroundColor VARCHAR(7),
                borderColor VARCHAR(7),
                allDay VARCHAR(250),
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            )
        ";

        $pdo->exec($sql);
    }

    public static function down(PDO $pdo)
    {
        $sql = "
            DROP TABLE IF EXISTS schedule_events;
            DROP TABLE IF EXISTS calendar_added_events;
        ";

        $pdo->exec($sql);
    }
}
