<?php

class Migration_20240712000017_roles_tbl_mod
{
    public static function up(PDO $pdo)
    {
        $sql = "
            CREATE TABLE IF NOT EXISTS custom_roles (
                id INT AUTO_INCREMENT PRIMARY KEY,
                name VARCHAR(50) NOT NULL,
                site_id INT NOT NULL,
                layer ENUM('super_admin', 'admin', 'dealer', 'organization', 'property', 'user', 'visitor') NOT NULL,
                created_by INT NOT NULL,
                FOREIGN KEY(created_by) REFERENCES users(id),
                FOREIGN KEY(site_id) REFERENCES properties(id)
            )
        ";

        $pdo->exec($sql);
    }

    public static function down(PDO $pdo)
    {
        $sql = "
            DROP TABLE IF EXISTS custom_roles;
        ";

        $pdo->exec($sql);
    }
}
