<?php

class Migration_20240725000000_live_camera_streaming
{
    public static function up(PDO $pdo)
    {
        // Drop the table if it already exists
        $sql = "
            DROP TABLE IF EXISTS `live_camera_streaming_data`
        ";
        $pdo->exec($sql);

        // Create the table with the specified columns
        $sql1 = "
            CREATE TABLE IF NOT EXISTS `live_camera_streaming_data` (
                `id` INT AUTO_INCREMENT PRIMARY KEY,
                `streamingUrl` VARCHAR(255) ,
                `cameraName` VARCHAR(255) NOT NULL,
                `cameraModel` VARCHAR(255) NOT NULL,
                `userName` VARCHAR(255),
                `password` VARCHAR(255),
                `IP` VARCHAR(255),
                `RTSP_PORT` VARCHAR(255),
                `user` INT,
                `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                FOREIGN KEY (`user`) REFERENCES `users`(`id`)
            )
        ";
        $pdo->exec($sql1);
    }

    public static function down(PDO $pdo)
    {
        // Drop the table if it exists
        $sql = "
            DROP TABLE IF EXISTS `live_camera_streaming_data`
        ";
        $pdo->exec($sql);
    }
}
