<?php

class Migration_20240731122816_alter_table_data_menu
{
    public static function up(PDO $pdo)
    {
        // Alter the table to add new columns
        $sql1 = "
            ALTER TABLE resources
            ADD COLUMN slug VARCHAR(100),
            ADD COLUMN dataPage VARCHAR(255),
            ADD COLUMN label VARCHAR(100),
            ADD COLUMN icon VARCHAR(255),
            ADD COLUMN parentId INT,
            ADD COLUMN isChild VARCHAR(255);
        ";
        $pdo->exec($sql1);

        // Array of data to insert/update
        $data = [
            ['name' => 'dashboard', 'slug' => 'dashboard.php', 'dataPage' => '', 'label' => 'Dashboard', 'icon' => 'far fa-regular fa-user', 'parentId' => NULL, 'isChild' => ''],
            ['name' => 'my_iis', 'slug' => 'dashboard.php?tab=my_numbers', 'dataPage' => 'My II #\'s', 'label' => 'My II #\'s', 'icon' => 'far fa-solid fa-phone', 'parentId' => NULL, 'isChild' => ''],
            ['name' => 'my_properties', 'slug' => 'dashboard.php?tab=my_properties', 'dataPage' => 'include/my_properties.php', 'label' => 'My Properties', 'icon' => 'fa-solid fa-address-book', 'parentId' => NULL, 'isChild' => ''],
            ['name' => 'property', 'slug' => '#', 'dataPage' => '', 'label' => 'Property', 'icon' => 'far fa-solid fa-gears', 'parentId' => 1, 'isChild' => ''],
            ['name' => 'integrations', 'slug' => '#', 'dataPage' => '', 'label' => 'Integrations', 'icon' => 'far fa-solid fa-toolbox', 'parentId' => NULL, 'isChild' => ''],
            ['name' => 'my_roles', 'slug' => 'dashboard.php?tab=roles', 'dataPage' => 'include/rolestbl.php', 'label' => 'My Roles', 'icon' => 'fa-solid fa-user-secret', 'parentId' => NULL, 'isChild' => ''],
            ['name' => 'users', 'slug' => 'dashboard.php?tab=users', 'dataPage' => 'include/users/users.php', 'label' => 'Users', 'icon' => 'far fa-solid fa-key', 'parentId' => NULL, 'isChild' => ''],
            ['name' => 'visitors', 'slug' => '#', 'dataPage' => '', 'label' => 'Visitors', 'icon' => 'far fa-solid fa-unlock-keyhole', 'parentId' => NULL, 'isChild' => ''],
            ['name' => 'payment_invoice', 'slug' => 'dashboard.php?tab=payment_invoice', 'dataPage' => 'Payment / Invoice', 'label' => 'Payment / Invoice', 'icon' => 'far fa-solid fa-dollar', 'parentId' => NULL, 'isChild' => ''],
            ['name' => 'command_center', 'slug' => '#', 'dataPage' => '', 'label' => 'Command Center', 'icon' => 'far fa-solid fa-gamepad', 'parentId' => NULL, 'isChild' => ''],
            ['name' => 'events', 'slug' => '#', 'dataPage' => '', 'label' => 'Events', 'icon' => 'far fa-solid fa-clipboard-list', 'parentId' => NULL, 'isChild' => ''],
            ['name' => 'settings', 'slug' => 'settings.php', 'dataPage' => '', 'label' => 'Settings', 'icon' => 'far fa-solid fa-gears', 'parentId' => NULL, 'isChild' => ''],
            ['name' => 'admin_panel', 'slug' => 'admin_panel.php', 'dataPage' => '', 'label' => 'Super Admin Settings', 'icon' => 'far fa-solid fa-gears', 'parentId' => NULL, 'isChild' => ''],
            ['name' => 'admin_setup', 'slug' => 'dashboard.php?tab=admin_setup', 'dataPage' => 'include/admin_setup.php', 'label' => 'Admin Setup Area', 'icon' => 'far fa-solid fa-gears', 'parentId' => NULL, 'isChild' => ''],
            ['name' => 'dealer_setup', 'slug' => '#', 'dataPage' => 'include/dealer_setup.php', 'label' => 'Dealer Setup Area', 'icon' => 'far fa-solid fa-gears', 'parentId' => NULL, 'isChild' => ''],
        ];

        foreach ($data as $row) {
            $sql2 = "
                UPDATE resources SET 
                    slug = :slug, 
                    dataPage = :dataPage, 
                    label = :label, 
                    icon = :icon, 
                    parentId = :parentId, 
                    isChild = :isChild
                WHERE name = :name
            ";
            $stmt = $pdo->prepare($sql2);
            $stmt->execute([
                ':slug' => $row['slug'],
                ':dataPage' => $row['dataPage'],
                ':label' => $row['label'],
                ':icon' => $row['icon'],
                ':parentId' => $row['parentId'],
                ':isChild' => $row['isChild'],
                ':name' => $row['name'],
            ]);
        }

        $sql2="
        INSERT INTO resources (name, slug, dataPage, label, icon, parentId, isChild) VALUES 
            ('property_builder', 'dashboard.php?tab=property_builder', '', 'Property Builder', 'far fa-solid fa-gears', 1, 'true')
            ;
        ";
        $pdo->exec($sql2);

        $roles = ['super_admin', 'admin', 'dealer', 'organization admin', 'property admin'];
        $resources = [
            'super_admin' => ['property_builder'],
            'admin' => ['property_builder'],
            'dealer' => ['property_builder'],
            'organization admin' => ['property_builder'],
            'property admin' => ['property_builder'],
        ];
        $actions = ['read', 'write'];
        $sql3 = '';

        foreach ($roles as $role) {
            if (isset($resources[$role])) {
                foreach ($resources[$role] as $resource) {
                    foreach ($actions as $action) {
                        $sql3 .= "
                            INSERT INTO role_resources (role_id, resource_id, action_id)
                            VALUES (
                                (SELECT id FROM roles WHERE name = '$role'),
                                (SELECT id FROM resources WHERE name = '$resource'),
                                (SELECT id FROM actions WHERE name = '$action')
                            );\n";
                    }
                }
            }
        }

        $pdo->exec($sql3);

    }

    public static function down(PDO $pdo)
    {
        // Rollback the migration by dropping the columns (optional)
        $sql = "
            ALTER TABLE resources
            DROP COLUMN slug,
            DROP COLUMN dataPage,
            DROP COLUMN label,
            DROP COLUMN icon,
            DROP COLUMN parentId,
            DROP COLUMN isChild;
        ";
        $pdo->exec($sql);
    }
}