<?php

class Migration_20240829180749_altering_qr_table
{
    public static function up(PDO $pdo)
    {
        // SQL statement to add the templateId column and set it as a foreign key
        $sql = "
        ALTER TABLE qr_code
        ADD COLUMN templateId INT NULL,
        ADD CONSTRAINT FK_templateId FOREIGN KEY (templateId) REFERENCES qr_code_templates(id) ON DELETE SET NULL;
        ";
        
        // Execute the SQL statement
        $pdo->exec($sql);
    }

    public static function down(PDO $pdo)
    {
        // SQL statement to remove the templateId column and the foreign key constraint
        $sql = "
        ALTER TABLE qr_code
        DROP FOREIGN KEY FK_templateId,
        DROP COLUMN templateId;
        ";
        
        // Execute the SQL statement
        $pdo->exec($sql);
    }
}
