<?php

class Migration_20240905154901_call_histories
{
    public static function up(PDO $pdo)
    {
        // Your migration code here
        $sql = "
            CREATE TABLE IF NOT EXISTS call_histories (
                id INT AUTO_INCREMENT PRIMARY KEY,
                call_sid VARCHAR(255) NOT NULL,
                second_person_call_sid VARCHAR(255) NULL,
                from_number VARCHAR(255) NOT NULL,
                to_number VARCHAR(255) NOT NULL,
                status VARCHAR(255) NULL,
                is_digit_press boolean default 0,
                is_authorized_code_use boolean default 0,
                is_visitor boolean default 0,
                count_participants INT default 0,
                conference_sid VARCHAR(255) NULL,
                conference_event_type VARCHAR(255) NULL,
                is_access_granted boolean default 0,
                owner_connected INT default 0,
                is_stream boolean default 0,
                stream_digit VARCHAR(12) default 0,
                pressed_digit INT default 0,
                count_caller_number INT default 0,
                cnam VARCHAR(255) NULL,
                second_person_join_time VARCHAR(30) NULL,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            );
        ";

        $pdo->exec($sql);
    }

    public static function down(PDO $pdo)
    {
        // Rollback code here
        $sql = "
            DROP TABLE IF EXISTS call_histories;
        ";

        $pdo->exec($sql);
    }
}