<?php

class Migration_20240927060224_create_tbl_vendors
{
    public static function up(PDO $pdo)
    {
        $sql = "
            CREATE TABLE IF NOT EXISTS `vendors` (
                `id` INT NOT NULL AUTO_INCREMENT,
                `company` VARCHAR(255) NOT NULL,
                `name` VARCHAR(255) NOT NULL,
                `key_mode` ENUM('uses', 'date', 'time', 'date_time', 'schedule') NOT NULL,
                `uses` INT,
                `start_date` DATE,
                `end_date` DATE,
                `start_time` TIME,
                `end_time` TIME,
                `key_type` ENUM('CallerID', 'Key_Code', 'Magic_Password') NOT NULL,
                `phone` VARCHAR(10),
                `key_code` INT,
                `magic_password` VARCHAR(100),
                `schedule` INT,
                `access` VARCHAR(255),
                `status` ENUM('Active', 'Inactive', 'Revoked', 'Expired'),
                `user_assoc` INT NOT NULL,
                `creator_type` ENUM('admin', 'user') NOT NULL,
                `property_id` INT NOT NULL,
                `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                PRIMARY KEY (`id`)
            )
        ";

        $pdo->exec($sql);
    }

    public static function down(PDO $pdo)
    {
        $sql = "
            DROP TABLE IF EXISTS vendors;
        ";

        $pdo->exec($sql);
    }
}