<?php

class Migration_20241106172758_property_permissions
{
    public static function up(PDO $pdo)
    {
        // Your migration code here
        $query = "
            CREATE TABLE IF NOT EXISTS property_permissions (
                id INT AUTO_INCREMENT PRIMARY KEY,
                property_id INT NOT NULL,
                door_id INT NULL,
                user_id INT NULL,
                actions_to_perform VARCHAR(255) DEFAULT '',
                created_by INT NULL,
                is_individual INT NULL,
                is_keep_open_to INT NULL,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                
                FOREIGN KEY (property_id) REFERENCES properties(id) ON DELETE CASCADE,
                FOREIGN KEY (door_id) REFERENCES hardwares_settings(id) ON DELETE SET NULL,
                FOREIGN KEY (user_id) REFERENCES property_users(id) ON DELETE SET NULL
            );
        ";
        $pdo->exec($query);
    }

    public static function down(PDO $pdo)
    {
        // Rollback code here
    }
}
