<?php

class Migration_20241120190134_events_remove_foreign_key
{
    public static function up(PDO $pdo)
    {
        // Remove the foreign key constraint from `created_by`
        $sql_remove_foreign_key = "
            ALTER TABLE `hardwares_settings_events`
            DROP FOREIGN KEY `fk_hardware_events_created_by`;
        ";

        // Execute the query
        $pdo->exec($sql_remove_foreign_key);
    }

    public static function down(PDO $pdo)
    {
        // Re-add the foreign key constraint for `created_by`
        $sql_add_foreign_key = "
            ALTER TABLE `hardwares_settings_events`
            ADD CONSTRAINT `fk_hardware_events_created_by`
            FOREIGN KEY (`created_by`) REFERENCES `users`(`id`);
        ";

        // Execute the query
        $pdo->exec($sql_add_foreign_key);
    }
}
