<?php

class Migration_20241219023937_create_tbl_multi_prop_users
{
    public static function up(PDO $pdo)
    {
        $sql = "
            CREATE TABLE IF NOT EXISTS `multi_prop_users` (
                `id` INT NOT NULL AUTO_INCREMENT,
                `role` INT NOT NULL,
                `role_type` INT NOT NULL,
                `property_id` INT,
                `status` ENUM('Active', 'Inactive', 'Revoked', 'Expired'),
                `user_assoc` INT NOT NULL,
                `firstname` VARCHAR(25) NOT NULL,
                `lastname` VARCHAR(25) NOT NULL,
                `unit` VARCHAR(10) NOT NULL,
                `street` INT NOT NULL,
                `mobile_number` VARCHAR(10) NOT NULL,
                `home_number` VARCHAR(10) NOT NULL,
                `photo_loc` INT NOT NULL,
                `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                `created_by` INT NOT NULL,
                `creator_type` ENUM('users', 'property_users'),
                `deleted_at` DATETIME DEFAULT NULL,
                PRIMARY KEY (`id`)
            )
        ";

        $pdo->exec($sql);
    }

    public static function down(PDO $pdo)
    {
        $sql = "
            DROP TABLE IF EXISTS multi_prop_users;
        ";

        $pdo->exec($sql);
    }
}