<?php

class Migration_20250211141045_create_calendar_tables
{
    public static function up(PDO $pdo)
    {        
        $sql1 = "
           CREATE TABLE schedule_periods (
                id INT AUTO_INCREMENT PRIMARY KEY,
                schedule_id INT NOT NULL,
                period_number INT NOT NULL,
                start_time TIME NOT NULL,
                end_time TIME NOT NULL,
                FOREIGN KEY (schedule_id) REFERENCES calendar_added_events(id) ON DELETE CASCADE
            );
        ";
        $pdo->exec($sql1);
        
        $sql2 = "
           CREATE TABLE schedule_period_days (
                id INT AUTO_INCREMENT PRIMARY KEY,
                period_id INT NOT NULL,
                day ENUM('sun', 'mon', 'tue', 'wed', 'thu', 'fri', 'sat') NOT NULL,
                is_active BOOLEAN DEFAULT FALSE,
                FOREIGN KEY (period_id) REFERENCES schedule_periods(id) ON DELETE CASCADE
            );
        ";
        $pdo->exec($sql2);
    }

    public static function down(PDO $pdo)
    {
        $pdo->exec("DROP TABLE IF EXISTS schedule_period_days");
        $pdo->exec("DROP TABLE IF EXISTS schedule_periods");
    }
}