<?php

class Migration_20250404034444_add_property_default_permissions
{
    public static function up(PDO $pdo)
    {
        $sql = "
            CREATE TABLE IF NOT EXISTS property_default_permissions (
                id INT AUTO_INCREMENT PRIMARY KEY,
                property_id INT NOT NULL,
                actions_to_perform JSON NOT NULL,
                is_keep_open_to TINYINT(1) DEFAULT 0,
                created_by INT DEFAULT NULL,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                FOREIGN KEY (property_id) REFERENCES properties(id) ON DELETE CASCADE
            );
        ";
        $pdo->exec($sql);
    }

    public static function down(PDO $pdo)
    {
        $pdo->exec("DROP TABLE IF EXISTS property_default_permissions;");
    }
}