<?php

class Migration_20250723214407_ftp_users_tbl
{
    public static function up(PDO $pdo)
    {
        $sql = "
            CREATE TABLE IF NOT EXISTS ftp_credentials (
                id INT AUTO_INCREMENT PRIMARY KEY,
                property_id INT NOT NULL,
                ftp_server_id INT NOT NULL,
                ftp_username VARCHAR(64) NOT NULL,
                ftp_password TEXT NOT NULL,
                created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
                updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                FOREIGN KEY (property_id) REFERENCES properties(id) ON DELETE CASCADE,
                FOREIGN KEY (ftp_server_id) REFERENCES ftp_servers(id) ON DELETE CASCADE
            );
        ";

        $pdo->exec($sql);
    }

    public static function down(PDO $pdo)
    {
        $sql = "DROP TABLE IF EXISTS ftp_credentials;";
        $pdo->exec($sql);
    }
}
