<?php

class Migration_20250726030606_create_dealer_ftp_tbl
{
    public static function up(PDO $pdo)
    {
        $pdo->exec("
            CREATE TABLE IF NOT EXISTS dealer_ftp_allocations (
                id INT AUTO_INCREMENT PRIMARY KEY,
                dealer_id INT NOT NULL,
                ftp_server_id INT NOT NULL,
                camera_slots_allowed INT NOT NULL DEFAULT 0,
                camera_slots_used INT NOT NULL DEFAULT 0,
                created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
                updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                UNIQUE KEY unique_dealer_server (dealer_id, ftp_server_id)
            );
        ");
    }

    public static function down(PDO $pdo)
    {
        $pdo->exec("DROP TABLE IF EXISTS dealer_ftp_allocations;");
    }
}
