<?php
ob_start(); // Add output buffering to prevent headers already sent errors
try {
    session_start();
    require 'db.php';
    require_once 'include/auth/auth_functions.php';
    if (!currentUserHasAccess($pdo, 'settings', 'read')) {
        if (isset($_SESSION['userid'])) {
            echo "Access denied.";
            if (!headers_sent()) {
                header( "refresh:5;url=/dashboard.php" );
            }
        }else {
            if (!headers_sent()) {
                header("Location: /login.php");
            }
        }
        exit();
    }
} catch (\Throwable $th) {
    // throw $th;
}

    $user_type = $_SESSION["layer"];
?>

<!DOCTYPE html>

<!--
This is a starter template page. Use this page to start your new project from
scratch. This page gets rid of all links and provides the needed markup only.
-->
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo $_SESSION['csrf_token']; ?>">
    <title>Invisible Intercom | Events</title>

    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <link rel="stylesheet" href="css/all.min.css">
    <link rel="stylesheet" href="css/adminlte.min.css">
    <link rel="stylesheet" href="css/bootstrap-4.min.css">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/css/select2.min.css" rel="stylesheet" />
    <link href="https://raw.githack.com/ttskch/select2-bootstrap4-theme/master/dist/select2-bootstrap4.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.dataTables.min.css">

    <link rel="icon" type="image/x-icon" href="include/images/favicon.ico">
    <link rel="stylesheet" href="css/jsgrid.min.css">
    <link rel="stylesheet" href="css/jsgrid-theme.min.css">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.min.css">

    <link rel="stylesheet" href="css/dashboard.css">
    <link rel="stylesheet" href="css/property-builder/qr_code.css">
    <link rel="stylesheet" href="css/property-builder/hardware.css">
    <link rel="stylesheet" href="js/fullcalendar/main.css">
    <link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.15/index.global.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.15/index.global.min.js"></script>

    <link rel="stylesheet" href="js/fullcalendar/daterangepicker.css">
    <link rel="stylesheet" href="css/icheck-bootstrap.min.css">
    <script src="js/jquery.min.js"></script>
    <script src="https://unpkg.com/@bitjson/qr-code@1.0.2/dist/qr-code.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/html-to-image@latest/dist/html-to-image.min.js"></script>
    <link rel="stylesheet" href="js/bootstrap-switch/css/bootstrap3/bootstrap-switch.min.css">
    <link rel="stylesheet" href="https://uicdn.toast.com/tui-image-editor/latest/tui-image-editor.css">
    <link rel="stylesheet" href="https://uicdn.toast.com/tui-color-picker/latest/tui-color-picker.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.12/cropper.min.css">
    <script src="js/dashboard/streaming.min.js"></script>

</head>

<body class="hold-transition sidebar-mini" id="body_body">
   
    <div class="wrapper">

        <!-- Navbar -->
        <?php include 'shared/header.nav.php'; ?>
        <!-- /.navbar -->

        <!-- Modals Start-->
        <?php include 'shared/modal.php'; ?>

        <!-- End Modals -->

        <!-- Main Sidebar Container -->
        <aside class="main-sidebar" id="sidebar-con">
            <?php
            include 'shared/aside.nav.php'; ?>
            <!-- /.sidebar -->
        </aside>

        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <div class="content"> 
                <div class="container-fluid">  
                    <div class="col-12" id="pending_payments_container">
                        <div class="row">
                            <div class="col-12" style="margin-top: 20px;">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">Pending Payments</h3>
                                        <!-- Search bar -->
                                        <div class="card-tools">
                                            <div class="input-group input-group-sm" style="width: 250px;">
                                                <input type="text" id="searchPaymentInput" onkeyup="searchTable('pendingPaymentTable', 'searchPaymentInput')" class="form-control float-right" placeholder="Search Payment">
                                                <div class="input-group-append">
                                                    <button type="button" class="btn btn-default">
                                                        <i class="fas fa-search"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-hover" id="pendingPaymentTable">
                                                <thead>
                                                    <tr>
                                                        <th>Photo</th>
                                                        <th>Property</th>
                                                        <th>Amount</th>
                                                        <th>Date</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="PendingPaymentTableBody"></tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
        </div>
        <!-- Main Footer -->
        <?php include 'shared/footer.php'; ?>
    </div>

    <div class="modal fade" id="approve_pending_payment_model" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">

            <div class="modal-content">
                <div id="error_sms_call_block_message"></div>
                <div class="modal-header">
                    <h5 class="modal-title">Pending Payment for <span id="pending_payment_property"><span></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body">
                    <p class="alert alert-danger showHide" id="pending_balance_error_message">Something went wrong</p>
                    <div class="form-group">
                        <label>Amount</label>
                        <input type="number" name="pending_amount" id="pending_payment_amount" class="form-control">
                        <p class="badge badge-danger showHide" id="pending_payment_amount_message">Please add amount</p>
                        <input type="hidden" name="pending_payment_id" id="pending_payment_id">
                    </div>
                    <div class="form-group">
                        <Button type="button" name="save_button" class="btn btn-primary btn-block" onclick="approve_pending_payment()">Save</Button>
                    </div>
                </div> 
            </div>
        </div>
    </div>

    <div class="modal fade" id="pendingImageModal" tabindex="-1" role="dialog" aria-labelledby="snapImageModalTitle" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" style="width: 600px;height: 650px;" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Payment Image</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body text-center">
                    <img id="pendingPaymentImage" src="" alt="Snap" class="img-fluid" style="max-width: 100%; object-fit: contain;">
                </div>
            </div>
        </div>
    </div>

    <!-- /.control-sidebar -->

    <!-- ./wrapper -->

    <!-- REQUIRED SCRIPTS -->

    <!-- jQuery -->
    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.bundle.min.js"></script>
    <script src="js/adminlte.min.js"></script>
    <script src="js/events.js"></script>
    <script src="/js/settings/preferences.js"></script>
    <script src="js/dashboard_helper.js"></script>
    <script src="js/sessionRedirection.js"></script>
    <script src="js/dashboard.js"></script>
    <script src="js/select2.full.min.js"></script>
    <script src="js/jsgrid.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
    <script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
</body>

</html>
<?php ob_end_flush(); ?>