<?php
if (session_status() === PHP_SESSION_NONE) {
  session_start();
}

if (!empty($_SESSION['alert'])) {
  $alertType = $_SESSION['alert']['type'];
  $message = $_SESSION['alert']['message'];

  echo "
  <div class='alert alert-$alertType alert-dismissible fade show' role='alert' id='alertBox'>
      $message
      <button type='button' class='close' data-dismiss='alert' aria-label='Close'>
          <span aria-hidden='true'>&times;</span>
      </button>
  </div>
  <script>
      // Use JavaScript to remove the alert after 30 seconds
      setTimeout(function() {
          var alertBox = document.getElementById('alertBox');
          if (alertBox) {
              alertBox.classList.remove('show'); // Hide the alert
              alertBox.classList.add('fade');   // Ensure fade-out effect
              setTimeout(function() {
                  alertBox.remove(); // Remove the alert from the DOM
              }, 500); // Allow fade-out animation time
          }
      }, 10000); // 10 seconds
  </script>
  ";

  unset($_SESSION['alert']);
}

?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Invisible Intercom | Registration Page</title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="css/all.min.css">
  <!-- icheck bootstrap -->
  <link rel="stylesheet" href="css/icheck-bootstrap.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="css/adminlte.min.css">
  <!-- Custom Style -->
  <link rel="stylesheet" href="css/register.css">
</head>

<body class="hold-transition register-page" style="background-color: #fff;">
  <style>
    .fas{
        color: #000;
    }
  </style>
  <div class="register-box">
    <div class="">
      <div class=" register-card-body">
        <div class="register-logo">
          <a href="index.php"><img src="/include/images/Invisible_Intercom.png" alt="Invisible Logo"  style="height:100%;width:100%; margin-bottom: 15px;"></a>
        </div>

        <form id="registerForm" action="include/auth/signup.php" method="post">
          <div class="input-group mb-3">
            <input type="email" name="email" class="form-control" placeholder="Email" required style="border-radius: 7px 0px 0px 7px; background-color: #f8f8f8;">
            <div class="input-group-append">
              <div class="input-group-text" style="border-radius: 0px 7px 7px 0px; background-color: #f8f8f8;">
                <span class="fas fa-envelope"></span>
              </div>
            </div>
          </div>
          <div class="input-group mb-3">
            <input type="homphone" name="homphone" class="form-control" oninput="formatPhoneNumber(this)" onpaste="handlePaste(event)" placeholder="Home Phone Optional" style="border-radius: 7px 0px 0px 7px; background-color: #f8f8f8;">
            <div class="input-group-append">
              <div class="input-group-text" style="border-radius: 0px 7px 7px 0px; background-color: #f8f8f8;">
                <span class="fas fa-phone"></span>
              </div>
            </div>
          </div>
          <div class="input-group mb-3">
            <input type="password" name="pwd" id="pwd" class="form-control" placeholder="Password" required style="border-radius: 7px 0px 0px 7px; background-color: #f8f8f8;">
            <div class="input-group-append">
              <div class="input-group-text" style="border-radius: 0px 7px 7px 0px; background-color: #f8f8f8;">
                <span class="fas fa-lock" title="Password"></span>
              </div>
            </div>
          </div>
          <small id="passwordHelp" class="form-text text-muted">
              Password must be at least 8 characters, include 1 uppercase letter, 1 number, and 1 special character.
          </small>
          <div class="input-group mb-3">
            <progress id="passwordStrength" max="100" value="0" class="w-100"></progress>
            <span id="passwordStrengthText" class="password-strength-text"> </span>
          </div>

          <div class="input-group mb-3">
            <input type="password" name="pwdc" id="pwdc" class="form-control" placeholder="Retype password" required style="border-radius: 7px 0px 0px 7px; background-color: #f8f8f8;">
            <div class="input-group-append">
              <div class="input-group-text" style="border-radius: 0px 7px 7px 0px; background-color: #f8f8f8;">
                  <span class="fas fa-lock" title="Confirm Password"></span>
              </div>
            </div>
          </div>

          <div id="passwordError" class="text-danger mb-3" style="display: none;"></div>

          <input type="hidden" name="token" value="<?php echo htmlspecialchars($_GET['token']); ?>">
          
          <div class="row">
            <div class="col-12">
              <div class="icheck-dark dark-color">
                <input type="checkbox" id="agreeTerms" name="terms" value="agree" required>
                <label for="agreeTerms">
                    I agree to the <a href="#" data-toggle="modal" data-target="#termsModal">Terms & Conditions</a>
                </label>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <button type="submit" name="submit" class="btn btn-dark btn-block" style="border-radius: 7px 7px 7px 7px; ">Register</button>
            </div>
          </div>
          <div class="row">
            <div class="col-md-12 text-center mt-3 remeber_pass">
                INVISIBLE ACCESS CONTROL
            </div>
          </div>
        </form>

        <div class="modal fade" id="termsModal" tabindex="-1" role="dialog" aria-labelledby="termsModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="termsModalLabel">
                  <p><b>Invisible Intercom Terms and Conditions</b><br /></p>
                  <p><b>Effective Date: December 4, 2024</b><br /></p>
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <div style="font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 10pt">
                  <p>These Terms and Conditions ("Terms") govern your access to and use of the Invisible Intercom platform ("the Service"), a product provided by <b>Anvid Inc., a Virginia corporation</b> ("we," "us," or "our").<br /></p><p>By registering, accessing, or using the Service, you agree to be bound by these Terms. If you do not agree, do not use the Service.<br /></p>
                  <hr />
                    <h3>1. Acceptance of Terms<br /></h3>
                      <p>By using Invisible Intercom, you confirm that:<br /></p>
                      <ul>
                        <li><p style="margin-top: 0px">You are at least 18 years old or are under 18 but have obtained the consent of a parent or legal guardian.<br /></p></li>
                        <li><p style="margin-top: 0px">If you are a parent or guardian permitting a minor to use the Services, you accept full responsibility for the minor’s use of the platform.<br /></p></li>
                        <li><p style="margin-top: 0px">You have the authority to agree to these Terms on behalf of yourself or your organization.<br /></p></li>
                      </ul>
                  <hr />
                    <h3>2. Scope of Services<br /></h3>
                      <p>Invisible Intercom provides software and cloud-based services that interface with physical electronic security systems such as gates, doors, surveillance hardware, and access control systems. The Services include but are not limited to:<br /></p>
                      <ul>
                        <li><p style="margin-top: 0px">Visitor access management via QR codes, phone numbers, phone calls, and keypad codes<br /></p></li>
                        <li><p style="margin-top: 0px">Remote unlocking of gates and doors by authorized users<br /></p></li>
                        <li><p style="margin-top: 0px">Communication with authorized points of contact ("APOCs")<br /></p></li>
                        <li><p style="margin-top: 0px">Integration with new and existing systems such as access control, I/O devices, surveillance hardware and/or software<br /></p></li>
                      </ul>
                  <hr />
                    <h3>3. User Responsibilities<br /></h3>
                    <h4>a. Compliance with Laws<br /></h4>
                    <p>You are responsible for complying with all local, state, and federal laws, including privacy, surveillance, access control, and call recording regulations.<br /></p>
                    <h4>b. Authorized Use Only<br /></h4>
                    <p>You may not:<br /></p>
                    <ul>
                      <li><p style="margin-top: 0px">Share access credentials or codes with unauthorized individuals<br /></p></li>
                      <li><p style="margin-top: 0px">Tamper with, reverse-engineer, or misuse the platform<br /></p></li>
                      <li><p style="margin-top: 0px">Use the Service to bypass lawful security controls<br /></p></li>
                    </ul>
                    <h4>c. Granting Access<br /></h4>
                    <ul>
                      <li><p style="margin-top: 0px">You are responsible for verifying a visitor's identity before granting access.<br /></p></li>
                      <li><p style="margin-top: 0px">You accept full responsibility for the conduct of any person you grant access to.<br /></p></li>
                      <li><p style="margin-top: 0px">Keypad codes must be actively managed and revoked when no longer needed.<br /></p></li>
                      <li><p style="margin-top: 0px">Invisible Intercom does not vet visitors or monitor their actions after access is granted. You assume full liability for their conduct.<br /></p></li>
                    </ul>
                    <h4>d. Use of Codes ("Magic Passwords")<br /></h4>
                    <ul>
                      <li><p style="margin-top: 0px">You are responsible for all use of any codes you create or share.<br /></p></li>
                      <li><p style="margin-top: 0px">We recommend time-limited or single-use codes.<br /></p></li>
                      <li><p style="margin-top: 0px">Monitor code activity and deactivate compromised codes.<br /></p></li>
                    </ul>
                    <h4>e. Access Method Security<br /></h4>
                    <ul>
                      <li><p style="margin-top: 0px">Safeguard all credentials and access tools.<br /></p></li>
                      <li><p style="margin-top: 0px">Notify us immediately of any suspected unauthorized access.<br /></p></li>
                    </ul>
                    <h4>f. Dealers and Third-Party Installers<br /></h4>
                    <ul>
                      <li><p style="margin-top: 0px">Invisible Intercom may refer users to authorized local dealers for installation or support services. These dealers operate independently but are expected to comply with our service standards and data protection guidelines. Invisible Intercom is not liable for their performance or conduct. By submitting a request for quote or service, you consent to your information being shared with a dealer in your region for this purpose.<br /></p></li>
                      <li><p style="margin-top: 0px">Notify us immediately of any suspected unauthorized access.<br /></p></li>
                    </ul>
                    <h4>g. Risk Acknowledgment<br /></h4>
                    <ul>
                      <li><p style="margin-top: 0px">You acknowledge the risks of enabling access for third parties, including strangers, and accept full responsibility for that access. Invisible Intercom provides tools to manage access, but cannot guarantee that access will always be limited to intended individuals.<br /></p></li>
                    </ul>
                  <hr />
                    <h3>4. Hardware and Third-Party Integrations<br /></h3>
                    <ul>
                      <li><p style="margin-top: 0px"><b>Hardware Compatibility</b>: Invisible Intercom works with certain physical security systems, including electronic gates and door controllers. You are responsible for ensuring the compatibility and proper installation of these systems with the platform.<br /></p></li>
                      <li><p style="margin-top: 0px"><b>Third-Party Responsibility</b>: Any third-party hardware or software integrations are the responsibility of the property owner or manager. We are not liable for malfunctions, improper installations, or failures of third-party systems.<br /></p></li>
                      <li><p style="margin-top: 0px"><b>Third-Party Equipment</b>: Invisible Intercom integrates with third-party hardware such as access control devices, I/O components, and surveillance cameras. We do not manufacture or certify these products and are not responsible for their performance, accuracy, security, or continued operation. Any issues with third-party devices must be addressed with the original manufacturer or supplier.<br /></p></li>
                    </ul>
                  <hr />
                    <h3>5. Access Control Functionality<br /></h3>
                    <ul>
                      <li><p style="margin-top: 0px">Visitors may use QR codes or call the dedicated number to request access. QR codes and signage must be clearly visible and functional.<br /></p></li>
                      <li><p style="margin-top: 0px">Calls are routed to an APOC, who may grant or deny access remotely. APOCs are responsible for verifying the identity and purpose of the visitor before granting access.<br /></p></li>
                    </ul>
                  <hr />
                    <h3>6. ADA Compliance<br /></h3>
                    <ul>
                      <li><p style="margin-top: 0px">You must ensure signage complies with ADA regulations.<br /></p></li>
                      <li><p style="margin-top: 0px">Invisible Intercom provides accessibility features such as keypad access for visually impaired users.<br /></p></li>
                      <li><p style="margin-top: 0px">Property owners and managers are solely responsible for ADA compliance in signage and hardware placement. If a custom sign is needed for compliance, please contact your installer or local sign provider.<br /></p></li>
                    </ul>
                  <hr />
                    <h3>7. Contractors and Installation<br /></h3>
                    <ul>
                      <li><p style="margin-top: 0px">Installation must be completed by qualified professionals where required by law.<br /></p></li>
                      <li><p style="margin-top: 0px">Property owners are responsible for selecting and supervising contractors.<br /></p></li>
                      <li><p style="margin-top: 0px">We do not guarantee the quality of work performed by third-party installers.<br /></p></li>
                      <li><p style="margin-top: 0px">Maintenance and compatibility of connected hardware are the user’s responsibility.<br /></p></li>
                    </ul>
                  <hr />
                    <h3>8. Privacy and Data Security<br /></h3>
                    <ul>
                      <li><p style="margin-top: 0px">We collect data such as access logs, call activity, and code usage for platform functionality and improvement.<br /></p></li>
                      <li><p style="margin-top: 0px">We take reasonable measures to protect your data but cannot guarantee absolute security.<br /></p></li>
                      <li><p style="margin-top: 0px">If calls are recorded, you must notify visitors and comply with applicable recording laws.<br /></p></li>
                      <li><p style="margin-top: 0px"><b>Personal Information</b>: We may collect personal information such as names, email addresses, mobile and home phone numbers, property addresses, and access logs. This data is collected to provide and improve the Services and is handled in accordance with our Privacy Policy. By using the platform, you consent to the collection and processing of your data as outlined in these Terms and our Privacy Policy. Users are responsible for keeping their contact and access information up to date.<br /></p></li>
                    </ul>
                  <hr />
                    <h3>9. Intellectual Property<br /></h3>
                    <ul>
                      <li><p style="margin-top: 0px">All content, software, and materials related to Invisible Intercom are owned by Anvid Inc. or its licensors. You may not copy, modify, distribute, or reverse-engineer any part of the platform without our written consent.<br /></p></li>
                    </ul>
                  <hr />
                    <h3>10. Liability Disclaimer<br /></h3>
                    <ul>
                      <li><p style="margin-top: 0px">We are not liable for unauthorized access or security breaches.<br /></p></li>
                      <li><p style="margin-top: 0px">We are not liable for damages caused by system failure, user error, or third-party hardware.<br /></p></li>
                      <li><p style="margin-top: 0px">We do not vet visitors or monitor their behavior. Users assume full liability for those granted access.<br /></p></li>
                    </ul>
                  <hr />
                    <h3>11. Insurance Considerations<br /></h3>
                    <ul>
                      <li><p style="margin-top: 0px">We do not provide property or liability insurance.<br /></p></li>
                      <li><p style="margin-top: 0px">Property owners must maintain appropriate insurance.<br /></p></li>
                      <li><p style="margin-top: 0px">Users are responsible for managing risk through access monitoring and code control.<br /></p></li>
                    </ul>
                  <hr />
                    <h3>12. Service Availability<br /></h3>
                    <ul>
                      <li><p style="margin-top: 0px">We do not guarantee uninterrupted or error-free service.<br /></p></li>
                      <li><p style="margin-top: 0px">We may update, suspend, or discontinue the Service at any time without notice.<br /></p></li>
                      <li><p style="margin-top: 0px"><b>Cloud Infrastructure and External Dependencies</b>: Invisible Intercom is a cloud-based service and relies on third-party infrastructure, including internet connectivity, cloud hosting, and mobile operating systems. We do not guarantee continuous availability and are not responsible for delays, outages, or failures caused by third-party networks, mobile platforms, or hardware integrations.<br /></p></li>
                    </ul>
                  <hr />
                    <h3>13. FCC Compliance<br /></h3>
                    <ul>
                      <li><p style="margin-top: 0px">We comply with FCC regulations for telecommunications and electronic systems.<br /></p></li>
                      <li><p style="margin-top: 0px">You are responsible for complying with additional local telecom requirements.<br /></p></li>
                      <li><p style="margin-top: 0px">We are not responsible for fees, fines, or violations in your jurisdiction.<br /></p></li>
                    </ul>
                  <hr />
                    <h3>14. Indemnification<br /></h3>
                    <p>You agree to indemnify and hold harmless Anvid Inc. from any claims, liabilities, or damages arising from:<br /></p>
                    <ul>
                      <li><p style="margin-top: 0px">Your use of the Service<br /></p></li>
                      <li><p style="margin-top: 0px">Unauthorized access resulting from your actions<br /></p></li>
                      <li><p style="margin-top: 0px">Violation of laws or these Terms<br /></p></li>
                    </ul>
                  <hr />
                    <h3>15. Termination<br /></h3>
                    <p>We may terminate your access to the platform for violating these Terms or engaging in behavior that compromises system security or integrity.<br /></p>
                  <hr />
                    <h3>16. Governing Law and Dispute Resolution<br /></h3>
                    <ul>
                      <li><p style="margin-top: 0px">These Terms are governed by the laws of the Commonwealth of Virginia.<br /></p></li>
                      <li><p style="margin-top: 0px">Disputes will be resolved through binding arbitration in Fairfax County, VA, unless prohibited by law.<br /></p></li>
                    </ul>
                  <hr />
                    <h3>17. Modifications to Terms<br /></h3>
                    <p>We may update these Terms at any time. Continued use of the Service constitutes your acceptance of any updated Terms.<br /></p>
                  <hr />
                    <h3>18. Contact Information<br /></h3>
                    <p>For questions regarding these Terms, contact:<br /></p>
                    <p><br /></p>
                    <div>
                      <b>Invisible Intercom</b>
                      <br />
                    </div>
                    <div>Email: <a href="mailto:support@invisibleintercom.com" target="_blank">support@invisibleintercom.com</a>
                      <br />
                    </div>
                    <div>
                      <br />
                    </div>
                    <p>
                      <br />
                    </p>
                  <hr />
                  <p><b>By using Invisible Intercom, you agree to these Terms and Conditions. Thank you for trusting us to manage your visitor and access control needs.</b><br /></p>
                </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <?php
      if (isset($_GET["error"])) {
          $message = '';
          switch ($_GET["error"]) {
              case "emptyinput":
                  $message = "Please fill in all fields!";
                  break;
              case "invalidemail":
                  $message = "Email is not valid!";
                  break;
              case "passwordsdonotmatch":
                  $message = "Passwords do not match!";
                  break;
              case "emailalreadyexists":
                  $message = "This email has already been registered. Please login instead!";
                  break;
              case "invitationnotfound":
                  $message = "An invitation was not found. Please enter the correct email address.";
                  break;
          }

          if (!empty($message)) {
              echo "
              <div class='alert alert-danger alert-dismissible fade show' role='alert' id='alertBox'>
                  $message
                  <button type='button' class='close' data-dismiss='alert' aria-label='Close'>
                      <span aria-hidden='true'>&times;</span>
                  </button>
              </div>
              <script>
                  setTimeout(function() {
                      var alertBox = document.getElementById('alertBox');
                      if (alertBox) {
                          alertBox.classList.remove('show');
                          alertBox.classList.add('fade');
                          setTimeout(function() {
                              alertBox.remove();
                          }, 500);
                      }
                  }, 10000);
              </script>
              ";
          }
      }
    ?>
  </div>
  <!-- /.register-box -->

  <!-- js -->
  <script src="js/register.js"></script>
  <!-- jQuery -->
  <script src="js/jquery.min.js"></script>
  <!-- Bootstrap 4 -->
  <script src="js/bootstrap.bundle.min.js"></script>
  <!-- AdminLTE App -->
  <script src="js/adminlte.min.js"></script>
</body>

</html>