<?php
ob_start(); // Add output buffering to prevent headers already sent errors
try {
    session_start();
    require 'db.php';
    require_once 'include/auth/auth_functions.php';
    if (!currentUserHasAccess($pdo, 'settings', 'read')) {
        if (isset($_SESSION['userid'])) {
            echo "Access denied.";
            if (!headers_sent()) {
                header( "refresh:5;url=/dashboard.php" );
            }
        }else {
            if (!headers_sent()) {
                header("Location: /login.php");
            }
        }
        exit();
    }
} catch (\Throwable $th) {
    // throw $th;
}

    $user_type = $_SESSION["layer"];
?>

<!DOCTYPE html>

<!--
This is a starter template page. Use this page to start your new project from
scratch. This page gets rid of all links and provides the needed markup only.
-->
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo $_SESSION['csrf_token']; ?>">
    <title>Invisible Intercom | Events</title>

    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <link rel="stylesheet" href="css/all.min.css">
    <link rel="stylesheet" href="css/adminlte.min.css">
    <link rel="stylesheet" href="css/bootstrap-4.min.css">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/css/select2.min.css" rel="stylesheet" />
    <link href="https://raw.githack.com/ttskch/select2-bootstrap4-theme/master/dist/select2-bootstrap4.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.dataTables.min.css">

    <link rel="icon" type="image/x-icon" href="include/images/favicon.ico">
    <link rel="stylesheet" href="css/jsgrid.min.css">
    <link rel="stylesheet" href="css/jsgrid-theme.min.css">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.min.css">

    <link rel="stylesheet" href="css/dashboard.css">
    <link rel="stylesheet" href="css/property-builder/qr_code.css">
    <link rel="stylesheet" href="css/property-builder/hardware.css">
    <link rel="stylesheet" href="js/fullcalendar/main.css">
    <link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.15/index.global.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.15/index.global.min.js"></script>

    <link rel="stylesheet" href="js/fullcalendar/daterangepicker.css">
    <link rel="stylesheet" href="css/icheck-bootstrap.min.css">
    <script src="js/jquery.min.js"></script>
    <script src="https://unpkg.com/@bitjson/qr-code@1.0.2/dist/qr-code.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/html-to-image@latest/dist/html-to-image.min.js"></script>
    <link rel="stylesheet" href="js/bootstrap-switch/css/bootstrap3/bootstrap-switch.min.css">
    <link rel="stylesheet" href="https://uicdn.toast.com/tui-image-editor/latest/tui-image-editor.css">
    <link rel="stylesheet" href="https://uicdn.toast.com/tui-color-picker/latest/tui-color-picker.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.12/cropper.min.css">
    <script src="js/dashboard/streaming.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.4.0/jspdf.umd.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>

</head>

<body class="hold-transition sidebar-mini" id="body_body">
    <style>
        /* Custom styles for tab colors */
        .dataTables_info{
            display: none !important;
        }
        .previous{
            display: none !important;
        }
        .next{
            display: none !important;
        }
        .nav-tabs .nav-link {
            color: black;
            /* Default color for inactive tabs */
        }

        .nav-tabs .nav-link.active {
            color: blue;
            /* Color for active tab */
        }

        .nav-tabs .nav-link:hover {
            color: blue;
            /* Hover color for tabs */
        }

        .nav-tabs .nav-link.active {
            background-color: #f8f9fa;
            /* Background color for active tab */
            border-color: #dee2e6 #dee2e6 #fff;
            /* Border color adjustments */
        }
        .showHide{
            display: none;
        }
        .cost-card {
          min-height: 100%;
        }

        .progress-bar {
          background-color: #007bff;
          width: 10%;
        }

        .min-balance-text {
          font-size: 0.9rem;
          color: #555;
        }

        .progress {
          height: 16px;
          border-radius: 8px;
        }

        .card-title {
          font-weight: bold;
        }

        .cost-value {
          font-size: 1.3rem;
          font-weight: bold;
        }

        .list-group-item {
          border: none;
          padding: 0.25rem 0;
        }

        .recharge-btn {
          width: 100%;
        }
    </style>

    <?php

        $activeTab = "base_cost";
        if (isset($_GET["active"])) {
            switch ($_GET["active"]) {
                case 1:
                    $activeTab = "base_cost";
                    break;
                case 2:
                    $activeTab = "referrals";
                    break;
                case 3:
                    $activeTab = "variable_cost";
                    break;
                case 4:
                    $activeTab = "payment_history";
                    break;
                case 5:
                    $activeTab = "invoice_history";
                    break;
            }
        }
    ?>

    <div class="wrapper">

        <!-- Navbar -->
        <?php include 'shared/header.nav.php'; ?>
        <!-- /.navbar -->

        <!-- Modals Start-->
        <?php include 'shared/modal.php'; ?>

        <!-- End Modals -->

        <!-- Main Sidebar Container -->
        <aside class="main-sidebar" id="sidebar-con">
            <?php
            include 'shared/aside.nav.php'; ?>
            <!-- /.sidebar -->
        </aside>

        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <center>
                <div class="isLoading justify-content-center m-5" style="display: none;" id="setting_loading_indicator">
                    <img src="/include/images/loader.gif" style="width:100px;margin-left:5px" alt="" srcset="">
                </div>
            </center>
            <input type="hidden" name="active_tab_val" id="active_tab_val" value="<?php echo $activeTab; ?>">
            <ul class="nav nav-tabs" id="myTab" role="tablist">
            
                <!-- <li class="nav-item">
                    <a onclick="RedirectToActiveTabEvents('referrals')" class="nav-link <?php echo $activeTab == 'referrals' ? 'active' : ''; ?>" id="referrals-tab" data-toggle="tab" href="#referrals" role="tab" aria-controls="referrals" aria-selected="<?php echo $activeTab == 'referrals' ? 'true' : 'false'; ?>">Referrals</a>
                </li> -->
                <li class="nav-item"> 
                    <a onclick="RedirectToActiveTabEvents('base_cost')" class="nav-link <?php echo $activeTab == 'base_cost' ? 'active' : ''; ?>" id="base_cost-tab" data-toggle="tab" href="#base_cost" role="tab" aria-controls="base_cost" aria-selected="<?php echo $activeTab == 'base_cost' ? 'true' : 'false'; ?>">Base Cost</a>
                </li>
                <li class="nav-item"> 
                    <a onclick="RedirectToActiveTabEvents('variable_cost')" class="nav-link <?php echo $activeTab == 'variable_cost' ? 'active' : ''; ?>" id="variable_cost-tab" data-toggle="tab" href="#variable_cost" role="tab" aria-controls="variable_cost" aria-selected="<?php echo $activeTab == 'variable_cost' ? 'true' : 'false'; ?>">Variable Cost</a>
                </li>
                <li class="nav-item"> 
                    <a onclick="RedirectToActiveTabEvents('payment_history')" class="nav-link <?php echo $activeTab == 'payment_history' ? 'active' : ''; ?>" id="payment_history-tab" data-toggle="tab" href="#payment_history" role="tab" aria-controls="payment_history" aria-selected="<?php echo $activeTab == 'payment_history' ? 'true' : 'false'; ?>">Payment History</a>
                </li>
                <li class="nav-item"> 
                    <a onclick="RedirectToActiveTabEvents('invoice_history')" class="nav-link <?php echo $activeTab == 'invoice_history' ? 'active' : ''; ?>" id="invoice_history-tab" data-toggle="tab" href="#invoice_history" role="tab" aria-controls="invoice_history" aria-selected="<?php echo $activeTab == 'invoice_history' ? 'true' : 'false'; ?>">Invoice History</a>
                </li>
            </ul>
            <div class="tab-content">
                <span id="success_message"></span>
                <!-- <div class="tab-pane fade <?php echo $activeTab == 'referrals' ? 'show active' : ''; ?>" id="referrals" role="tabpanel" aria-labelledby="referrals-tab">

                        <div class="content" id="events_content">
                            <div class="d-flex" id="add_call_flow_btn">
                                <button type="button" onclick="showRefferalCode()" class="btn btn-block btn-dark" style="margin:1rem 0 1rem 0rem;width:auto;">Refferal Code</button>
                            </div>
                            <div class="card">
                                <div class="card-header">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <h3 class="card-title">Referrals</h3>
                                        <div class="card-tools">
                                            <div class="input-group input-group-sm" style="width: 250px;">
                                                <input type="text" id="searchReferralInput" onkeyup="searchTable('call_events_container', 'searchReferralInput')" class="form-control float-right" placeholder="Search Referrals">
                                                <div class="input-group-append">
                                                    <button type="button" class="btn btn-default">
                                                        <i class="fas fa-search"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="">
                                        <table class="table table-hover table-bordered" id="call_events_table">
                                            <thead style="text-align: center;">
                                                <tr>
                                                    <th>Property Name</th>
                                                    <th>Referred Property</th>
                                                    <th>Referral Code</th>
                                                </tr>
                                            </thead>
                                            <tbody id="call_events_container" style="text-align: center;"></tbody>

                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                </div> -->
                <div class="tab-pane fade <?php echo $activeTab == 'base_cost' ? 'show active' : ''; ?>" id="base_cost" role="tabpanel" aria-labelledby="base_cost-tab">

                        <div class="content">
                            <?php if($user_type == "admin"){ ?>
                                <div class="showHide" id="base_cost_btn">
                                    <button type="button" onclick="showBaseCostForm('base', 'add')" class="btn btn-block btn-dark" style="margin:1rem 0 1rem 0rem;width:auto;">Base Subscription</button>
                                </div>
                            <?php }?>
                            <div class="row g-4" id="base_cost_content_data" style="margin: auto;">
                              <div class="col-md-9">
                                <div class="card cost-card">
                                    <div class="row mt-3">
                                        <?php if($user_type == "admin" || $user_type == "dealer"){ ?>
                                            <div class="col-12 col-sm-6 col-md-4" id="">
                                                <div class="info-box cursor_pointer">
                                                    <span class="info-box-icon bg-info elevation-1"><i class="fa fa-user"></i></span>
                                                    <div class="info-box-content">
                                                        Dealer Price
                                                        <span class="info-box-number">
                                                            <span id="main_sub_fee_add_on"></span>
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>

                                        <?php } ?>
                                        <div class="col-12 col-sm-6 col-md-4" id="">
                                            <div class="info-box cursor_pointer">
                                                <span class="info-box-icon bg-info elevation-1"><i class="fa fa-user"></i></span>
                                                <div class="info-box-content">
                                                    MSRP Price
                                                    <span class="info-box-number">
                                                        <span id="main_msrp_fee"></span>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                  <div class="card-header bg-white border-bottom-0">
                                    <h5 class="card-title">Base Cost</h5>
                                    <span class="fa fa-edit text-primary float-right" style="cursor: pointer;" onclick="showBaseCostForm('base', 'edit')"></span>

                                  </div>
                                  <div class="card-body">
                                    
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="table-responsive">
                                              <table class="table " style="width: 100%;">
                                                <thead>
                                                <tr>
                                                  <th>Product</th>
                                                  <th>Qty</th>
                                                  <th>Unit Price</th>
                                                  <th>MSRP Unit Price</th>
                                                  <th>Total Price</th>
                                                  <th>MSRP Total Price</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td>🔵 Subscription Fee </td>
                                                        <td>1 </td>
                                                        <td><span class="sub_fee_add_on"></span> </td>
                                                        <td><span class="msrp_sub_fee_add_on"></span></td>
                                                        <td><span class="total_dealer_sub_fee"></span> </td>
                                                        <td><span class="total_msrp_sub_fee"></span></td>
                                                        
                                                    </tr>
                                                    <tr>
                                                        
                                                        <td>🔵 Camera Add-On </td>
                                                        <td><span class="total_camera_add_on">0</span></td>
                                                        <td><span class="camera_fee_add_on"></span></td>
                                                        <td><span class="msrp_camera_fee_add_on"></span></td>
                                                        <td><span class="total_dealer_camera_fee_add_on">0</span></td>
                                                        <td><span class="total_msrp_camera_fee_add_on">0</span></td>
                                                        
                                                    </tr>
                                                    <tr>
                                                        <td>🔵 Number Add-On </td>
                                                        <td><span class="total_number_add_on">0</span></td>
                                                        <td> <span class="number_fee_add_on"></span></td>
                                                        <td><span class="msrp_number_fee_add_on"></span></td>
                                                        <td> <span class="total_number_fee_add_on">0</span></td>
                                                        <td><span class="total_msrp_number_fee_add_on">0</span></td>
                                                        
                                                    </tr>
                                                    <tr>
                                                        <td>🔵 Door Add-On </td>
                                                        <td><span class="total_door_add_on">0</span></td> 
                                                        <td><span class="door_fee_add_on"></span></td>
                                                        <td><span class="msrp_door_fee_add_on"></span></td>
                                                        <td><span class="total_dealer_door_fee_add_on">0</span></td>
                                                        <td><span class="total_msrp_door_fee_add_on">0</span></td>
                                                    </tr>
                                                    <tr>
                                                        <td>🔵 User Add-On </td>
                                                        <td><span class="total_users_add_on">0</span></td> 
                                                        <td><span class="users_fee_add_on">$0.05/month</span></td>
                                                        <td><span class="msrp_users_fee_add_on">$0.1/month</span></td>
                                                        <td><span class="total_dealer_users_fee_add_on">0</span></td>
                                                        <td><span class="total_msrp_users_fee_add_on">0</span></td>
                                                    </tr>
                                                    <tr>
                                                        <td>🔵 Cellular SIM Add-On </td>
                                                        <td><span class="total_sim_add_on">0</span></td> 
                                                        <td><span class="sim_fee_add_on">$0/month</span></td>
                                                        <td><span class="msrp_sim_fee_add_on">$0/month</span></td>
                                                        <td><span class="total_dealer_sim_fee_add_on">0</span></td>
                                                        <td>
                                                            <span class="total_msrp_sim_fee_add_on">0</span>
                                                            
                                                            <?php if($user_type == "admin" || $user_type == "super_admin"){ ?>
                                                                <span class="fa fa-edit text-primary float-right" style="cursor: pointer;" onclick="edit_callular_sim()"></span>
                                                            <?php } ?>  
                                                        </td>
                                                    </tr>
                                                </tbody>
                                              </table>
                                          </div>
                                        </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                              <input type="hidden" id="total_callular_sim" value="0">
                              <div class="col-md-3">
                                <div class="card cost-card">
                                  <div class="card-header bg-white border-bottom-0">
                                    <h5 class="card-title">Variable Cost Bank</h5>
                                  </div>
                                  <div class="card-body">
                                    <div class="mb-3 text-center">
                                        Balance &nbsp; <span id="property_remaining_balance" class="cost-value ">0
                                        </span>
                                        
                                    </div>
                                    
                                    <div class="progress mb-2">
                                      <div class="progress-bar" id="waller_progress_bar" role="progressbar"></div>
                                    </div>
                                    <div class="text-center min-balance-text mb-3 minimum_balance_variable_cost">
                                      <br>
                                      Minimum Balance &nbsp; &nbsp; <span id="minimum_balance_variable_cost"> 0 </span>
                                      <span class="float-right">
                                            <span class="fa fa-edit text-primary" style="cursor: pointer;" onclick="showBaseCostForm('balance', 'edit')"></span>
                                        </span>
                                    </div>
                                    <button class="btn btn-primary recharge-btn" onclick="recharge_wallet()">Recharge</button>
                                  </div>
                                </div>
                              </div> 
                            </div>
                        </div>
                </div>

                <div class="tab-pane fade <?php echo $activeTab == 'variable_cost' ? 'show active' : ''; ?>" id="variable_cost" role="tabpanel" aria-labelledby="variable_cost-tab">
                        <div class="container max_w" >
                            <div class="row mt-4">
                              <div class="col-12">
                                <div class="invoice p-3 mb-3" id="payment_page">
                                  <div class="row">
                                    <div class="col-12">
                                      <h4 class="pb-4">
                                        <img src="/include/images/Invisible_Intercom.png" alt="Invisible Logo"  style="height:100%;width:15%;margin-top:1%;">
                                        <p class="float-right "><span class="badge badge-primary" id="payment_date_formatted"><?php echo date('F Y'); ?></span></p>
                                        <input type="hidden" name="payment_date" id="payment_date" value="<?php echo date("Y-m"); ?>">
                                        <input type="hidden" id="current_payment_date" value="<?php echo date("Y-m"); ?>">
                                        <input type="hidden" name="variable_property_name" id="variable_invoice_property_name">

                                      </h4>
                                    </div>
                                  </div>
                                  <div class="row">
                                    <div class="col-12 table-responsive">
                                      <table class="table table-striped">
                                        <thead>
                                        <tr>
                                          <th>Qty</th>
                                          <th>Product</th>
                                          <th>Description</th>
                                          <th>Unit Price</th>
                                          <th>Subtotal</th>
                                        </tr>
                                        </thead>
                                        <tbody id="payment_invoice_tbody_content">
                                        
                                        </tbody>
                                      </table>
                                    </div>
                                  </div>
                                  <div class="row">
                                    <div class="col-6">
                                      
                                    </div>
                                    <div class="col-6">

                                      <div class="table-responsive">
                                        <table class="table">
                                          <tbody><tr>
                                            <th style="width:50%">Subtotal:</th>
                                            <td class="call_message_total"></td>
                                          </tr>
                                          <tr>
                                            <th>Total:</th>
                                            <td class="call_message_total"></td>
                                          </tr>
                                        </tbody></table>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="row no-print">
                                    <div class="col-12">
                                      <button onclick="window.print()" rel="noopener" target="_blank" class="btn btn-success"><i class="fas fa-print"></i> Print</button>
                                        <button id="payment_download" type="button" class="btn btn-primary" style="margin-right: 5px;">
                                        <i class="fas fa-download"></i> Generate PDF
                                        </button>
                                        <button class="btn btn-default float-right" id="call_next_btn" onclick="variable_cost('next')" style="display: none;">Next</button>
                                        <button class="btn btn-default float-right" id="call_previous_btn" onclick="variable_cost('previous')">Previous</button>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                        </div>
                </div>

                <div class="tab-pane fade <?php echo $activeTab == 'payment_history' ? 'show active' : ''; ?>" id="payment_history" role="tabpanel" aria-labelledby="payment_history-tab">
                        <div class="">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">Payment History</h3>
                                    <!-- Search bar -->
                                    <div class="card-tools">
                                        <div class="input-group input-group-sm" style="width: 250px;">
                                            <input type="text" id="searchPaymentShistory" onkeyup="searchTable('payment_history_table', 'searchPaymentShistory')" class="form-control float-right" placeholder="Search Payment">
                                            <div class="input-group-append">
                                                <button type="button" class="btn btn-default">
                                                    <i class="fas fa-search"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="">
                                        <table class="table table-hover table-bordered" id="payment_history_table">
                                            <thead>
                                                <tr>
                                                    <th>Photo</th>
                                                    <th>Amount</th>
                                                    <th>Date</th>
                                                    <?php if($user_type == "admin" || $user_type == "super_admin"){ ?>
                                                        <th>Approved By</th>
                                                    <?php } ?>    
                                                </tr>
                                            </thead>
                                            <tbody id="payment_history_container"></tbody>

                                        </table>
                                    </div>
                                </div>
                            </div>


                        </div>
                </div>

                <div class="tab-pane fade <?php echo $activeTab == 'invoice_history' ? 'show active' : ''; ?>" id="invoice_history" role="tabpanel" aria-labelledby="invoice_history-tab">
                        <div class="">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">Invoice History</h3>
                                    <!-- Search bar -->
                                    <div class="card-tools">
                                        <div class="input-group input-group-sm" style="width: 250px;">
                                            <input type="text" id="searchInvoicehistory" onkeyup="searchTable('invoice_history_table', 'searchInvoicehistory')" class="form-control float-right" placeholder="Search Payment">
                                            <div class="input-group-append">
                                                <button type="button" class="btn btn-default">
                                                    <i class="fas fa-search"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="">
                                        <table class="table table-hover table-bordered" id="invoice_history_table">
                                            <thead>
                                                <tr>
                                                    <th>Date</th>
                                                    <th>Description</th>
                                                    <th></th>
                                                        
                                                </tr>
                                            </thead>
                                            <tbody id="invoice_history_container"></tbody>

                                        </table>
                                    </div>
                                </div>
                            </div>


                        </div>
                </div>
            </div>
        </div>
        <!-- Main Footer -->
        <?php include 'shared/footer.php'; ?>
    </div>
    <!-- /.content -->
    <!-- /.content-wrapper -->

    <!-- Control Sidebar -->
    <aside class="control-sidebar control-sidebar-dark">
        <!-- Control sidebar content goes here -->
        <div class="p-3">
            <h5>Title</h5>
            <p>Sidebar content</p>
        </div>
    </aside>

    <div class="modal fade" id="referral_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">

            <div class="modal-content">
                <div id="error_sms_call_block_message"></div>
                <div class="modal-header">
                    <h5 class="modal-title" id="ref_property_name"></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                
                <div class="modal-body">
                    <div class="form-group">
                        <label>Refferal Code</label>
                        <input type="text" name="code" id="ref_code" class="form-control" readonly="">
                    </div>
                    <div class="form-group">
                        <label>Refferal Link</label>
                        <input type="text" name="refferal_link" class="form-control" id="ref_link" readonly="">
                    </div>
                </div> 
            </div>
        </div>
    </div>

    <div class="modal fade" id="sub_cost_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">

            <div class="modal-content">
                <div id="error_sms_call_block_message"></div>
                <div class="modal-header">
                    <h5 class="modal-title">Base Cost</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                
                <div class="modal-body">
                    <p class="alert alert-danger showHide subscription_error" id="error_sub_message">Subscription not added</p>
                    <div class="row">
                        <?php if($user_type == "admin"){ ?>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Subscription Fee</label>
                                    <input type="number" name="sub_fee" id="sub_fee" class="form-control sub_modal_value">
                                    <p class="badge badge-danger subscription_error showHide" id="sub_fee_error">Please add subscriptin fee</p>
                                </div>
                                
                                <div class="form-group">
                                    <label>Camera Add-On</label>
                                    <input type="number" name="camera_add" class="form-control sub_modal_value" id="camera_add">
                                    <p class="badge badge-danger subscription_error showHide" id="camera_add_error">Please add camera Add-On price</p>
                                </div>
                                <div class="form-group">
                                    <label>Number Add-On</label>
                                    <input type="number" name="number_add" class="form-control sub_modal_value" id="number_add">
                                    <p class="badge badge-danger subscription_error showHide" id="number_add_error">Please add number Add-On price</p>
                                </div>
                                <div class="form-group">
                                    <label>Door Add-On</label>
                                    <input type="number" name="door_add" class="form-control sub_modal_value" id="door_add">
                                    <p class="badge badge-danger subscription_error showHide" id="door_add_error">Please add door Add-On price</p>
                                </div>
                                <div class="form-group">
                                    <label>Cecullar SIM Add-On</label>
                                    <input type="number" name="cellular_sim" class="form-control sub_modal_value" id="cellular_sim_add">
                                    <p class="badge badge-danger subscription_error showHide" id="cellular_sim_add_error">Please add cellular sim Add-On price</p>
                                </div>
                            </div>
                        <?php } ?>
                        <div <?php if($user_type == "admin"){ ?> class="col-md-6" <?php } else{ ?> class="col-md-12" <?php } ?> >
                            <input type="hidden" id="subscription_type" name="subscription_type">
                            <div class="form-group">
                                <label>MSRP Subscription Fee</label>
                                <input type="number" name="msrp_sub_fee" id="msrp_sub_fee" class="form-control msrp_sub_modal_value">
                                <p class="badge badge-danger subscription_error showHide" id="msrp_sub_fee_error">Please add MSRP subscriptin fee</p>
                            </div>
                            <div class="form-group">
                                <label>MSRP Camera Add-On</label>
                                <input type="number" name="msrp_camera_add" class="form-control msrp_sub_modal_value" id="msrp_camera_add">
                                <p class="badge badge-danger subscription_error showHide" id="msrp_camera_add_error">Please add MSRP camera Add-On price</p>
                            </div>
                            <div class="form-group">
                                <label>MSRP Number Add-On</label>
                                <input type="number" name="msrp_number_add" class="form-control msrp_sub_modal_value" id="msrp_number_add">
                                <p class="badge badge-danger subscription_error showHide" id="msrp_number_add_error">Please add MSRP number Add-On price</p>
                            </div>
                            <input type="hidden" name="edited_by" id="edited_by" value="<?php echo $user_type; ?>">
                            <div class="form-group">
                                <label>MSRP Door Add-On</label>
                                <input type="number" name="msrp_door_add" class="form-control msrp_sub_modal_value" id="msrp_door_add">
                                <p class="badge badge-danger subscription_error showHide" id="msrp_door_add_error">Please add MSRP door Add-On price</p>
                            </div>
                            <div class="form-group">
                                <label>MSRP Cecullar SIM Add-On</label>
                                <input type="number" name="msrp_cellular_sim" class="form-control sub_modal_value" id="msrp_cellular_sim_add">
                                <p class="badge badge-danger subscription_error showHide" id="msrp_cellular_sim_add_error">Please add cellular sim Add-On price</p>
                            </div>
                        </div>
                    </div>
                    <input type="hidden" name="sub_added_id" id="sub_added_id">
                    <div class="form-group">
                        <Button type="button" name="save_button" class="btn btn-primary btn-block" onclick="save_subscription('base_cost')">Save</Button>
                    </div>
                </div> 
            </div>
        </div>
    </div>

    <div class="modal fade" id="balance_cost_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">

            <div class="modal-content">
                <div id="error_sms_call_block_message"></div>
                <div class="modal-header">
                    <h5 class="modal-title">Minumum Balance</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="alert alert-danger showHide minmum_balance_error_message" id="minmum_balance_error_message">Something went wrong</p>
                    <div class="form-group">
                        <label>Minimum Balance</label>
                        <input type="number" name="minmum_balance" id="minmum_balance" class="form-control">
                        <p class="badge badge-danger showHide" id="minmum_balance_error">Please add minimum balance</p>
                    </div>
                    
                    <div class="form-group">
                        <Button type="button" name="save_button" class="btn btn-primary btn-block" onclick="save_subscription('balance')">Save</Button>
                    </div>
                </div> 
            </div>
        </div>
    </div>

    <div class="modal fade" id="recharge_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">

            <div class="modal-content">
                <div id="error_sms_call_block_message"></div>
                <div class="modal-header">
                    <h5 class="modal-title">Recharge</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="include/subscription/subscription.php" method="post" enctype="multipart/form-data">
                        <p class="alert alert-danger showHide recharge_balance_error_message" id="recharge_balance_error_message">Something went wrong</p>
                        <input type="hidden" name="recharge_photo">
                        <div class="form-group">

                            <label>Amount</label>
                            <input type="number" name="recharge_amount" id="recharge_amount" class="form-control">
                            <p class="badge badge-danger showHide" id="recharge_amount_message">Please add recharge amount</p>

                        </div>
                        <div class="form-group">
                            <label>Recharge Photo</label>
                            <input type="file" name="recharge_photo" id="recharge_photo" class="form-control">
                            <p class="badge badge-info">Please upload proof of recharge payment photo</p>
                        </div>
                        
                        <div class="form-group">
                            <Button type="button" name="save_button" class="btn btn-primary btn-block" onclick="save_recharge_photo()">Save</Button>
                        </div>
                    </form>
                </div> 
            </div>
        </div>
    </div>

    <div class="modal fade" id="paymentImageModal" tabindex="-1" role="dialog" aria-labelledby="snapImageModalTitle" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" style="width: 600px;height: 650px;" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Payment Image</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body text-center">
                    <img id="paymentImage" src="" alt="Snap" class="img-fluid" style="max-width: 100%; object-fit: contain;">
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="invoice_modal" tabindex="-1" role="dialog" aria-labelledby="snapImageModalTitle" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Invoice</h5>
                    <button type="Button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row mt-4">
                      <div class="col-12">
                        <div class="invoice p-3 mb-3" id="modal_payment_page">
                          <div class="row">
                            <div class="col-12">
                              <h4 class="pb-4">
                                <img src="/include/images/Invisible_Intercom.png" alt="Invisible Logo"  style="height:100%;width:15%;margin-top:1%;">
                                <p class="float-right "><span class="badge badge-primary invoice_date" id="invoice_date"></span></p>
                                <input type="hidden" name="formatted_date" id="invoice_formatted_date" class="invoice_formatted_date">
                                <input type="hidden" name="invoice_property_name" class="invoice_property_name">
                              </h4>
                            </div>
                          </div>
                          <div class="row">
                            <div class="col-12 table-responsive">
                              <table class="table table-striped">
                                <thead>
                                <tr>
                                  <th>Product</th>
                                  <th>QTY</th>
                                  <th>Unit Price</th>
                                  <th>Total Price</th>
                                </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>🔵 Subscription Fee </td>
                                        <td>1 </td>
                                        <td><span class="sub_fee_add_on"></span> </td>
                                        <td><span class="total_dealer_sub_fee"></span> </td>
                                        
                                    </tr>
                                    <tr>
                                        
                                        <td>🔵 Camera Add-On </td>
                                        <td><span class="total_camera_add_on">0</span></td>
                                        <td><span class="camera_fee_add_on"></span></td>
                                        <td><span class="total_dealer_camera_fee_add_on">0</span></td>
                                        
                                        
                                    </tr>
                                    <tr>
                                        <td>🔵 Number Add-On </td>
                                        <td><span class="total_number_add_on">0</span></td>
                                        <td> <span class="number_fee_add_on"></span></td>
                                        <td> <span class="total_number_fee_add_on">0</span></td>
                                        
                                    </tr>
                                    <tr>
                                        <td>🔵 Door Add-On </td>
                                        <td><span class="total_door_add_on">0</span></td> 
                                        <td><span class="door_fee_add_on"></span></td>
                                        <td><span class="total_dealer_door_fee_add_on">0</span></td>
                                        
                                    </tr>
                                    <tr>
                                        <td>🔵 User Add-On </td>
                                        <td><span class="total_users_add_on">0</span></td> 
                                        <td><span class="users_fee_add_on">$0.05/month</span></td>
                                        <td><span class="total_dealer_users_fee_add_on">0</span></td>
                                        
                                    </tr>

                                    <tr>
                                        <td>🔵 Cellular SIM Add-On </td>
                                        <td><span class="total_sim_add_on">0</span></td> 
                                        <td><span class="sim_fee_add_on">$0/month</span></td>
                                        <td><span class="total_dealer_sim_fee_add_on">0</span></td>
                                        
                                    </tr>
                                </tbody>
                              </table>
                            </div>
                          </div>
                          <div class="row">
                            <div class="col-6">
                              
                            </div>
                            <div class="col-6">

                              <div class="table-responsive">
                                <table class="table">
                                  <tbody><tr>
                                    <th style="width:50%">Subtotal:</th>
                                    <td class="modal_dealer_subtotal"></td>
                                  </tr>
                                  <tr>
                                    <th>Total:</th>
                                    <td class="modal_dealer_total"></td>
                                  </tr>
                                </tbody></table>
                              </div>
                            </div>
                          </div>
                          <div class="row no-print">
                            <div class="col-12">
                              <button onclick="window.print()" rel="noopener" target="_blank" class="btn btn-success" id="modal_payment_print"><i class="fas fa-print"></i> Print</button>
                                <button type="button" id="modal_payment_download" class="btn btn-primary " style="margin-right: 5px;" >
                                <i class="fas fa-download"></i> Generate PDF
                                </button>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="callular_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">

            <div class="modal-content">
                <div id="error_sms_call_block_message"></div>
                <div class="modal-header">
                    <h5 class="modal-title">Cellular Sim</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body">
                    <p class="alert alert-danger showHide" id="cellular_sim_qty_error_message">Something went wrong</p>
                    <div class="form-group">
                        <label>Quantity</label>
                        <input type="number" name="cellular_sim_qty" id="cellular_sim_qty" class="form-control">
                        <p class="badge badge-danger showHide" id="cellular_sim_qty_message">Please enter quantity</p>
                    </div>
                    <div class="form-group">
                        <Button type="button" name="save_button" class="btn btn-primary btn-block" onclick="save_cellular_sim_qty()">Save</Button>
                    </div>
                </div> 
            </div>
        </div>
    </div>


    <!-- /.control-sidebar -->

    <!-- ./wrapper -->

    <!-- REQUIRED SCRIPTS -->

    <!-- jQuery -->
    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.bundle.min.js"></script>
    <script src="js/adminlte.min.js"></script>
    <script src="js/events.js"></script>
    <script src="/js/settings/preferences.js"></script>
    <script src="js/dashboard_helper.js"></script>
    <script src="js/sessionRedirection.js"></script>
    <script src="js/dashboard.js"></script>
    <script src="js/select2.full.min.js"></script>
    <script src="js/jsgrid.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
    <script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
    <script>
        document.getElementById('payment_download').addEventListener('click', async () => {
            const { jsPDF } = window.jspdf;
            const doc = new jsPDF();
            
            // Convert the HTML content to canvas using html2canvas
            const content = document.getElementById('payment_page');
            const canvas = await html2canvas(content);

            // Convert canvas to image
            const imgData = canvas.toDataURL('image/png');
            const imgWidth = 190; // Adjust to fit A4
            const pageHeight = 297; // A4 page height in mm
            const imgHeight = (canvas.height * imgWidth) / canvas.width;

            doc.addImage(imgData, 'PNG', 10, 10, imgWidth, imgHeight);
            var property_name = $("#variable_invoice_property_name").val();
            var invoice_m= $("#payment_date_formatted").html();
            doc.save(property_name  + " " + invoice_m + '.pdf');
        });

        document.getElementById('modal_payment_download').addEventListener('click', async () => {
            const { jsPDF } = window.jspdf;
            const doc = new jsPDF();
            $("#modal_payment_download").hide();
            $("#modal_payment_print").hide();
            // Convert the HTML content to canvas using html2canvas
            const content = document.getElementById('modal_payment_page');
            const canvas = await html2canvas(content);

            // Convert canvas to image
            const imgData = canvas.toDataURL('image/png');
            const imgWidth = 190; // Adjust to fit A4
            const pageHeight = 297; // A4 page height in mm
            const imgHeight = (canvas.height * imgWidth) / canvas.width;

            doc.addImage(imgData, 'PNG', 10, 10, imgWidth, imgHeight);
            var property_name = $(".invoice_property_name").val();
            var invoice_m = $(".invoice_formatted_date").val();
            doc.save(property_name  + " " + invoice_m + '.pdf');
            $("#modal_payment_print").show();
            $("#modal_payment_download").show();
        });
    </script>
</body>

</html>
<?php ob_end_flush(); ?>