<?php

require_once('functionsinc.php');

try {
    $data = getMenuByUser($pdo, $_SESSION['userid']);
    $tree = [];
    foreach ($data as $item) {
        if ($item['parentId'] === NULL) {
            $tree[$item['id']] = $item;
        } else {
            if (!$item['isChild']) {
                $item['hasChildren'] = "true";
                $tree[$item['id']] = $item;
            } else {
                foreach ($data as $item2) {
                    if ($item2['parentId'] == $item['parentId'] && $item['isChild'] === 'true') {
                        $tree[$item2['id']]['children'][] = $item;
                        break;
                    }
                }
            }
        }
    }
} catch (\Throwable $th) {
    // throw $th;
}

function generateMenu($items)
{
    // Apply sorting
    usort($items, function ($a, $b) {
        return $a['display_order'] <=> $b['display_order'];
    });

    $html = '';
    foreach ($items as $item) {
        $hasChildren = !empty($item['children']);
        if ($hasChildren && empty($item['children'])) {
            continue;
        }
        $html .= '<li class="nav-item">';
        $html .= '<a href="' . htmlspecialchars($item['slug'], ENT_QUOTES, 'UTF-8') . '" class="nav-link" data-page="' . htmlspecialchars($item['dataPage'], ENT_QUOTES, 'UTF-8') . '">';
        $html .= '<i class="' . htmlspecialchars($item['icon'], ENT_QUOTES, 'UTF-8') . '"></i>';
        $html .= '<p class="pl-1">' . htmlspecialchars($item['label'], ENT_QUOTES, 'UTF-8');
        if ($hasChildren) {
            $html .= '<i class="right fas fa-angle-left"></i>';
        }
        $html .= '</p>';
        $html .= '</a>';
        if ($hasChildren) {
            $html .= '<ul class="nav nav-treeview">';
            // Recursively generate the menu for children
            $html .= generateMenu($item['children']);
            $html .= '</ul>';
        }
        $html .= '</li>';
    }
    return $html;
}

$propLink=null;
if ($_SESSION['property'] === null && ($_SESSION['layer'] === 'super_admin' || $_SESSION['layer'] === 'admin' || $_SESSION['layer'] === 'dealer')) {

    $imagePath = 'include/images/no-image.png';
}else {
    $imagePath = '';

    $currentPropertyId = $_SESSION['property'];
    $propName = '';

    $imagePath = "/shared/serve_image.php?path=" . getPropertyImage($currentPropertyId) . "&type=property";
    $propLink = getPropertyLink($currentPropertyId);

}


if (isset($_SESSION['properties'])) {
    foreach ($_SESSION['properties'] as $property) {
        if ($property['id'] == $currentPropertyId) {

            $propName = $property['name'];
            break;
        }
    }
}else if ($imagePath !== 'include/images/no-image.png') {
    $getPropDetails = getProperty($_SESSION['userid'], $_SESSION['layer']);
    $propertyId = $_SESSION['property'];

    $propName = '';

    foreach ($getPropDetails as $property) {
        if ($property['id'] == $propertyId) {
            $propName = $property['name'];
            break;
        }
    }

} else {
    $propName = 'Please Select A Property!';
}

?>
<style>
    .showHide{
        display: none;
    }
</style>
<!-- Brand Logo -->
<a href="">
    <img src="/include/images/Invisible_Intercom.png" alt="Invisible Logo" class="light_logo brand-image" style="height:100%;width:100%;margin-top:1%;margin-left:auto;margin-right:auto;">
    <img src="/include/images/invisible-intercom-white.png" alt="Invisible Logo" class="dark_logo showHide brand-image" style="height:100%;width:100%;margin-top:1%;margin-left:8px;margin-right:auto;">
</a>

<!-- Sidebar -->
<div class="sidebar">
    <hr />

    <!-- Sidebar Menu -->
    <nav class="mt-2">

        <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
            <?php echo generateMenu($tree); ?>
        </ul>
    </nav>

    <hr />
    <div class="sidebar-footer mt-3">
        <label id='propImageName' style='text-align:center;width:100%;'><?php echo $propName; $propLink; ?></label>
        <?php if($propLink): ?>
            <a href="<?php echo $propLink; ?>" target="_blank">
                <img src="<?php echo $imagePath; ?>" alt="Property Image" id='propImageSB' class="img-fluid" style="width: 100%; max-height: 200px; object-fit: cover;">
            </a>
        <?php else: ?>
            <img src="<?php echo $imagePath; ?>" alt="Property Image" id='propImageSB' class="img-fluid" style="width: 100%; max-height: 200px; object-fit: cover;">    
        <?php endif; ?>
    </div>

    <!-- <div class="sidebar-footer mt-3">
        <label>Property</label>
        <select id="selectproperty" class="form-control" name="selectProperty" required></select>
    </div>
        <select id="selectproperty" class="form-control" name ="selectProperty" required></select>
    </div> -->

    <!-- /.sidebar-menu -->
</div>
<!-- /.sidebar -->