<?php
    require realpath(dirname(__FILE__) . '/../include/helper_functions/data_request.php');

    $imageName  = isset($_GET['image_name']) ? basename($_GET['image_name']) : null;
    $propertyId = isset($_GET['property_id']) ? intval($_GET['property_id']) : null;

    if (!$imageName || !$propertyId) {
        header("HTTP/1.1 400 Bad Request");
        exit("Missing parameters");
    }

    $result = getSnapshotImage($propertyId, $imageName);
    if (!$result['success'] || empty($result['image'])) {
        header("HTTP/1.1 404 Not Found");
        exit("Image not found");
    }

    $imageContent = $result['image'];

    $finfo = finfo_open();
    $mimeType = finfo_buffer($finfo, $imageContent, FILEINFO_MIME_TYPE);
    finfo_close($finfo);

    header("Content-Type: $mimeType");
    header("Content-Length: " . strlen($imageContent));
    header("Cache-Control: public, max-age=86400");

    echo $imageContent;
    exit;
?>
