<?php
    require_once('call_flow_functions.php');
    header('Content-Type: application/xml; charset=UTF-8');
    $message_url = "/shared/serve_audios.php?path=";
    $conference_sid = htmlspecialchars($_REQUEST['ConferenceSid'] ?? '', ENT_QUOTES, 'UTF-8');
    $call_id = isset($_REQUEST['call_id']) ? (int)$_REQUEST['call_id'] : 0;
    $eventType = htmlspecialchars($_POST['StatusCallbackEvent'] ?? '', ENT_QUOTES, 'UTF-8');
    $call_history = fetch_table_data('call_histories', 'id', $call_id);
    $base_url = base_url();
    $call_sid = htmlspecialchars($call_history['call_sid'] ?? '', ENT_QUOTES, 'UTF-8');
    update_call_status($call_sid, 'is_digit_press', 1);
    echo '<?xml version="1.0" encoding="UTF-8"?>';
    if(isset($call_history['id'])){
        update_call($call_id, 'conference_sid', $conference_sid);
        $count_participants = $call_history['count_participants'];
        if(($eventType === "participant-join") && ($count_participants == 1)){
            $from = format_number($call_history['to_number']);
            $conference_name = "MyConference_" . $call_id;
            $url = $base_url . "/signalwire_call/new_person_connect.php?call_id=". urlencode($call_id);
            $callback = $base_url . "/signalwire_call/check_active.php?call_id=". urlencode($call_id);
            $first_user_number = get_number_disturb($call_history['to_number'], 1, $call_id, "first_number");
            $second_user_number = get_number_disturb($call_history['to_number'], 2, $call_id, "second_number");
            $third_user_number = get_number_disturb($call_history['to_number'], 3, $call_id, "third_number");
            
            if(!empty($first_user_number)){
                $number = 1;
                $owner_number = format_number($first_user_number);
                update_call($call_id, 'count_caller_number', 1);
                $get_call_status = get_call_status($from, $owner_number, $call_id, $url, $callback, $call_sid);
                if($get_call_status == "failed" || $get_call_status == "busy" || $get_call_status == "no-answer"){
                    if(!empty($second_user_number)){
                        $owner_number = format_number($second_user_number);
                        update_call($call_id, 'count_caller_number', 2);
                        $get_call_status = get_call_status($from, $owner_number, $call_id, $url, $callback, $call_sid);
                        if($get_call_status == "failed" || $get_call_status == "busy" || $get_call_status == "no-answer"){
                            if(!empty($third_user_number)){
                                $owner_number = format_number($third_user_number);
                                update_call($call_id, 'count_caller_number', 3);
                                $get_call_status = get_call_status($from, $owner_number, $call_id, $url, $callback, $call_sid);
                                if($get_call_status == "failed" || $get_call_status == "busy" || $get_call_status == "no-answer"){
                                    $sps = $call_history['call_sid'];
                                    $cnf_sid = $call_history['conference_sid'];
                                    $url = $base_url . "/signalwire_call/no_one_available.php?call_id=". urlencode($call_id);
                                    call_socket_url($sps, $url, $call_history['to_number']);
                                }
                            }
                            else{
                                $sps = $call_history['call_sid'];
                                $cnf_sid = $call_history['conference_sid'];
                                $url = $base_url . "/signalwire_call/no_one_available.php?call_id=". urlencode($call_id);
                                call_socket_url($sps, $url, $call_history['to_number']);
                            }
                        }
                    }
                    else if(!empty($third_user_number)){
                        $owner_number = format_number($third_user_number);
                        update_call($call_id, 'count_caller_number', 3);
                        $get_call_status = get_call_status($from, $owner_number, $call_id, $url, $callback, $call_sid);
                        if($get_call_status == "failed" || $get_call_status == "busy" || $get_call_status == "no-answer"){
                            $sps = $call_history['call_sid'];
                            $cnf_sid = $call_history['conference_sid'];
                            $url = $base_url . "/signalwire_call/no_one_available.php?call_id=". urlencode($call_id);
                            call_socket_url($sps, $url, $call_history['to_number']);
                        }
                    }
                    else{
                        $sps = $call_history['call_sid'];
                        $cnf_sid = $call_history['conference_sid'];
                        $url = $base_url . "/signalwire_call/no_one_available.php?call_id=". urlencode($call_id);
                        call_socket_url($sps, $url, $call_history['to_number']);    
                    }
                }
            }
            else if(!empty($second_user_number)){
                $owner_number = format_number($second_user_number);
                update_call($call_id, 'count_caller_number', 2);
                $get_call_status = get_call_status($from, $owner_number, $call_id, $url, $callback, $call_sid);
                if($get_call_status == "failed" || $get_call_status == "busy" || $get_call_status == "no-answer"){
                    if(!empty($third_user_number)){
                        $owner_number = format_number($third_user_number);
                        update_call($call_id, 'count_caller_number', 3);
                        $get_call_status = get_call_status($from, $owner_number, $call_id, $url, $callback, $call_sid);
                        if($get_call_status == "failed" || $get_call_status == "busy" || $get_call_status == "no-answer"){
                            $sps = $call_history['call_sid'];
                            $cnf_sid = $call_history['conference_sid'];
                            $url = $base_url . "/signalwire_call/no_one_available.php?call_id=". urlencode($call_id);
                            call_socket_url($sps, $url, $call_history['to_number']);
                        }
                    }
                    else{
                        $sps = $call_history['call_sid'];
                        $cnf_sid = $call_history['conference_sid'];
                        $url = $base_url . "/signalwire_call/no_one_available.php?call_id=". urlencode($call_id);
                        call_socket_url($sps, $url, $call_history['to_number']);
                    }
                }
            }
            else if(!empty($third_user_number)){
                $owner_number = format_number($third_user_number);
                update_call($call_id, 'count_caller_number', 3);
                $get_call_status = get_call_status($from, $owner_number, $call_id, $url, $callback, $call_sid);
                if($get_call_status == "failed" || $get_call_status == "busy" || $get_call_status == "no-answer"){
                    $sps = $call_history['call_sid'];
                    $cnf_sid = $call_history['conference_sid'];
                    $url = $base_url . "/signalwire_call/no_one_available.php?call_id=". urlencode($call_id);
                    call_socket_url($sps, $url, $call_history['to_number']);
                }
            }   
        }
        else if(($eventType === "participant-join") && ($count_participants == 2)){
            update_call($call_id, 'count_participants', 3);
            $from_number = $call_history['to_number'];
            
            stream_conference($call_history['conference_sid'], $call_id, $from_number);
        }
        else if(($eventType === "participant-join") && ($count_participants == 4)){
            update_call($call_id, 'again_join', 1);
            if($call_history['stream_digit'] == 1){
                update_call($call_id, 'stream_digit', 0);
                update_call($call_id, 'is_access_granted', 1);
                $from_number = $call_history['to_number'];
                $message_say = $base_url . "/signalwire_call/message_say.php?call_id=". urlencode($call_id);
                second_person_play($conference_sid, $message_say, $from_number);
            }
        }
        if($eventType === "participant-leave"){
            update_call($call_id, 'again_join', 0);
            $status = check_call_status($call_history['to_number'], $call_history['second_person_call_sid']);
            if($status == "completed"){
                $sps = $call_history['call_sid'];
                $cnf_sid = $call_history['conference_sid'];
                $url = $base_url . "/signalwire_call/conference_action.php?call_id=". urlencode($call_id);
                call_socket_url($sps, $url, $call_history['to_number']);
            }
            else{
                check_user_call_status($call_history);
            }
        }
    }

?>