<?php
	require_once('call_flow_functions.php');
    header('Content-Type: application/xml; charset=UTF-8');
    $message_url = "/shared/serve_audios.php?path=";

	// Sanitize the call_id from request input
	$call_sid = $_POST['CallSid'];
	$call_id = htmlspecialchars($_REQUEST['SipHeader_X-call_id'] ?? '', ENT_QUOTES, 'UTF-8');
	$call_data = get_call_data($call_id);
	
	// Sanitize the stream_url from the call data
	$stream_url = htmlspecialchars($call_data['socket_response_url'] ?? '', ENT_QUOTES, 'UTF-8');
	update_call($call_id, 'first_sip_sid', $call_sid);
	// Check if the stream URL is not empty
	if (!empty($stream_url)) {
		header('Content-Type: text/xml');
		echo '<?xml version="1.0" encoding="UTF-8"?>';
		
		// Output the sanitized XML response
		echo "<Response>
				<Connect> 
	                    <Stream url='" . $stream_url . "'/> 
	                </Connect>
		      </Response>";
	}
?>
