<?php
    require_once('call_flow_functions.php');
    header('Content-Type: application/xml; charset=UTF-8');
    echo '<?xml version="1.0" encoding="UTF-8"?>';

    $message_url = "/shared/serve_audios.php?path=";
    $call_sid = htmlspecialchars($_POST['CallSid'] ?? '', ENT_QUOTES, 'UTF-8');
    $call_status = htmlspecialchars($_POST['CallStatus'] ?? '', ENT_QUOTES, 'UTF-8');

    $from_number = htmlspecialchars(format_number($_REQUEST['From'] ?? ''), ENT_QUOTES, 'UTF-8');
    $to_number = htmlspecialchars(format_number($_REQUEST['To'] ?? ''), ENT_QUOTES, 'UTF-8');

    $call_flow = get_call_flow($to_number);
    $call_data = fetchDataSingle('call_histories', ['call_sid' => $call_sid]);

    $base_url = htmlspecialchars(base_url(), ENT_QUOTES, 'UTF-8');
    $press2_ack = "";
    $try_again = 1;
    $digit_type = 1;
    update_call_status($call_sid, 'is_digit_press', 1);

    if ((isset($_REQUEST['check_code']) && $_REQUEST['check_code'] == 1) || isset($_REQUEST['caller_id']) || (isset($_REQUEST['caller_code']) && $_REQUEST['caller_code'] == 1)) {
        $digit = htmlspecialchars($_REQUEST['Digits'] ?? '', ENT_QUOTES, 'UTF-8');
        $press2_hold = defalt_voice_message("please_hold.wav");

        if (isset($_REQUEST['check_code'])) {
            $check_digit = check_digit($call_data['id'], "key_code", $to_number, $call_data['property_id'], $digit);
            if (($check_digit == 0) && ($call_data['try_again_code'] == 0)) {
                update_call($call_data['id'], 'try_again_code', '1');
                $try_again = 0;
                $digit_type = 1;
            }
        } elseif (isset($_REQUEST['caller_code'])) {
            $check_digit = check_caller_digit("CallerID+Code", $from_number, $call_data['property_id'], $digit);
            if (($check_digit == 0) && ($call_data['try_again_code'] == 0)) {
                update_call($call_data['id'], 'try_again_code', '1');
                $try_again = 0;
                $digit_type = 2;
            }
        }

        $call_id = $call_data['id'];
        update_call($call_id, 'is_authorized_code_use', 1);

        if (isset($call_flow['id'])) {
            if ($call_flow['press2_auth_code_default_message'] == 0) {
                if ($call_flow['press2_auth_code_textto_speech'] == 0) {
                    $press2_hold_message = $message_url . rawurlencode($call_flow['press2_auth_code_audio_file']);
                    $press2_hold = "<Play>$press2_hold_message</Play>";
                } else {
                    $text = htmlspecialchars($call_flow['press2_auth_code_text'], ENT_QUOTES, 'UTF-8');
                    $voice = htmlspecialchars($call_flow['press2_auth_vocie_select'], ENT_QUOTES, 'UTF-8');
                    $press2_hold = "<Say voice='$voice'>$text</Say>";
                }
            }
        }

        if (isset($_REQUEST['caller_id'])) {
            $check_digit = htmlspecialchars($_REQUEST['caller_id'], ENT_QUOTES, 'UTF-8');
            $press2_hold = "";
        }

        if ($check_digit != 0) {
            $press2_ack = defalt_voice_message("open_command_sent.wav");

            if (isset($call_flow['id']) && $call_flow['press2_auth_code_ack_default_message'] == 0) {
                if ($call_flow['press2_auth_code_ack_textto_speech'] == 0) {
                    $press2_ack_message = $message_url . rawurlencode($call_flow['press2_auth_code_ack_audio_file']);
                    $press2_ack = "<Play>$press2_ack_message</Play>";
                } else {
                    $ack_text = htmlspecialchars($call_flow['press2_auth_code_ack_text'], ENT_QUOTES, 'UTF-8');
                    $ack_voice = htmlspecialchars($call_flow['press2_auth_ack_vocie_select'], ENT_QUOTES, 'UTF-8');
                    $press2_ack = "<Say voice='$ack_voice'>$ack_text</Say>";
                }
            }

            // Line 80 (was): echo with unsanitized value
            echo "<Response>
                    $press2_hold
                    $press2_ack
                    <Redirect>access_gate.php?digit=$check_digit</Redirect>
                  </Response>";
        } else {
            if ($try_again == 0) {
                // Line 89/95
                if ($digit_type == 1) {
                    echo "<Response>
                            $press2_hold
                            <Redirect>try_again_code.php?Digits=2</Redirect>
                          </Response>";
                } else {
                    echo "<Response>
                            $press2_hold
                            <Redirect>try_again_code.php?call_pin=2</Redirect>
                          </Response>";
                }
            } else {
                $access_denied = defalt_voice_message("access_denied.wav");

                // Line 103
                echo "<Response>
                        $press2_hold
                        $access_denied
                        <Redirect>access_gate.php?message_denied=1</Redirect>
                      </Response>";
            }
        }
    }
?>
