<?php
    require_once('call_flow_functions.php');
    header('Content-Type: application/xml; charset=UTF-8');
    echo '<?xml version="1.0" encoding="UTF-8"?>';

    $message_url = "/shared/serve_audios.php?path=";

    $call_sid = htmlspecialchars($_REQUEST['CallSid'] ?? '', ENT_QUOTES, 'UTF-8');
    $from_number_raw = $_REQUEST['From'] ?? '';
    $to_number_raw = $_REQUEST['To'] ?? '';
    $call_status = htmlspecialchars($_REQUEST['CallStatus'] ?? '', ENT_QUOTES, 'UTF-8');

    $from_number = htmlspecialchars(format_number($from_number_raw), ENT_QUOTES, 'UTF-8');
    $to_number = htmlspecialchars(format_number($to_number_raw), ENT_QUOTES, 'UTF-8');
    $base_url = htmlspecialchars(base_url(), ENT_QUOTES, 'UTF-8');

    $check_block = check_block_number($from_number, $to_number);

    if ($check_block == 0) {
        $dial_call = save_call($call_sid, $from_number, $to_number, $call_status);
        $call_flow = get_call_flow($to_number);

        $message = defalt_voice_message("Welcome-to-Our-Home.wav");
        $is_set_call_flow = 0;

        if (isset($call_flow['id'])) {
            $call_data = fetchDataSingle('call_histories', ['call_sid' => $call_sid]);
            $call_id = htmlspecialchars($call_data['id'] ?? '', ENT_QUOTES, 'UTF-8');
            $property_id = htmlspecialchars($call_data['property_id'] ?? '', ENT_QUOTES, 'UTF-8');

            $check_caller_id = check_digit($call_id, "CallerID", $to_number, $property_id, $from_number);
            if ($check_caller_id == 1) {
                echo "<Response>
                        <Redirect>handle_data.php?caller_id=1</Redirect>
                      </Response>";
            } else {
                $check_caller_id = check_digit($call_id, "CallerID+Code", $to_number, $property_id, $from_number);

                if ($check_caller_id == 0) {
                    $is_set_call_flow = 1;

                    if ($call_flow['is_first_default_message'] == 0) {
                        $check_welcome_message = $call_flow['is_first_textto_speech'];

                        if ($check_welcome_message == 0) {
                            $welcome_message = $message_url . rawurlencode($call_flow['first_audio_file']);
                            $message = "<Play>$welcome_message</Play>";
                        } else {
                            $welcome_text = htmlspecialchars($call_flow['first_text'], ENT_QUOTES, 'UTF-8');
                            $voice = htmlspecialchars($call_flow['first_message_vocie_select'], ENT_QUOTES, 'UTF-8');
                            $message = "<Say voice='$voice'>$welcome_text</Say>";
                        }
                    }

                    echo "<Response>
                            <Gather input='dtmf' action='inbound_handle.php' method='POST' timeout='10' numDigits='1'>
                                $message
                            </Gather>
                            <Redirect>no_response.php</Redirect>
                          </Response>";
                } elseif ($check_caller_id == 1) {
                    echo "<Response>
                            <Redirect>inbound_handle.php?call_pin=2</Redirect>
                          </Response>";
                }
            }
        } else {
            echo "<Response>
                    <Redirect>inbound_handle.php?Digits=2</Redirect>
                  </Response>";
        }
    } else {
        echo "<Response><Hangup/></Response>";
    }
?>
