<?php
    require_once('call_flow_functions.php');
    header('Content-Type: application/xml; charset=UTF-8');
    $message_url = "/shared/serve_audios.php?path=";
    $call_id = isset($_REQUEST['call_id']) ? (int)$_REQUEST['call_id'] : 0;
    
    $call_history = fetch_table_data('call_histories', 'id', $call_id);
    $from_number = format_number($call_history['from_number']);
    $to_number = format_number($call_history['to_number']);
    $call_flow = get_call_flow($to_number);
    $base_url = base_url();
    $cnam = $call_history['cnam'];
    
    // Sanitize the file names before using them in URLs
    $open_command = defalt_voice_message("open_command_sent.wav");
    $access_message = defalt_voice_message("You-may-now-access-th-property.wav");
    
    $door_key = $call_history['pressed_digit'];
    if($call_history['door_id'] != 0){
        $get_door = fetchDataSingle('gate_doors', ['id' => $call_history['door_id']]);
    }
    else{
        $get_door = get_door($to_number);
    }
    $request_open_door = request_open_door($call_id, "1", $get_door, $door_key, $call_history['to_number'], "door_key");
    $response_result = json_decode($request_open_door, true);
    
    if(isset($call_flow['id'])){
   
        if($call_flow['is_beep_default_message'] == 0){

            $open_command_message = $call_flow['is_beep_textto_speech'];
            if($open_command_message == 0){
                $open_command_url = $message_url . $call_flow['beep_audio_file'];
                $open_command_url = urlencode($open_command_url);
                $open_command = "<Play>" . htmlspecialchars($open_command_url, ENT_QUOTES, 'UTF-8') . "</Play>";
            }
            else{
                $open_command_url = htmlspecialchars($call_flow['beep_text'], ENT_QUOTES, 'UTF-8');
                $is_beep_vocie_select = htmlspecialchars($call_flow['is_beep_vocie_select'], ENT_QUOTES, 'UTF-8');
                $open_command = "<Say voice='" . $is_beep_vocie_select . "'>" . $open_command_url . "</Say>";   
            }
        }

        if($call_flow['is_access_default_message'] == 0){
            $check_access_message = $call_flow['is_access_textto_speech'];
            if($check_access_message == 0){
                $access_message_url = $message_url . $call_flow['access_audio_file'];
                $access_message_url = urlencode($access_message_url);
                $access_message = "<Play>" . htmlspecialchars($access_message_url, ENT_QUOTES, 'UTF-8') . "</Play>";
            }
            else{
                $access_message_url = htmlspecialchars($call_flow['access_text'], ENT_QUOTES, 'UTF-8');
                $is_access_vocie_select = htmlspecialchars($call_flow['is_access_vocie_select'], ENT_QUOTES, 'UTF-8');
                $access_message = "<Say voice='" . $is_access_vocie_select . "'>" . $access_message_url . "</Say>";   
            }
        }

        if($call_flow['is_grant_access_detail_message'] == 1){
            $door_name = htmlspecialchars($get_door['door_name'], ENT_QUOTES, 'UTF-8');
            $body = "ii user authorized access to " . $cnam . " " . $from_number . " at " . $door_name;
            send_sms_to_owner($call_id, $to_number, $from_number, $body);
        }
        
    }

    echo '<?xml version="1.0" encoding="UTF-8"?>';
    if($response_result['success'] == true){
        echo "<Response>
                    $open_command
                    $access_message
                    <Redirect>check_active.php?call_id=" . urlencode($call_id) . "</Redirect>
            </Response>";
    }
    else{
        $data = htmlspecialchars($response_result['data'], ENT_QUOTES, 'UTF-8');
        $access_message = "<Say>$data</Say>";
        echo "<Response>
                    $open_command
                    $access_message
                    <Redirect>check_active.php?call_id=" . urlencode($call_id) . "</Redirect>
            </Response>";   
    }
?>
