<?php
    require_once('call_flow_functions.php');
    header('Content-Type: application/xml; charset=UTF-8');
    $message_url = "/shared/serve_audios.php?path=";
    $call_id = isset($_REQUEST['call_id']) ? (int)$_REQUEST['call_id'] : 0;


    $call_history = fetch_table_data('call_histories', 'id', $call_id);
    $from_number = format_number($call_history['from_number']);
    $to_number = format_number($call_history['to_number']);
    $call_flow = get_call_flow($to_number);
    $base_url = base_url();

    $no_one_available = defalt_voice_message("no_one_available.wav");

    if (isset($call_flow['id'])) {
        if ($call_flow['is_connected_no_answer_default_message'] == 0) {
            $check_available_message = $call_flow['is_connected_no_answer_textto_speech'];
            if ($check_available_message == 0) {
                // Audio file response
                $audio_file = $call_flow['connected_no_answer_audio_file'];
                $available_message_url = $message_url . urlencode($audio_file);
                $no_one_available = "<Play>$available_message_url</Play>";
            } else {
                // Text-to-speech response with sanitization to prevent XSS
                $text = htmlspecialchars($call_flow['connected_no_answer_text'], ENT_QUOTES, 'UTF-8');
                $voice = htmlspecialchars($call_flow['connected_no_answer_vocie_select'], ENT_QUOTES, 'UTF-8');
                $no_one_available = "<Say voice='$voice'>$text</Say>";
            }
        }
    }

    echo '<?xml version="1.0" encoding="UTF-8"?>';
    echo "<Response>
                $no_one_available
          </Response>";
?>
