<?php 
    require_once('call_flow_functions.php');    

    $message_url = "/shared/serve_audios.php?path=";
    $from_number = format_number($_REQUEST['From'] ?? '');
    $to_number = format_number($_REQUEST['To'] ?? '');

    $call_flow = get_call_flow($to_number);
    $base_url = base_url();

    $default_audio_path = $base_url . "/audio_messages/good_bye.wav";
    $safe_default_audio = htmlspecialchars($default_audio_path, ENT_QUOTES | ENT_XML1, 'UTF-8');
    $goodbye_message = "<Play>$safe_default_audio</Play>";
    if (isset($call_flow['id'])) {
        if ($call_flow['is_no_response_default_message'] == 0) {
            $no_response_message_check = $call_flow['is_no_response_textto_speech'];

            if ($no_response_message_check == 0) {
                // Sanitize file name
                $file = basename($call_flow['no_response_audio_file']);
                $no_response_message = $message_url . rawurlencode($file);
                $safe_audio_url = htmlspecialchars($no_response_message, ENT_QUOTES | ENT_XML1, 'UTF-8');
                $goodbye_message = "<Play>$safe_audio_url</Play>";
            } else {
                // Sanitize text and voice name
                $no_response_text = htmlspecialchars($call_flow['no_response_text'], ENT_QUOTES | ENT_XML1, 'UTF-8');
                $voice = htmlspecialchars($call_flow['no_response_vocie_select'], ENT_QUOTES | ENT_XML1, 'UTF-8');
                $goodbye_message = "<Say voice='$voice'>$no_response_text</Say>";
            }
        }
    }

    header('Content-Type: text/xml');
    echo '<?xml version="1.0" encoding="UTF-8"?>';
    echo "<Response>";
    echo $goodbye_message;
    echo "</Response>";
?>
