<?php
session_start();

require '../../db.php';
require '../auth/auth_functions.php';
include '../helper_functions/data_request.php';

if (!currentUserHasAccess($pdo, 'admin_panel', 'write')) {
    if (isset($_SESSION['userid'])) {
        echo "Access denied! Please wait while being Re-Directed.";
        if (!headers_sent()) {
            header( "refresh:5;url=../../dashboard.php" );
        }
        exit();
    }else {
        if (!headers_sent()) {
            header("Location: ../../login.php");
        }
        exit();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin - Manage Attributes, Resources, and ACLs</title>
</head>
<body>
    <h1>Manage Roles, Actions, Resources, and Role Resources</h1>

    <a href="../../dashboard.php">Return to Dashboard</a>

    <h2>Hardware setup</h2>
    <form action="../hardware/hardware.php" method="POST">
        <input type="hidden" name="action" value="create_hardware">
        <label for="hardware_name">Hardware Name:</label>
        <input type="text" name="hardware_name" id="hardware_name" required>
        <br><br>
        <label for="hardware_config">Hardware Config:</label>
        <textarea name="hardware_config" id="hardware_config" class="form-control" rows="10" required></textarea>
        <br><br>
        <button type="submit">Create New Hardware</button>
    </form>

    <!-- Form to create a new role -->
    <h2>Create Role</h2>
    <form action="include/admin/admin.php" method="POST">
        <input type="hidden" name="action" value="create_role">
        <label for="role_name">Role Name:</label>
        <input type="text" name="role_name" id="role_name" required>
        <button type="submit">Create Role</button>
    </form>

    <!-- Form to create a new resource -->
    <h2>Create Resource</h2>
    <form action="include/admin/admin.php" method="POST">
        <input type="hidden" name="action" value="create_resource">
        <label for="resource_name">Resource Name:</label>
        <input type="text" name="resource_name" id="resource_name" required>
        <button type="submit">Create Resource</button>
    </form>

    <!-- Form to create a new role resources entry -->
    <h2>Create Role Resource Entry</h2>
    <form action="include/admin/admin.php" method="POST">
        <input type="hidden" name="action" value="create_role_resource">
        <label for="role_id">Role ID:</label>
        <input type="number" name="role_id" id="role_id" required>
        <label for="value">Resource ID:</label>
        <input type="text" name="resource_id" id="resource_id" required>
        <label for="action_id">Action ID:</label>
        <input type="number" name="action_id" id="action_id" required>
        <button type="submit">Create ACL Entry</button>
    </form>

    <?php
        $signawire_setting = fetchData('signalwire_settings');
        $project_id = "";
        $space_url = "";
        $api_token = "";
        $signawire_setting_id = "";
        $dealer_purchase_number_limit = "";
        if(!empty($signawire_setting)){
            $project_id = $signawire_setting[0]['project_id'];
            $space_url = $signawire_setting[0]['space_url'];
            $api_token = $signawire_setting[0]['api_token'];
            $signawire_setting_id = $signawire_setting[0]['id'];
            $dealer_purchase_number_limit = $signawire_setting[0]['dealer_purchase_number_limit'];
            
        }

        $stream_data = fetchDataSingle('stream_url');
        $url_id = "";
        $stream_url = "";
        if(isset($stream_data['id']) && !empty($stream_data)){
            $url_id = $stream_data['id'];
            $stream_url = $stream_data['stream_url'];
        }

    ?>
    <!-- <h2>SignalWire Setting</h2>
    <form action="admin.php" method="POST">
        <input type="hidden" name="action" value="signalwire_setting">
        <input type="hidden" name="user_id" value="<?php echo $_SESSION['userid'] ?>">
        <input type="hidden" name="signawire_setting_id" value="<?php echo $signawire_setting_id ?>">
        <label for="project_id">Project ID</label>
        <input type="text" name="project_id" id="project_id" value="<?php echo $project_id ?>" required>
        <label for="space_url">Space Url:</label>
        <input type="text" name="space_url" id="space_url" value="<?php echo $space_url ?>" required>
        <label for="api_token">API Token:</label>
        <input type="text" name="api_token" id="api_token" value="<?php echo $api_token ?>" required>
        <label for="dealer_limit">Dealer Buy Number Limit: </label>
        <input type="number" name="dealer_purchase_number_limit" id="dealer_purchase_number_limit" value="<?php echo $dealer_purchase_number_limit ?>" required>
        <button type="submit">Update</button>
    </form> -->

    <h2>Server NodeJS URL</h2>
    <form action="admin.php" method="POST">
        <input type="hidden" name="action" value="stream_url">
        <input type="hidden" name="user_id" value="<?php echo $_SESSION['userid'] ?>">
        <input type="hidden" name="url_id" value="<?php echo $url_id ?>">
        <label for="url">URL</label>
        <input type="text" name="stream_url" id="stream_url" value="<?php echo $stream_url ?>" required>
        <button type="submit">Update</button>
    </form>

    <h2>Add FTP Server URL</h2>
    <form action="admin.php" method="POST">
        <input type="hidden" name="action" value="ftp_url">
        <input type="hidden" name="user_id" value="<?php echo $_SESSION['userid'] ?>">
        <label for="url">Label</label>
        <input type="text" name="ftp_label" id="ftp_label" value="" required>
        <label for="url">URL</label>
        <input type="text" name="ftp_url" id="ftp_url" value="" required>
        <label for="url">Port</label>
        <input type="number" name="ftp_port" id="ftp_port" value="" required>
        <button type="submit">Add</button>
    </form>

    <h2>Existing FTP Servers</h2>
    <?php

    $ftpUrls = fetchData('ftp_servers');
    foreach ($ftpUrls as $key => $value) {

        $isActive = (int)$value['active'] === 1;
        $isManaged = (int)$value['is_managed'] === 1;

        echo "<div>";
        echo "<form action='admin.php' method='POST'>";
        echo "<input type='hidden' name='action' value='update_ftp'>";
        echo "<input type='hidden' name='url_id' value='{$value['id']}'>";
        echo "<label>ID </label><input type='text' value='{$value['id']}' readonly>";
        echo "<label> Label </label><input type='text' name='ftp_label' value='{$value['label']}' required>";
        echo "<label> URL </label><input type='text' name='ftp_url' value='{$value['url']}' required>";
        echo "<label> Port </label><input type='text' name='ftp_port' value='{$value['port']}' required>";
        echo "<label> Active </label><select name='ftp_active' required>";
        echo "<option value='1'" . ($isActive ? " selected" : "") . ">Yes</option>";
        echo "<option value='0'" . (!$isActive ? " selected" : "") . ">No</option>";
        echo "</select>";
        echo "<label> Managed </label><select name='ftp_managed' disabled style='margin-right: 10px;'>";
        echo "<option value='1'" . ($isManaged ? " selected" : "") . ">Yes</option>";
        echo "<option value='0'" . (!$isManaged ? " selected" : "") . ">No</option>";
        echo "</select>";
        echo "<button type='submit'>Update</button>";
        echo "<button type='submit' name='action' value='delete_ftp'>Delete</button>";
        echo "</form>";
        echo "</div>";
    }

    ?>

    <h2>Existing Roles</h2>
    <?php

    $exRoles = fetchData('roles');
    foreach ($exRoles as $key => $value) {

        echo "<div>";
        echo "<form action='include/admin/admin.php' method='POST'>";
        echo "<input type='hidden' name='action' value='update_roles'>";
        echo "<input type='hidden' name='role_id' value='{$value['id']}'>";
        echo "<label>ID </label><input type='text' value='{$value['id']}'>";
        echo "<label> Name </label><input type='text' name='role_name' value='{$value['name']}' required>";
        echo "<button type='submit'>Update</button>";
        echo "<button type='submit' name='action' value='delete_roles'>Delete</button>";
        echo "</form>";
        echo "</div>";
    }

    ?>

    <h2>Existing Actions</h2>
    <?php
    $exActions = fetchData('actions');

    foreach ($exActions as $key => $value) {

        echo "<div>";
        echo "<label>ID </label><input type='text' value='{$value['id']}'>";
        echo "<label> Name </label><input type='text' name='action_name' value='{$value['name']}' required>";
        echo "</div>";
    }
    ?>

    <h2>Existing Resources</h2>
    <?php

    $exResources = fetchData('resources');
    foreach ($exResources as $key => $value) {

        echo "<div>";
        echo "<form action='include/admin/admin.php' method='POST'>";
        echo "<input type='hidden' name='action' value='update_resource'>";
        echo "<input type='hidden' name='resource_id' value='{$value['id']}'>";
        echo "<label>ID </label><input type='text' value='{$value['id']}'>";
        echo "<label> Name </label><input type='text' name='action_name' value='{$value['name']}' required>";
        echo "<button type='submit'>Update</button>";
        echo "<button type='submit' name='action' value='delete_resource'>Delete</button>";
        echo "</form>";
        echo "</div>";
    }

    ?>

    <h2>Existing Role Resource Entries</h2>
    <div style='border: solid 2px black;width:fit-content;max-height:400px;overflow-y:auto;'>
        <?php
        $exRoleResources = fetchData('role_resources');
        foreach ($exRoleResources as $key => $value) {

            echo "<div>";
            echo "<form action='include/admin/admin.php' method='POST'>";
            echo "<input type='hidden' name='action' value='update_role_resources'>";
            echo "<input type='hidden' name='role_id' value='{$value['role_id']}'>";
            echo "<input type='hidden' name='resource_id' value='{$value['resource_id']}'>";
            echo "<input type='hidden' name='action_id' value='{$value['action_id']}'>";
            echo "<label>Role ID </label><input type='text' name='role_id_new' value='{$value['role_id']}'>";
            echo "<label> Resource ID </label><input type='text' name='resource_id_new' value='{$value['resource_id']}' required>";
            echo "<label> Action ID </label><input type='text' name='action_id_new' value='{$value['action_id']}' required>";
            echo "<button type='submit'>Update</button>";
            echo "<button type='submit' name='action' value='delete_role_resources'>Delete</button>";
            echo "</form>";
            echo "</div>";
        }

        ?>
    </div>
</body>
</html>