<?php
require_once 'config.php';

// Get the request path
$request = $_SERVER['REQUEST_URI'];
$prefix = '/include/api/';

// Remove prefix from request path
if (strpos($request, $prefix) === 0) {
    $request = substr($request, strlen($prefix));
}

// Remove query string if present
if (($pos = strpos($request, '?')) !== false) {
    $request = substr($request, 0, $pos);
}

// Remove trailing slash
$request = rtrim($request, '/');

// Split the path into segments
$segments = explode('/', $request);
$GLOBALS['api_path_segments'] = $segments;
$module = $segments[0] ?? '';

// Route to appropriate handler based on the first segment
switch ($module) {
    case 'auth':
        require_once 'auth.php';
        break;
    case 'profile':
        require_once 'profile.php';
        break;
    case 'doors':
        require_once 'doors.php';
        break;
    case 'switch_property':
        require_once 'switch_property.php';
        break;
    default:
        http_response_code(404);
        echo json_encode(['error' => ['message' => 'Not found']]);
}