<?php
session_start();

function isSessionExpired()
{
    // Check if the session is expired
    $currentTime = new DateTime();
    $difference = ($currentTime->getTimestamp() - $_SESSION["loginTime"]) * 1000;
    if ($difference > $_SESSION['logout_duration']) {
        return true;
    }
    return false;
}

// Check if the session has expired
if (isSessionExpired()) {
    // Session has expired, return error status
    http_response_code(401); // Unauthorized
} else {
    // Session is still active, return success status
    http_response_code(200); // OK
}
