<?php

// Check if the base name is provided as a command-line argument
if ($argc < 2) {
    echo "Usage: php create_migration.php <base_name>\n";
    exit(1);
}

// Retrieve the base name from the command-line argument
$baseName = $argv[1];

// Directory where the file will be saved
$path = './migrations/';

function generateTimestampedName($name, $path = './')
{
    // Get the current timestamp in the format of YYYYMMDDHHMMSS
    $timestamp = date('YmdHis');

    // Concatenate the timestamp with the given name and path
    return [
        'filename' => $path . $timestamp . '_' . $name . '.php',
        'migrationNameWithTimeStamp' => $timestamp . '_' . $name
    ];
}

function createMigrationFile($filename, $content)
{
    // Create the file with the provided filename and content
    file_put_contents($filename, $content);
}

// Ensure the directory exists
if (!is_dir($path)) {
    mkdir($path, 0777, true);
}

// Generate the timestamped name and filename
$result = generateTimestampedName($baseName, $path);
$filename = $result['filename'];
$migrationNameWithTimeStamp = $result['migrationNameWithTimeStamp'];

$content = <<<EOT
<?php

class Migration_{$migrationNameWithTimeStamp}
{
    public static function up(PDO \$pdo)
    {
        // Your migration code here
    }

    public static function down(PDO \$pdo)
    {
        // Rollback code here
    }
}
EOT;

// Create the migration file
createMigrationFile($filename, $content);

echo "Migration file created: $filename\n";