<?php
	require_once($_SERVER['DOCUMENT_ROOT'] . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'helper_functions' . DIRECTORY_SEPARATOR . 'data_request.php');

	function format_date($payment_page, $payment_date){
		if($payment_page == "next"){
	        $date = DateTime::createFromFormat('Y-m', $payment_date);
	        $date->modify('+1 month');
	        $newDate = $date->format('Y-m');
	        return $newDate;
		}
		else if($payment_page == "previous"){
			$date = DateTime::createFromFormat('Y-m', $payment_date);
			$date->modify('-1 month');
			$newDate = $date->format('Y-m');
			return $newDate;
		}
		
	}

	function getDealaer($property_id){
		$data = [];
		$property_data = fetchDataSingle('properties', ['id' => $property_id]);
		$data['property'] = $property_data;
		if(!empty($property_data) && isset($property_data['organization_id'])){
			$organization = fetchDataSingle('organizations', ['id' => $property_data['organization_id']]);
			if(!empty($organization) && isset($organization['dealer_id'])){
				$user = fetchDataSingle('users', ['id' => $organization['dealer_id']]);
				$data['dealer'] = $user;
			}
		}
		return $data;
	}

	function update_product_price($property_id, $product_id, $dealer_price, $end_user_price, $product_qty){
		$check = fetchDataSingle('call_pricings', ['property_id' => $property_id, 'product_id' => $product_id]);
		if(isset($check['id']) && !empty($check['id'])){
			updateTable('call_pricings', 
                [
                    'product_qty' => $product_qty,
                    'dealer_price' => $dealer_price,
                    'end_user_price' => $end_user_price
                ], 
                'id = :id', 
                ['id' => $check['id']]
            );
		}
		else{

			insertData('call_pricings', ['property_id' => $property_id, 'product_id' => $product_id, 'product_qty' => $product_qty, 'dealer_price' => $dealer_price, 'end_user_price' => $end_user_price]);
		}

		return 1;
	}

	function get_payment_data($property_id, $product_id){
		$check = "";
		$check = fetchDataSingle('call_pricings', ['property_id' => $property_id, 'product_id' => $product_id]);
		if(!empty($check)){
			$check['new_saved'] = 1;
			return $check;
		}
		else{
			$check_local_numbers = fetchData('my_numbers', ['property_id' => $property_id, 'number_type' => 'Local']);
			$check_toll_free_numbers = fetchData('my_numbers', ['property_id' => $property_id, 'number_type' => 'TollFree']);
			$check_numbers = count($check_local_numbers) + count($check_toll_free_numbers);
			$number_array = [];
			$number_array['new_saved'] = 0;
			$number_array['local_product_qty'] = count($check_local_numbers);
			$number_array['toll_free_product_qty'] = count($check_toll_free_numbers);
			$number_array['product_qty'] = $check_numbers;
			$number_array['local_number_dealer_price'] = "0.5";
			$number_array['end_user_price'] = "1";
			$number_array['toll_free_number_dealer_price'] = "0.8";
			$number_array['toll_free_end_user_price'] = "1.6";
			return $number_array;


			return "";
		}
	}



