<script src="js/settings/settings.js"></script>

<style>
    .ftp-label-wrapper {
        width: 120px;
    }
    .ftp-label {
        font-family: inherit;
        font-size: 1rem;
        font-weight: bold;
    }
</style>

<div class="row">
    <div class="col-12">

        <div class="d-flex justify-content-between align-items-center">
            <div>
                <button type="button" onclick="resetForm()" data-toggle="modal" data-target="#addNewSetting" class="btn btn-dark my-3"><i class="fas fa-plus"></i> Camera</button>
            </div>
        </div>

        
        <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Camera</h3>
                    <!-- Search bar -->
                    <div class="card-tools">
                        <div class="input-group input-group-sm" style="width: 250px;">
                            <input type="text" id="searchCameraInput" onkeyup="searchTable('camera_data_table', 'searchCameraInput')" class="form-control float-right" placeholder="Search Camera">
                            <input type="text" name="search_camera_value" onkeyup="searchCameraDevices()" id="search_camera_value" class="form-control float-right" placeholder="Search Camera" style="display: none;">
                           
                            <div class="input-group-append">
                                <button type="button" class="btn btn-default">
                                    <i class="fas fa-search"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body" id="settings_table">
                </div>
            </div>
    </div>
</div>

<div class="modal fade" id="addNewSetting" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalCenterTitle">Camera</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="addSettingForm" onsubmit="return addSettings(event)">

                    <input type="hidden" id="settingId" name="settingId">

                    <div class="input-group mb-3">
                        <input type="text" required class="form-control" id="cameraName" placeholder="Name">
                        <input type="text" required class="form-control" id="cameraModel" placeholder="Model">
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <i class="fa-solid fa-camera"></i>
                            </div>
                        </div>
                    </div>

                    <div class="input-group mb-3">
                        <input type="text" onkeyup="create_RTSP_URL()" class="form-control" id="Username" placeholder="Username">
                        <input type="text" onkeyup="create_RTSP_URL()" class="form-control" id="Password" placeholder="Enter Password">
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <!-- <span class="fa-solid fa-address-card"></span> -->
                                <span class="fa-solid fa-user-secret"></span>
                            </div>
                        </div>
                    </div>

                    <div class="input-group mb-3">
                        <input type="text" onkeyup="create_RTSP_URL()" class="form-control" id="IP" placeholder="Enter Ip">
                        <input type="text" onkeyup="create_RTSP_URL()" class="form-control" id="liveImagePort" placeholder="Image port">
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <i class="fa-solid fa-address-card"></i>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="liveImageUrl">Live image Url</label>
                        <div class="d-flex">
                            <input type="text" required id="liveImageUrlId" class="form-control" placeholder="live Image Url">
                            <button type="button" class="btn btn-success ml-2 d-flex align-items-center" onclick="testLiveImageUrl()">test <img style="width:20px;margin-left:5px;display:none" id="loadingIndicator" src="/include/images/loader.gif" alt="" srcset=""> <span id="testCameraStatusIcon"></span></button>
                        </div>
                        <div id="testingError" style="padding:12px 4px 3px;color:red" class="error">

                        </div>
                    </div>

                    <div class="form-group d-flex align-items-center">
                        <label for="haveRTSPStreaming" class="m-0">RTSP Streaming</label>
                        <input type="checkbox" style="width:20px; height:20px; margin-left:20px" onchange="isRTSPStreaming()" id="haveRTSPStreaming" disabled>
                        <small class="text-muted" style="margin-left:8px; font-style:italic;">Coming Soon</small>
                    </div>


                    <div id="createRTSPUrl">
                        <div class="input-group mb-3">
                            <input type="number" onkeyup="create_RTSP_URL()" class="form-control" id="RTSP_PORT" placeholder="Enter port">
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card"></span>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="StreamingUrl">Streaming url</label>
                            <input type="text" class="form-control" id="StreamingUrl" placeholder="Enter Streaming url">
                        </div>
                    </div>
                    

                    <div class="form-group d-flex align-items-center">
                        <label for="haveFTPServer" class="m-0">FTP</label>
                        <input type="checkbox" style="width:20px; height:20px; margin-left:20px" onchange="toggleFtpOptions()" id="haveFTPServer">
                    </div>

                    <div id="ftpOptions" style="display: none; padding-left: 20px;">
                        <input type="hidden" id="confirm_switch_ftp" name="confirm_switch_ftp" value="0">
                        <input type="hidden" id="original_ftp_mode" name="original_ftp_mode" value="">
                        <div class="form-group">
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="ftp_mode" id="ftpManaged" value="managed" onchange="toggleFtpInputs()">
                                <label class="form-check-label" for="ftpManaged">Managed</label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="ftp_mode" id="ftpCustom" value="custom" onchange="toggleFtpInputs()">
                                <label class="form-check-label" for="ftpCustom">Custom</label>
                            </div>
                        </div>

                        <div id="ftpManagedDropdownContainer" style="display: none;">
                            <div class="input-group mb-3">
                                <select id="ftp_managed_select" name="ftp_managed_select" class="form-control">
                                </select>
                                <input type="text" id="camera_folder_name" name="camera_folder_name" class="form-control" placeholder="Folder Name" required pattern="[A-Za-z0-9_]{1,24}" maxlength="24" title="Use only letters, numbers, underscore (_). No spaces, dashes, or special characters." oninput="this.value=this.value.replace(/[^A-Za-z0-9_]/g,'')">
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fa-solid fa-floppy-disk"></span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div id="managedCredsBtnWrap" style="display:none; margin-top:8px;">
                            <button type="button" id="viewFtpCredsBtn" class="btn btn-outline-primary btn-sm">
                                <i class="fa-solid fa-eye mr-1"></i> View Ftp Credentials
                            </button>
                            <small id="managedCredsHint" class="text-muted ml-2" style="display:none;">
                                credentials unavailable
                            </small>
                        </div>

                        <div id="ftpCustomInputs" style="display: none;">
                            <div class="input-group mb-3">
                                <input type="text" class="form-control" id="camera_ftp_folder" placeholder="Ftp folder name">
                                <input type="text" class="form-control" id="ftp_host" placeholder="Ftp host">
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fa-solid fa-address-card"></span>
                                    </div>
                                </div>
                            </div>

                            <div class="input-group mb-3">
                                <input type="text" class="form-control" id="ftp_user" placeholder="Ftp user">
                                <input type="text" class="form-control" id="ftp_password" placeholder="Ftp password">
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fa-solid fa-address-card"></span>
                                    </div>
                                </div>
                            </div>

                            <div class="input-group mb-3">
                                <input type="text" class="form-control" id="ftp_port" placeholder="Enter port">
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fa-solid fa-address-card"></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="modal-footer">
                        <button type="submit" id="AddSetting" class="btn btn-secondary">Add</button>
                    </div>

                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="ftpCredsModal" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="false">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title m-0">Managed FTP Credentials</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close" id="ftpCredsCloseX">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body pt-3">
        <div class="form-group d-flex align-items-center">
          <label class="mb-0 mr-2" style="width:90px;">Host</label>
          <input type="text" class="form-control" id="ftpModalHost" readonly>
          <button class="btn btn-light ml-2 copy-btn" data-copy-target="ftpModalHost" type="button" title="Copy"><i class="fa-solid fa-copy"></i></button>
        </div>
        <div class="form-group d-flex align-items-center">
          <label class="mb-0 mr-2" style="width:90px;">Port</label>
          <input type="text" class="form-control" id="ftpModalPort" readonly>
          <button class="btn btn-light ml-2 copy-btn" data-copy-target="ftpModalPort" type="button" title="Copy"><i class="fa-solid fa-copy"></i></button>
        </div>
        <div class="form-group d-flex align-items-center">
          <label class="mb-0 mr-2" style="width:90px;">User</label>
          <input type="text" class="form-control" id="ftpModalUser" readonly>
          <button class="btn btn-light ml-2 copy-btn" data-copy-target="ftpModalUser" type="button" title="Copy"><i class="fa-solid fa-copy"></i></button>
        </div>
        <div class="form-group d-flex align-items-center">
          <label class="mb-0 mr-2" style="width:90px;">Password</label>
          <div class="input-group">
            <input type="password" class="form-control" id="ftpModalPass" readonly>
            <div class="input-group-append">
              <button class="btn btn-light" id="togglePassVis" type="button" title="Show/Hide"><i class="fa-solid fa-eye"></i></button>
              <button class="btn btn-light copy-btn" data-copy-target="ftpModalPass" type="button" title="Copy"><i class="fa-solid fa-copy"></i></button>
            </div>
          </div>
        </div>
        <div class="form-group d-flex align-items-center">
          <label class="mb-0 mr-2" style="width:90px;">Folder</label>
          <input type="text" class="form-control" id="ftpModalFolder" readonly>
          <button class="btn btn-light ml-2 copy-btn" data-copy-target="ftpModalFolder" type="button" title="Copy"><i class="fa-solid fa-copy"></i></button>
        </div>
        <small class="text-muted">These credentials are read-only here. Changes happen via your camera setup only.</small>
      </div>
      <div class="modal-footer">
        <button type="button" id="ftpCredsClose" class="btn btn-secondary" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="viewCameraModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalCenterTitle">Camera details</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="viewSettingForm">

                    <div class="input-group mb-3">
                        <input type="text" class="form-control" id="cameraNameView" placeholder="Name">
                        <input type="text" class="form-control" id="cameraModelView" placeholder="Model">
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <i class="fa-solid fa-camera"></i>
                            </div>
                        </div>
                    </div>

                    <div class="input-group mb-3">
                        <input type="text" class="form-control" id="UsernameView" placeholder="Username">
                        <input type="text" class="form-control" id="PasswordView" placeholder="Enter Password">
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fa-solid fa-user-secret"></span>
                            </div>
                        </div>
                    </div>

                    <div class="input-group mb-3">
                        <input type="text" class="form-control" id="IPView" placeholder="Enter Ip">
                        <input type="text" class="form-control" id="liveImagePortView" placeholder="Image port">
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <i class="fa-solid fa-address-card"></i>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="liveImageUrlView">Live image Url</label>
                        <div class="d-flex">
                            <input type="text" id="liveImageUrlView" class="form-control" placeholder="live Image Url">
                        </div>
                    </div>

                    <div class="form-group d-flex">
                        <label for="haveRTSPStreamingView" class="m-0">RTSP Streaming?</label>
                        <input type="checkbox" style="width:20px; height:20px; margin-left:20px" id="haveRTSPStreamingView" disabled>
                    </div>

                    <div id="createRTSPUrlView">
                        <div class="input-group mb-3">
                            <input type="number" class="form-control" id="RTSP_PORTView" placeholder="Enter port">
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card"></span>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="StreamingUrlView">Streaming url</label>
                            <input type="text" class="form-control" id="StreamingUrlView" placeholder="Enter Streaming url">
                        </div>
                    </div>

                    <div class="form-group d-flex">
                        <label for="haveFTPServerView" class="m-0">FTP?</label>
                        <input type="checkbox" style="width:20px; height:20px; margin-left:20px" id="haveFTPServerView" disabled>
                    </div>

                    <div id="isFtpServerView">
                        <div class="input-group mb-3">
                            <input type="text" class="form-control" id="camera_ftp_folderView" placeholder="Ftp folder name">
                            <input type="text" class="form-control" id="ftp_hostView" placeholder="Ftp host">
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card"></span>
                                </div>
                            </div>
                        </div>

                        <div class="input-group mb-3">
                            <input type="text" class="form-control" id="ftp_userView" placeholder="Ftp user">
                            <input type="text" class="form-control" id="ftp_passwordView" placeholder="Ftp password">
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card"></span>
                                </div>
                            </div>
                        </div>

                        <div class="input-group mb-3">
                            <input type="text"
                                class="form-control" id="ftp_portView" placeholder="Enter port">
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="toast-container position-fixed p-3" id="cameraToastMessage" style="display:none;z-index: 99999; top: 20px; right: 0px;width:300px">
    <div id="camera_hardware_Toast" class="toast bg-danger text-white" role="alert" aria-live="assertive" aria-atomic="true">
        <div class="toast-header d-flex justify-content-between  ">
            <strong class="me-auto">Error</strong>
            <button onclick="closeCameraToastMessage()" type="button" class="close " data-dismiss="modal" aria-label="Close">
                <span>&times;</span>
            </button>
        </div>
        <div class="toast-body" id="cameraErrorToast">
            An error occurred! Please check the details and try again.
        </div>
    </div>
</div>