<?php

try {
    session_start();
    require "../../property_builder/hardwares/hardwares_essentials.php";
} catch (\Throwable $th) {
}
?>

<script src="../../../js/property_builder/doors.js"></script>

<div class="d-flex justify-content-between">
    <h3 class="px-2">Doors</h3>
</div>

<div id="doors_view">
    <div class="d-flex">
        <button type="button" onclick="addNewDoorForm()" class="btn btn-block btn-dark" style="margin:1rem 0 1rem 0rem;width:auto;"><i class="fa-solid fa-plus"></i> Door</button>
    </div>
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Doors</h3>
            <!-- Search bar -->
            <div class="card-tools">
                <div class="input-group input-group-sm" style="width: 250px;">
                    <input type="text" id="search_door_value" onkeyup="searchDoor()" class="form-control float-right" placeholder="Search Gates/Doors">
                    <div class="input-group-append">
                        <button type="button" class="btn btn-default">
                            <i class="fas fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="d-flex flex-wrap align-items-center" id="Door_Table"></div>
        </div>
    </div>
</div>

<div id="doors_form_view" style="display: none;">

</div>

<!-- ============= Door form html ============= -->
<div class="modal fade" id="add_door_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="add_door_header">Add door</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body mx-2">
                <!-- <button type="button" onclick="openAddGroupModal()" class="btn btn-block btn-dark" style="margin:1rem 0 1rem 0rem;width:auto;">Add Group </button> -->
                <button type="button" onclick="openDoorGroupManagementModal()" class="btn btn-block btn-dark" style="margin:1rem 0 1rem 0rem;width:auto;">Add Group </button>
                <form onsubmit="return AddDoorGroupToDatabase(event)">
                    <input type="hidden" name="doorId" id="doorId" value="">
                    <div class="form-group">
                        <div class="custom-control custom-switch">
                            <input type="checkbox" class="custom-control-input" id="is_primary">
                            <label class="custom-control-label" for="is_primary">Is Primary</label>
                        </div>
                    </div>
                    <div class="d-flex align-items-center mb-2">
                        <div class="door_images"><img id="selectedImage"
                                class="w-full h-full object-contain rounded-full"
                                src="/include/images/door_image.png" alt="selected image">
                        </div>
                        <div class="ml-2">
                            <div class="text-center mb-2">
                                <label for="fileInput" class="form-label"><small class="text-muted">(Max file size: 4MB)</small></label>
                            </div>
                            <input type="file" id="fileInput" onchange="onDoorFileChange(event)" accept="image/*" class="hidden" />
                        </div>
                    </div>

                    <div class="row">
                        <div class="input-group mb-3">
                            <select name="group_by" id="group_by" title="Group by" class="form-control">
                            </select>
                            <input type="text" placeholder="Door name" title="Enter Door name" name="door_name" id="door_name" class="form-control" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <i class="fa-solid fa-user-group"></i>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="number"  title="Door key" placeholder="Door key" title="Enter door key" name="door_key" id="door_key" onkeyup="check_door_key()" class="form-control" required>
                            <select class="form-control" title="Select door type" id="doorType" name="doorType" required>
                                <option value="" disabled selected>Select type</option>
                                <?php foreach ($door_type as $value => $label) : ?>
                                    <option value="<?= htmlspecialchars($value) ?>">
                                        <?= htmlspecialchars($label) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <i class="fa-solid fa-key"></i>
                                </div>
                            </div>
                        </div>
                        
                        <div class="input-group mb-3">
                            <input type="text" name="location" id="location_door" title="Add location"title="Select number" placeholder="Add location" class="form-control">
                            <select name="door_number" id="door_number" onchange="handle_change_add_number_door()" title="Select number" class="form-control select2bs4">
                                <option value="">Please Select number</option>
                                <option style="color: blue;font-weight: 700;cursor: pointer;"  value='add_new'>Add new</option>
                                <?php if (!empty($my_numbers)) {
                                    foreach ($my_numbers as $num) { ?>
                                        <option value="<?php echo $num['phone_number'] ?>"><?php echo $num['phone_number'] ?></option>
                                <?php }
                                } ?>
                            </select>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <i class="fa-solid fa-location-dot"></i>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="w-100 form-group">
                            <textarea name="description" title="Description" placeholder="Enter details" id="description" class="form-control" rows="3"></textarea>
                        </div>
                    </div>

                    <div class="w-100 d-flex justify-content-end">
                        <button type="button" onclick="CancelDoorForm()" class="btn btn-secondary mx-2">Cancel </button>
                        <button type="submit" class="btn btn-primary">Save Door</button>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="add_camera_to_door_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="add_camera_to_door_header">Add Camera</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div id="add_new_camera_container " class="text-right" style="margin-bottom:-25px">
                    <a href="javascript:void(0)" onclick="RedirectToCameraForAddingNew()">Add new</a>
                </div>
                <form onsubmit="return add_camera_to_door_submit(event)">
                    <input type="hidden" name="door_id_for_camera" id="door_id_for_camera" value="">
                    <div class="form-group">
                        <label for="camera_select">Camera*</label>
                        <select class="form-control" id="camera_select" multiple name="camera_select">
                            <option value="" disabled selected>Select camera</option>
                        </select>
                    </div>

                    <div class="model-footer">
                        <button type="submit" class="ml-2 btn btn-block btn-dark" style="margin:1rem 0 1rem 0rem;width:auto;">Save</button>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="AddGroupModal" tabindex="-1" role="dialog" aria-labelledby="addGroupModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addGroupModalTitle">Add Group</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form onsubmit="return AddGroup(event)">
                    <input type="hidden" id="doorGroupId" name="doorGroupId" value="">
                    <div class="form-group">
                        <label>Group Name*</label>
                        <input type="text" id="groupName" name="groupName" class="form-control" placeholder="Enter group name" required>
                    </div>
                    <div class="form-group">
                        <button type="submit" class="btn btn-success">Save Group</button>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="AddQuickGroupModalToDoor" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalCenterTitle">Add Group</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form>
                    <input type="hidden" name="door_id_for_grouping" id="door_id_for_grouping" value="">
                    <div class="form-group">
                        <label for="quick_change_group_by">Group By</label>
                        <select name="quick_change_group_by" id="quick_change_group_by" class="form-control">
                        </select>
                    </div>

                    <div class="model-footer">
                        <button type="button" class="ml-2 btn btn-block btn-dark" onclick="quickUpdateDoorGroup()" style="margin:1rem 0 1rem 0rem;width:auto;">Add Group</button>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>

<div class="toast-container position-fixed p-3" id="doorsToastMessage" style="display:none;z-index: 99999; top: 20px; right: 0px;width:300px">
    <div id="door_hardware_Toast" class="toast bg-danger text-white" role="alert" aria-live="assertive" aria-atomic="true">
        <div class="toast-header d-flex justify-content-between  ">
            <strong class="me-auto">Error</strong>
            <button onclick="closeDoorToastMessage()" type="button" class="close " data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="toast-body" id="doorsErrorMessage">
            An error occurred! Please check the details and try again.
        </div>
    </div>
</div>

<div class="modal fade" id="DoorGroupManagementModal" tabindex="-1" role="dialog" aria-labelledby="doorGroupManagementModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="doorGroupManagementModalTitle">Door Groups</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <button type="button" class="btn btn-primary" onclick="openAddGroupModal()">Add New Group</button>
                </div>
                <div id="doorGroupList" class="list-group">
                    <!-- Groups will be populated here -->
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Door Image Modal -->
<div class="modal fade" id="doorImageModal" tabindex="-1" role="dialog" aria-labelledby="doorImageModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" style="width: 600px;height: 650px;" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="doorImageModalTitle">Door Image</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body text-center">
                <img id="enlargedDoorImage" src="" alt="Door Image" class="img-fluid" style="max-width: 100%; object-fit: contain;">
            </div>
        </div>
    </div>
</div>