<?php

try {
    if (session_status() === PHP_SESSION_NONE) session_start();
    require "./hardwares_essentials.php";
} catch (\Throwable $th) {
    // throw $th;
}
?>

<ul class="nav nav-tabs" id="myTabs" role="tablist">
    <li class="nav-item">
        <a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">Hardware</a>
    </li>
    <li class="nav-item">
        <a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">Camera</a>
    </li>
    <li class="nav-item">
        <a class="nav-link" id="automations-tab" data-toggle="tab" href="#automations" role="tab" aria-controls="automations" aria-selected="false">Automations</a>
    </li>
</ul>


<div class="tab-content" id="myTabsContent">
    <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
        <script src="../../../js/property_builder/hardware.js"></script>
        <div id="hardware_view">
            <div class="d-flex">
                <button type="button" onclick="addNewHardwareForm()" class="btn btn-block btn-dark" style="margin:1rem 0 1rem 0rem;width:auto;"><i class="fa-solid fa-plus"></i> Hardware</button>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Hardware</h3>
                    <!-- Search bar -->
                    <div class="card-tools">
                        <div class="input-group input-group-sm" style="width: 250px;">
                            <input type="text" id="search_hardware_value" onkeyup="searchHardwareDevices()" class="form-control float-right" placeholder="Search Hardware">
                            <div class="input-group-append">
                                <button type="button" class="btn btn-default">
                                    <i class="fas fa-search"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="isLoading justify-content-center m-5" style="display: none;" id="hardware_center_loading_indicator">
                        <img src="/include/images/loader.gif" style="width:100px;margin-left:5px" alt="" srcset="">
                    </div>

                    <div class="align-items-center justify-content-center" id="Hardware_Table"></div>
                </div>
            </div>
        </div>

        <div class="toast-container position-fixed p-3" id="hardwareToastMessage" style="display:none;z-index: 1055; top: 20px; right: 0px;width:300px">
            <div id="hardwareErrorToast" class="toast bg-danger text-white TostOnTopRight" role="alert" aria-live="assertive" aria-atomic="true">
                <div class="toast-header d-flex justify-content-between  ">
                    <strong class="me-auto">Error</strong>
                    <button onclick="closeHardwareToastMessage()" type="button" class="close " data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="toast-body" id="hardwareErrorMessage">
                </div>
            </div>
        </div>

    </div>
    <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
        <div class="py-3 px-1">
            <div class="px-2" id="cameras_content"></div>
            <script>
                function initializeCameraTab() {
                    $(document).ready(function() {
                        $.ajax({
                            url: "/include/property_builder/cameras/camera.php",
                            success: function(data) {
                                $("#cameras_content").html(data);
                            }
                        });
                    });
                }
                initializeCameraTab();

                $('a[data-toggle="tab"]').on("shown.bs.tab", function(e) {
                    if ($(e.target).attr("id") === "profile-tab") {
                        setTimeout(() => {
                            if ($.fn.DataTable.isDataTable("#camera_data_table")) {
                                $("#camera_data_table").DataTable().columns.adjust().draw();
                            }
                        }, 200); // Delay helps ensure UI updates
                    }
                });
            </script>
        </div>
    </div>

    <div class="tab-pane fade" id="automations" role="tabpanel" aria-labelledby="automations-tab">
        <div class="">
            <div class="px-2" id="automations_content"></div>
            <script>
                function initializeCameraTab() {
                    $(document).ready(function() {
                        $.ajax({
                            url: "/include/property_builder/hardwares/hardware_automations.php",
                            success: function(data) {
                                $("#automations_content").html(data);
                            }
                        });
                    });
                }
                initializeCameraTab();
            </script>
        </div>
        
    </div>
</div>


<div class="modal fade" id="add_hardware_settings_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="add_camera_to_door_header">Hardware setting</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form onsubmit="return add_hardware_settings_data(event)">
                    <input type="hidden" name="hardware_settings_edit_id" id="hardware_settings_edit_id" value="">
                    <input type="hidden" name="hardware_device_id" id="hardware_device_id" value="">
                    <div class="form-group">
                        <label for="assign_door">Door name*</label>
                        <select class="form-control" id="assign_door" name="assign_door">
                            <option value="" disabled selected>Select Door</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="web_relay_output">Output*</label>
                        <select class="form-control" id="web_relay_output" name="web_relay_output">
                            <option value="" disabled selected>Select output</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="web_relay_input">Input</label>
                        <select class="form-control select2-multi" id="web_relay_input" multiple name="web_relay_input">
                            <option value="" disabled selected>Select inputs</option>
                        </select>
                    </div>
                    
                    <div class="form-group" id="sms_duration_container">
                        <label for="sms_io_duration_input">Timer</label>
                        <input type="number" id="sms_io_duration_input" name="sms_io_duration_input" class="form-control" title="Sms IO duration" value="+" minlength="0" maxlength="65,535">
                    </div>

                    <div class="form-group">
                        <label for="hardware_settings_timer">Schedule</label>
                        <select class="form-control" id="hardware_settings_timer" name="hardware_settings_timer">
                            <option value="" disabled selected>Select timer</option>
                        </select>
                    </div>

                    <div class="button" class="testing_button" id="webRelayTestingInModal" style="display:none">
                        <button type="button" id="testHardwareButtonModal" class="btn btn-success ml-2 d-flex align-items-center" onclick="testDeviceStatus()">test <img style="width:20px;margin-left:5px;display:none" id="loadingTestIndicatorModal" src="/include/images/loader.gif" alt="" srcset=""><span id="testStatusIconModal"></span></button>
                    </div>

                    <div class="model-footer">
                        <button type="submit" class="ml-2 btn btn-block btn-dark" style="margin:1rem 0 1rem 0rem;width:auto;">Add</button>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="add_edit_hardware_form_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="add_camera_to_door_header">
                    <i class="fas fa-microchip me-2"></i>Hardware setting
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="webrelayForm">
                    <input type="hidden" name="hardwareId" id="hardwareId" value="">

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="device_type">Device type*</label>
                                <div class="input-group mb-3">
                                    <select class="form-control" onchange="setModelOptions()" id="device_type" name="device_type" required>
                                        <option value="" disabled selected>Select Device type</option>
                                        <?php foreach ($device_type as $value => $label) : ?>
                                            <option value="<?= htmlspecialchars($value) ?>">
                                                <?= htmlspecialchars($label) ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                    <div class="input-group-append">
                                        <div class="input-group-text">
                                            <span class="fas fa-tag"></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="webrelayModel">Model*</label>
                                <div class="input-group mb-3">
                                    <select class="form-control" id="webrelayModel" name="webrelayModel" onchange="onSelectionChange()" required>
                                        <option value="" disabled selected>Select device type first</option>
                                    </select>
                                    <div class="input-group-append">
                                        <div class="input-group-text">
                                            <span class="fas fa-microchip"></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id="sms_io_container_password" style="display:none">
                            <div class="form-group">
                                <label for="sms_io_password">Password*</label>
                                <div class="input-group mb-3">
                                    <input type="text" id="sms_io_password" name="sms_io_password" class="form-control" title="Password">
                                    <div class="input-group-append">
                                        <div class="input-group-text">
                                            <span class="fas fa-lock"></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 sms_io_container" style="display:none">
                            <div class="form-group">
                                <label for="sms_io_number">SMS IO Number*</label>
                                <div class="input-group mb-3">
                                    <input type="text" id="sms_io_number" name="sms_io_number" class="form-control" title="Sms IO Number" value="+" oninput="enforcePlusAndNumbers(this)"
                                        pattern="^\+[0-9]{11}$" maxlength="12" placeholder="+1---------">
                                    <div class="input-group-append">
                                        <div class="input-group-text">
                                            <span class="fas fa-phone"></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 sms_io_container" style="display:none">
                            <div class="form-group">
                                <label for="system_control_number">Invisible Intercom Control Number*</label>
                                <div class="input-group mb-3">
                                    <select
                                        id="system_control_number"
                                        name="system_control_number"
                                        class="form-control"
                                        title="Invisible Intercom Control Number">
                                        <option value="">Select a number</option>
                                    </select>
                                    <div class="input-group-append">
                                        <div class="input-group-text">
                                            <span class="fas fa-hashtag"></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 web_relay_container">
                            <div class="form-group">
                                <label for="ip_address">IP Address*</label>
                                <div class="input-group mb-3">
                                    <input type="text" onkeyup="createHardwareUrl()" class="form-control" id="ip_address" name="ip_address" placeholder="192.168.1.100">
                                    <div class="input-group-append">
                                        <div class="input-group-text">
                                            <span class="fas fa-globe"></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 web_relay_container">
                            <div class="form-group">
                                <label for="http_port">Port*</label>
                                <div class="input-group mb-3">
                                    <input type="number" onkeyup="createHardwareUrl()" class="form-control" id="http_port" name="http_port" placeholder="80">
                                    <div class="input-group-append">
                                        <div class="input-group-text">
                                            <span class="fas fa-plug"></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 web_relay_container">
                            <div class="form-group">
                                <label for="hardware_user_name">User name</label>
                                <div class="input-group mb-3">
                                    <input type="text" onkeyup="createHardwareUrl()" class="form-control" id="hardware_user_name" name="hardware_user_name" placeholder="admin">
                                    <div class="input-group-append">
                                        <div class="input-group-text">
                                            <span class="fas fa-user"></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 web_relay_container">
                            <div class="form-group">
                                <label for="hardware_password">Password</label>
                                <div class="input-group mb-3">
                                    <input type="text" onkeyup="createHardwareUrl()" class="form-control" id="hardware_password" name="hardware_password" placeholder="Enter password">
                                    <div class="input-group-append">
                                        <div class="input-group-text">
                                            <span class="fas fa-lock"></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="hardware_is_active">Is active*</label>
                                <div class="d-flex justify-content-center">
                                    <div class="form-group w-100">
                                        <div class="input-group mb-3">
                                            <select class="form-control" onchange="handleActiveChange()" id="hardware_is_active" name="hardware_is_active" required>
                                                <option value="true" selected>Active</option>
                                                <option value="false">Disabled</option>
                                            </select>
                                            <div class="input-group-append">
                                                <div class="input-group-text">
                                                    <span class="fas fa-power-off"></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="button sms_io_container" id="SMSTestButton" style="display:none">
                                        <button type="button" id="testHardwareButtonSMS" class="btn btn-success ml-2 d-flex align-items-center" onclick="testSMSIODeviceStatus()">test <img style="width:20px;margin-left:5px;display:none" id="loadingTestIndicatorSMS" src="/include/images/loader.gif" alt="" srcset=""><span id="testStatusIconSMS"></span></button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-12 web_relay_container">
                            <div class="form-group">
                                <label for="device_url">Device Url*</label>
                                <div class="d-flex justify-content-center">
                                    <div class="form-group w-100 ">
                                        <div class="input-group mb-3">
                                            <input type="text" class="form-control m-0" id="device_url" name="device_url" placeholder="http://192.168.1.100:80">
                                            <div class="input-group-append">
                                                <div class="input-group-text">
                                                    <span class="fas fa-link"></span>
                                                </div>
                                            </div>
                                        </div>
                                        <p id="testingMessage" style="padding:12px 4px 3px;color:red" class="error"></p>
                                    </div>
                                    <div class="button" class="testing_button" id="webRelayTesting">
                                        <button type="button" id="testHardwareButton" class="btn btn-success ml-2 d-flex align-items-center" onclick="testDeviceStatus()">test <img style="width:20px;margin-left:5px;display:none" id="loadingTestIndicator" src="/include/images/loader.gif" alt="" srcset=""><span id="testStatusIcon"></span></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group text-right">
                        <button type="button" onclick="addHardwareToDatabase()" class="btn btn-primary">
                            Submit
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="download_hardware_config_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="add_camera_to_door_header">Download Config</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form>
                    <input type="hidden" name="hardware_download_id" id="hardware_download_id" value="">
                    <div class="form-group">
                        <label for="assign_door">Download file name*</label>
                        <input type="text" class="form-control" value="Configurations" name="download_file_name" id="download_file_name" value="">
                    </div>

                    <div class="model-footer d-flex">
                        <button type="button" onclick="download_hardware_config_data()" class="ml-2 btn btn-block btn-dark" style="margin:1rem 0 1rem 0rem;width:auto;">Config</button>
                        <button type="button" id="readme_file_button" onclick="download_hardware_Readme_file()" class="ml-2 btn btn-block btn-dark" style="margin:1rem 0 1rem 0rem;width:auto;">Readme UC1414</button>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="testing_hardware_sms_device" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <!-- <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div> -->
            <div class="modal-body">
                <div class="d-flex flex-column justify-content-center align-items-center">
                    <div id="smsTestingStatus">

                    </div>
                    <img src="/include/images/loader.gif" width="30" alt="" srcset="">
                </div>
            </div>
        </div>
    </div>
</div>