<style>
    .table{
        width: 100%!important;
    }
    /* Custom styles for tab colors */
    .nav-tabs .nav-link {
        color: black;
        /* Default color for inactive tabs */
    }

    .nav-tabs .nav-link.active {
        color: blue;
        /* Color for active tab */
    }

    .nav-tabs .nav-link:hover {
        color: blue;
        /* Hover color for tabs */
    }

    .nav-tabs .nav-link.active {
        background-color: #f8f9fa;
        /* Background color for active tab */
        border-color: #dee2e6 #dee2e6 #fff;
        /* Border color adjustments */
    }

    .showHide {
        display: none !important;
    }
    .select2-container .select2-selection--single {
        height: auto !important;
    }
    
    .previous{
        display: none !important;
    }
    .next{
        display: none !important;
    }
    .dataTables_info{
        display: none !important;
    }
    .table-responsive {
        overflow-x: hidden !important;
        overflow-y: hidden !important;
    }
</style>
<?php

    session_start();
    //code...
    require './../../db.php';
    require './../auth/auth_functions.php';

    if (!currentUserHasAccess($pdo, 'property_builder', 'read')) {
        echo "Access denied.";
        exit();
    }
    
$allowedDir = "../../../data/audio_messages/";
$activeTab = "doors";
if (!empty($_SESSION["active_property_tab"])) {
    switch ($_SESSION["active_property_tab"]) {
        case 1:
            $activeTab = "doors";
            break;
        case 2:
            $activeTab = "hardware";
            break;
        case 3:
            $activeTab = "access";
            break;
        case 4:
            $activeTab = "schedule";
            break;
        case 5:
            $activeTab = "callflow";
            break;
        case 6:
            $activeTab = "qrcodes";
            break;
        case 7:
            $activeTab = "settings";
            break;
        case 8:
            $activeTab = "streets";
            break;
        // case 8:
        //     $activeTab = "Cameras";
        //     break;
        default:
            $activeTab = "doors";
    }
}
?>
<div>
    <script src="js/property_builder/ajax_handling.js"></script>
    <input type="hidden" name="active_tab_val" id="active_tab_val" value="<?php echo $activeTab; ?>">
    <div class="mt-5">
        <!-- Tab navigation -->
        <div id="status_call_flow_message"></div>
        <ul class="nav nav-tabs" id="myTab" role="tablist">
            <li class="nav-item">
                <a onclick="RedirectToActiveTab(1)" class="nav-link <?php echo $activeTab == 'doors' ? 'active' : ''; ?>" id="doors-tab" data-toggle="tab" href="#doors" role="tab" aria-controls="doors" aria-selected="<?php echo $activeTab == 'doors' ? 'true' : 'false'; ?>">Gates/Doors</a>
            </li>
            <li class="nav-item">
                <a onclick="RedirectToActiveTab(2)" class="nav-link <?php echo $activeTab == 'hardware' ? 'active' : ''; ?>" id="hardware-tab" data-toggle="tab" href="#hardware" role="tab" aria-controls="hardware" aria-selected="<?php echo $activeTab == 'hardware' ? 'true' : 'false'; ?>">Hardware/Camera</a>
            </li>
            <li class="nav-item">
                <a onclick="RedirectToActiveTab(3)" class="nav-link <?php echo $activeTab == 'access' ? 'active' : ''; ?>" id="access-tab" data-toggle="tab" href="#access" role="tab" aria-controls="access" aria-selected="<?php echo $activeTab == 'access' ? 'true' : 'false'; ?>">Access Levels</a>
            </li>
            <li class="nav-item">
                <a onclick="RedirectToActiveTab(4)" class="nav-link <?php echo $activeTab == 'schedule' ? 'active' : ''; ?>" id="schedules-tab" data-toggle="tab" href="#schedule" role="tab" aria-controls="schedules" aria-selected="<?php echo $activeTab == 'schedule' ? 'true' : 'false'; ?>">Schedules</a>
            </li>
            <li class="nav-item">
                <a onclick="RedirectToActiveTab(5)" class="nav-link <?php echo $activeTab == 'callflow' ? 'active' : ''; ?>" id="callflow-tab" data-toggle="tab" href="#callflow" role="tab" aria-controls="callflow" aria-selected="<?php echo $activeTab == 'callflow' ? 'true' : 'false'; ?>">My Call Flow</a>
            </li>
            <li class="nav-item">
                <a onclick="RedirectToActiveTab(6)" class="nav-link <?php echo $activeTab == 'qrcodes' ? 'active' : ''; ?>" id="qrcodes-tab" data-toggle="tab" href="#qrcodes" role="tab" aria-controls="qrcodes" aria-selected="<?php echo $activeTab == 'qrcodes' ? 'true' : 'false'; ?>">My QR Codes</a>
            </li>
            <li class="nav-item">
                <a onclick="RedirectToActiveTab(7)" class="nav-link <?php echo $activeTab == 'settings' ? 'active' : ''; ?>" id="settings-tab" data-toggle="tab" href="#settings" role="tab" aria-controls="settings" aria-selected="<?php echo $activeTab == 'settings' ? 'true' : 'false'; ?>">Permissions</a>
            </li>
            <li class="nav-item">
                <a onclick="RedirectToActiveTab(8)" class="nav-link <?php echo $activeTab == 'streets' ? 'active' : ''; ?>" id="streets-tab" data-toggle="tab" href="#streets" role="tab" aria-controls="streets" aria-selected="<?php echo $activeTab == 'streets' ? 'true' : 'false'; ?>">Streets</a>
            </li>
        </ul>

        <!-- Tab content -->
        <div class="tab-content" id="myTabContent">
            <div class="tab-pane fade <?php echo $activeTab == 'doors' ? 'show active' : ''; ?>" id="doors" role="tabpanel" aria-labelledby="doors-tab">
                <div class="py-3 px-1">
                    <div id="Doors-content">
                        <div class="d-flex justify-content-center">
                            <div class="loader_image">
                                <img src="/include/images/loader.gif" alt="">
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="tab-pane fade <?php echo $activeTab == 'hardware' ? 'show active' : ''; ?>" id="hardware" role="tabpanel" aria-labelledby="hardware-tab">
                <div class="py-3 px-1">
                    <div id="Hardware-content">
                        <div class="d-flex justify-content-center">
                            <div class="loader_image">
                                <img src="/include/images/loader.gif" alt="">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade <?php echo $activeTab == 'access' ? 'show active' : ''; ?>" id="access" role="tabpanel" aria-labelledby="access-tab">
                <div class="py-3 px-1" id="access_levels_content">
                    <div class="d-flex justify-content-center">
                        <div class="loader_image">
                            <img src="/include/images/loader.gif" alt="">
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade <?php echo $activeTab == 'schedule' ? 'show active' : ''; ?>" id="schedule" role="tabpanel" aria-labelledby="schedule-tab">
                <div class="py-3 px-1">
                    <div id="schedules-content">
                        <div class="d-flex justify-content-center">
                            <div class="loader_image">
                                <img src="/include/images/loader.gif" alt="">
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="tab-pane fade <?php echo $activeTab == 'callflow' ? 'show active' : ''; ?>" id="callflow" role="tabpanel" aria-labelledby="callflow-tab">
                <div class="py-3 px-1">
                    <div class="d-flex showHide" id="add_call_flow_btn">
                        <button type="button" onclick="addNewCallFlow()" class="btn btn-block btn-dark" style="margin:1rem 0 1rem 0rem;width:auto;">Add New Call Flow</button>
                    </div>
                    <div id="my_call_flow_content" class="showHide">
                        <h3>My Call Flow</h3>
                        <form method="post" id="call_flow_form" action="include/call_flow/my_call_flow.php" enctype="multipart/form-data">
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label>1. A Visitor Calls My ii #</label><br>
                                        <label>2. A message is played</label>
                                    </div>
                                    <div class="form-group">
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" id="radioPrimary1" name="call_flow_first_message" onchange="change_radio(this.value, 'call_flow_first_message')" checked="" value="is_first_default_message">
                                            <label for="radioPrimary1">
                                                Default Message &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" onchange="change_radio(this.value, 'call_flow_first_message')" id="radioPrimary34" name="call_flow_first_message" value="is_first_upload_audio">
                                            <label for="radioPrimary34">
                                                Upload Audio &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" onchange="change_radio(this.value, 'call_flow_first_message')" id="radioPrimary2" name="call_flow_first_message" value="is_first_record_audio">
                                            <label for="radioPrimary2">
                                                Record Audio &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" onchange="change_radio(this.value, 'call_flow_first_message')" id="radioPrimary3" name="call_flow_first_message" value="is_first_textto_speech">
                                            <label for="radioPrimary3">
                                                Text to Speech Message
                                            </label>
                                        </div>
                                    </div>
                                    <div class="form-group call_flow_first_message" id="is_first_default_message">
                                        
                                        <div>
                                            <audio id="first_default_message_audio" controls preload="auto">
                                            <source src="../../audio_messages/Welcome-to-Our-Home.wav" type="audio/wav">
                                            Your browser does not support the audio element.
                                            </audio>
                                        </div>
                                    </div>

                                    <div class="form-group call_flow_first_message showHide" id="is_first_upload_audio">
                                        <input type="file" id="is_first_upload_audio_field" name="call_flow_first_audio_field" accept=".wav, .mp4" onchange="upload_file_call_flow('is_first_upload_audio_field', 'call_flow_first_audio_message')" class="form-control">
                                        <input type="hidden" name="is_first_upload_audio_field_hidden" id="is_first_upload_audio_field_hidden">
                                        <div>
                                            <audio class="showHide" id="is_first_upload_audio_field_audio" controls>    </audio>
                                        </div>
                                        <div id="call_flow_first_audio_message">
                                            <p class="badge badge-info file_format_msg">Please upload a .wav or .mp4 file</p>
                                        </div>
                                    </div>

                                    <div class="form-group call_flow_first_message showHide" id="is_first_record_audio">
                                        <button type="button" class="btn btn-primary" id="call_flow_first_start_btn" onclick="start_audio('call_flow_first_start_btn', 'call_flow_first_stop_btn', 'call_flow_first_audio_play_back', 'is_first_record_audio_field')">Start Recording</button>
                                        <button type="button" class="btn btn-success" id="call_flow_first_stop_btn" onclick="stop_audio('call_flow_first_start_btn', 'call_flow_first_stop_btn', 'call_flow_first_audio_play_back', 'is_first_record_audio_field')" disabled>Stop Recording</button>
                                        <div>
                                            <div>
                                                <audio class="showHide" id="call_flow_first_audio_play_back" controls>  </audio>
                                            </div>
                                        </div>
                                        <input type="hidden" id="is_first_record_audio_field" name="call_flow_first_audio_audio_data">
                                        <input type="hidden" id="update_first_record_audio_field" name="update_first_record_audio_field">
                                        <p class="error_message_call_flow" id="is_first_record_audio_message"></p>
                                    </div>

                                    <div class="form-group call_flow_first_message showHide" id="is_first_textto_speech">
                                        <div>
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" id="first_message_vocie_select_man" name="first_message_vocie_select" checked="" value="man">
                                                <label for="first_message_vocie_select_man">
                                                    Man &nbsp; &nbsp;
                                                </label>
                                            </div>
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" id="first_message_vocie_select_woman" name="first_message_vocie_select" value="woman">
                                                <label for="first_message_vocie_select_woman">
                                                    Woman &nbsp; &nbsp;
                                                </label>
                                            </div>
                                        </div>
                                        <br>
                                        <input type="text" id="is_first_textto_speech_field" name="is_first_textto_speech_field" class="form-control" placeholder="Enter your message here...">
                                        <p class="error_message_call_flow" id="is_first_textto_speech_message"></p>
                                    </div>
                                    <div class="form_group">
                                        <label>3. If no response after 20 seconds say:</label>
                                    </div>
                                    <div class="form-group">
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" id="radioPrimary4" name="call_flow_first_end_message" onchange="change_radio(this.value, 'call_flow_first_end_message')" checked="" value="is_no_response_default_message" />
                                            <label for="radioPrimary4">
                                                Default Message &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" onchange="change_radio(this.value, 'call_flow_first_end_message')" id="radioPrimary35" name="call_flow_first_end_message" value="is_no_response_upload_audio">
                                            <label for="radioPrimary35">
                                                Upload Audio &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" id="radioPrimary5" name="call_flow_first_end_message" onchange="change_radio(this.value, 'call_flow_first_end_message')" value="is_no_response_record_audio">
                                            <label for="radioPrimary5">
                                                Record Audio &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" id="radioPrimary6" name="call_flow_first_end_message" onchange="change_radio(this.value, 'call_flow_first_end_message')" value="is_no_response_textto_speech">
                                            <label for="radioPrimary6">
                                                Text to Speech Message
                                            </label>
                                        </div>

                                    </div>
                                    <div class="form-group call_flow_first_end_message" id="is_no_response_default_message">
                                        <div>
                                            <audio id="no_response_default_message_audio" controls>
                                            <source src="../../audio_messages/good_bye.wav" type="audio/wav">
                                            Your browser does not support the audio element.
                                            </audio>
                                        </div>
                                    </div>

                                    <div class="form-group call_flow_first_end_message showHide" id="is_no_response_upload_audio">
                                        <input type="file" id="is_no_response_upload_audio_field" name="is_no_response_upload_audio_field" accept=".wav, .mp4" onchange="upload_file_call_flow('is_no_response_upload_audio_field', 'call_flow_first_end_audio_message')" class="form-control">
                                        <div>
                                            <audio class="showHide" id="is_no_response_upload_audio_field_audio" controls>  </audio>
                                        </div>

                                        <input type="hidden" name="is_no_response_upload_audio_field_hidden" id="is_no_response_upload_audio_field_hidden">
                                        <div id="call_flow_first_end_audio_message">
                                            <p class="badge badge-info file_format_msg">Please upload a .wav or .mp4 file</p>
                                        </div>
                                    </div>

                                    <div class="form-group call_flow_first_end_message showHide" id="is_no_response_record_audio">
                                        <button type="button" class="btn btn-primary" id="call_flow_first_end_start_btn" onclick="start_audio('call_flow_first_end_start_btn', 'call_flow_first_end_stop_btn', 'call_flow_first_end_audio_play_back', 'is_no_response_record_audio_field')">Start Recording</button>
                                        <button type="button" class="btn btn-success" id="call_flow_first_end_stop_btn" onclick="stop_audio('call_flow_first_end_start_btn', 'call_flow_first_stop_btn', 'call_flow_first_end_audio_play_back', 'is_no_response_record_audio_field')" disabled>Stop Recording</button>
                                        <div>
                                            <audio class="showHide" id="call_flow_first_end_audio_play_back" controls>  </audio>
                                        </div>
                                        <input type="hidden" id="is_no_response_record_audio_field" name="call_flow_first_end_audio_audio_data">
                                        <input type="hidden" id="is_no_response_record_audio_field_hidden" name="is_no_response_record_audio_field_hidden">
                                        <p class="error_message_call_flow" id="is_no_response_record_audio_message"></p>
                                    </div>

                                    <div class="form-group call_flow_first_end_message showHide" id="is_no_response_textto_speech">
                                        <div>
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" id="no_response_vocie_select_man" name="no_response_vocie_select" checked="" value="man">
                                                <label for="no_response_vocie_select_man">
                                                    Man &nbsp; &nbsp;
                                                </label>
                                            </div>
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" id="no_response_vocie_select_woman" name="no_response_vocie_select" value="woman">
                                                <label for="no_response_vocie_select_woman">
                                                    Woman &nbsp; &nbsp;
                                                </label>
                                            </div>
                                        </div>
                                        <br>
                                        <input type="text" id="is_no_response_textto_speech_field" name="is_no_response_textto_speech_field" class="form-control" placeholder="Enter your message here...">
                                        <p class="error_message_call_flow" id="is_no_response_textto_speech_message"></p>
                                    </div>
                                    <label>and end call </label>
                                    <div class="form-group">
                                        <label>4. If they hang up:</label>
                                    </div>
                                    <div class="form-group">
                                        <div class="icheck-primary">
                                            <input type="radio" id="radioPrimary7" name="is_hang_up_message" checked="" value="0" />
                                            <label for="radioPrimary7">
                                                Do Not send an SMS to me &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary">
                                            <input type="radio" id="radioPrimary8" name="is_hang_up_message" value="1">
                                            <label for="radioPrimary8">
                                                Send an SMS to me &nbsp; &nbsp;
                                            </label>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label>5. If they press 2:</label>
                                    </div>
                                    <div class="form-group">
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" id="radioPrimary41" name="press2_message" onchange="change_radio(this.value, 'call_flow_press2_message')" checked="" value="press2_default_message" />
                                            <label for="radioPrimary41">
                                                Default Message &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" onchange="change_radio(this.value, 'call_flow_press2_message')" id="radioPrimary42" name="press2_message" value="press2_upload_audio">
                                            <label for="radioPrimary42">
                                                Upload Audio &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" id="radioPrimary43" name="press2_message" onchange="change_radio(this.value, 'call_flow_press2_message')" value="press2_record_audio">
                                            <label for="radioPrimary43">
                                                Record Audio &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" id="radioPrimary44" name="press2_message" onchange="change_radio(this.value, 'call_flow_press2_message')" value="press2_textto_speech">
                                            <label for="radioPrimary44">
                                                Text to Speech Message
                                            </label>
                                        </div>

                                    </div>
                                    <div class="form-group call_flow_press2_message" id="press2_default_message">
                                        <div>
                                            <audio id="press2_default_message_audio" controls>
                                            <source src="../../audio_messages/enter_your_code_now.wav" type="audio/wav">
                                            Your browser does not support the audio element.
                                            </audio>
                                        </div>
                                    </div>

                                    <div class="form-group call_flow_press2_message showHide" id="press2_upload_audio">
                                        <input type="file" id="press2_upload_audio_field" name="press2_upload_audio_field" accept=".wav, .mp4" onchange="upload_file_call_flow('press2_upload_audio_field', 'press2_audio_message')" class="form-control">
                                        <div>
                                            <audio class="showHide" id="press2_upload_audio_field_audio" controls>  </audio>
                                        </div>

                                        <input type="hidden" name="press2_upload_audio_field_hidden" id="press2_upload_audio_field_hidden">
                                        <div id="press2_audio_message">
                                            <p class="badge badge-info file_format_msg">Please upload a .wav or .mp4 file</p>
                                        </div>
                                    </div>

                                    <div class="form-group call_flow_press2_message showHide" id="press2_record_audio">
                                        <button type="button" class="btn btn-primary" id="press2_start_btn" onclick="start_audio('press2_start_btn', 'press2_stop_btn', 'press2_audio_play_back', 'press2_record_audio_field')">Start Recording</button>
                                        <button type="button" class="btn btn-success" id="press2_stop_btn" onclick="stop_audio('press2_start_btn', 'press2_stop_btn', 'press2_audio_play_back', 'press2_record_audio_field')" disabled>Stop Recording</button>
                                        <div>
                                            <audio class="showHide" id="press2_audio_play_back" controls>   </audio>
                                        </div>
                                        <input type="hidden" id="press2_record_audio_field" name="press2_audio_audio_data">
                                        <input type="hidden" id="press2_record_audio_field_hidden" name="press2_record_audio_field_hidden">
                                        <p class="error_message_call_flow" id="press2_record_audio_message"></p>
                                    </div>

                                    <div class="form-group call_flow_press2_message showHide" id="press2_textto_speech">
                                        <div>
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" id="press2_vocie_select_man" name="press2_vocie_select" checked="" value="man">
                                                <label for="press2_vocie_select_man">
                                                    Man &nbsp; &nbsp;
                                                </label>
                                            </div>
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" id="press2_vocie_select_woman" name="press2_vocie_select" value="woman">
                                                <label for="press2_vocie_select_woman">
                                                    Woman &nbsp; &nbsp;
                                                </label>
                                            </div>
                                        </div>
                                        <br>
                                        <input type="text" id="press2_textto_speech_field" name="press2_textto_speech_field" class="form-control" placeholder="Enter your message here...">
                                        <p class="error_message_call_flow" id="press2_textto_speech_message"></p>
                                    </div>

                                    <div class="form-group">
                                        <label>6. If they use an authorized code:</label>
                                    </div>

                                    <div class="form-group">
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" id="radioPrimary45" name="press2_auth_code_message" onchange="change_radio(this.value, 'press2_auth_code_message')" checked="" value="press2_auth_code_default_message" />
                                            <label for="radioPrimary45">
                                                Default Message &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" onchange="change_radio(this.value, 'press2_auth_code_message')" id="radioPrimary46" name="press2_auth_code_message" value="press2_auth_code_upload_audio">
                                            <label for="radioPrimary46">
                                                Upload Audio &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" id="radioPrimary47" name="press2_auth_code_message" onchange="change_radio(this.value, 'press2_auth_code_message')" value="press2_auth_code_record_audio">
                                            <label for="radioPrimary47">
                                                Record Audio &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" id="radioPrimary48" name="press2_auth_code_message" onchange="change_radio(this.value, 'press2_auth_code_message')" value="press2_auth_code_textto_speech">
                                            <label for="radioPrimary48">
                                                Text to Speech Message
                                            </label>
                                        </div>

                                    </div>
                                    <div class="form-group press2_auth_code_message" id="press2_auth_code_default_message">
                                        <div>
                                            <audio id="press2_auth_code_default_message_audio" controls>
                                            <source src="../../audio_messages/please_hold.wav" type="audio/wav">
                                            Your browser does not support the audio element.
                                            </audio>
                                        </div>
                                    </div>

                                    <div class="form-group press2_auth_code_message showHide" id="press2_auth_code_upload_audio">
                                        <input type="file" id="press2_upload_audio_field" name="press2_auth_code_upload_audio_field" accept=".wav, .mp4" onchange="upload_file_call_flow('press2_auth_code_upload_audio_field', 'press2_auth_code_audio_message')" class="form-control">
                                        <div>
                                            <audio class="showHide" id="press2_auth_code_upload_audio_field_audio" controls>    </audio>
                                        </div>

                                        <input type="hidden" name="press2_auth_code_upload_audio_field_hidden" id="press2_auth_code_upload_audio_field_hidden">
                                        <div id="press2_auth_code_audio_message">
                                            <p class="badge badge-info file_format_msg">Please upload a .wav or .mp4 file</p>
                                        </div>
                                    </div>

                                    <div class="form-group press2_auth_code_message showHide" id="press2_auth_code_record_audio">
                                        <button type="button" class="btn btn-primary" id="press2_auth_code_start_btn" onclick="start_audio('press2_auth_code_start_btn', 'press2_auth_code_stop_btn', 'press2_auth_code_audio_play_back', 'press2_auth_code_record_audio_field')">Start Recording</button>
                                        <button type="button" class="btn btn-success" id="press2_auth_code_stop_btn" onclick="stop_audio('press2_auth_code_start_btn', 'press2_auth_code_stop_btn', 'press2_auth_code_audio_play_back', 'press2_auth_code_record_audio_field')" disabled>Stop Recording</button>
                                        <div>
                                            <audio class="showHide" id="press2_auth_code_audio_play_back" controls> </audio>
                                        </div>
                                        <input type="hidden" id="press2_auth_code_record_audio_field" name="press2_auth_code_audio_audio_data">
                                        <input type="hidden" id="press2_auth_code_record_audio_field_hidden" name="press2_auth_code_record_audio_field_hidden">
                                        <p class="error_message_call_flow" id="press2_auth_code_record_audio_message"></p>
                                    </div>

                                    <div class="form-group press2_auth_code_message showHide" id="press2_auth_code_textto_speech">
                                        <div>
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" id="press2_auth_vocie_select_man" name="press2_auth_vocie_select" checked="" value="man">
                                                <label for="press2_auth_vocie_select_man">
                                                    Man &nbsp; &nbsp;
                                                </label>
                                            </div>
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" id="press2_auth_vocie_select_woman" name="press2_auth_vocie_select" value="woman">
                                                <label for="press2_auth_vocie_select_woman">
                                                    Woman &nbsp; &nbsp;
                                                </label>
                                            </div>
                                        </div>
                                        <br>
                                        <input type="text" id="press2_auth_code_textto_speech_field" name="press2_auth_code_textto_speech_field" class="form-control" placeholder="Enter your message here...">
                                        <p class="error_message_call_flow" id="press2_auth_code_textto_speech_message"></p>
                                    </div>

                                    <div class="form-group">
                                        <label>7. Acknowledge authorized code received:</label>
                                    </div>

                                    <div class="form-group">
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" id="radioPrimary49" name="press2_auth_code_ack_message" onchange="change_radio(this.value, 'press2_auth_code_ack_message')" checked="" value="press2_auth_code_ack_default_message" />
                                            <label for="radioPrimary49">
                                                Default Message &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" onchange="change_radio(this.value, 'press2_auth_code_ack_message')" id="radioPrimary50" name="press2_auth_code_ack_message" value="press2_auth_code_ack_upload_audio">
                                            <label for="radioPrimary50">
                                                Upload Audio &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" id="radioPrimary51" name="press2_auth_code_ack_message" onchange="change_radio(this.value, 'press2_auth_code_ack_message')" value="press2_auth_code_ack_record_audio">
                                            <label for="radioPrimary51">
                                                Record Audio &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" id="radioPrimary52" name="press2_auth_code_ack_message" onchange="change_radio(this.value, 'press2_auth_code_ack_message')" value="press2_auth_code_ack_textto_speech">
                                            <label for="radioPrimary52">
                                                Text to Speech Message
                                            </label>
                                        </div>

                                    </div>
                                    <div class="form-group press2_auth_code_ack_message" id="press2_auth_code_ack_default_message">
                                        <div>
                                            <audio id="press2_auth_code_ack_default_message_audio" controls>
                                            <source src="../../audio_messages/open_command_sent.wav" type="audio/wav">
                                            Your browser does not support the audio element.
                                            </audio>
                                        </div>
                                    </div>

                                    <div class="form-group press2_auth_code_ack_message showHide" id="press2_auth_code_ack_upload_audio">
                                        <input type="file" id="press2_auth_code_ack_upload_audio_field" name="press2_auth_code_ack_upload_audio_field" accept=".wav, .mp4" onchange="upload_file_call_flow('press2_auth_code_ack_upload_audio_field', 'press2_auth_code_ack_audio_message')" class="form-control">
                                        <div>
                                            <audio class="showHide" id="press2_auth_code_ack_upload_audio_field_audio" controls>    </audio>
                                        </div>

                                        <input type="hidden" name="press2_auth_code_ack_upload_audio_field_hidden" id="press2_auth_code_ack_upload_audio_field_hidden">
                                        <div id="press2_auth_code_ack_audio_message">
                                            <p class="badge badge-info file_format_msg">Please upload a .wav or .mp4 file</p>
                                        </div>
                                    </div>

                                    <div class="form-group press2_auth_code_ack_message showHide" id="press2_auth_code_ack_record_audio">
                                        <button type="button" class="btn btn-primary" id="press2_auth_code_ack_start_btn" onclick="start_audio('press2_auth_code_ack_start_btn', 'press2_auth_code_ack_stop_btn', 'press2_auth_code_ack_audio_play_back', 'press2_auth_code_ack_record_audio_field')">Start Recording</button>
                                        <button type="button" class="btn btn-success" id="press2_auth_code_ack_stop_btn" onclick="stop_audio('press2_auth_code_ack_start_btn', 'press2_auth_code_ack_stop_btn', 'press2_auth_code_ack_audio_play_back', 'press2_auth_code_ack_record_audio_field')" disabled>Stop Recording</button>
                                        <div>
                                            <audio class="showHide" id="press2_auth_code_ack_audio_play_back" controls> </audio>
                                        </div>
                                        <input type="hidden" id="press2_auth_code_ack_record_audio_field" name="press2_auth_code_ack_audio_audio_data">
                                        <input type="hidden" id="press2_auth_code_ack_record_audio_field_hidden" name="press2_auth_code_ack_record_audio_field_hidden">
                                        <p class="error_message_call_flow" id="press2_auth_code_ack_record_audio_message"></p>
                                    </div>

                                    <div class="form-group press2_auth_code_ack_message showHide" id="press2_auth_code_ack_textto_speech">
                                        <div>
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" id="press2_auth_ack_vocie_select_man" name="press2_auth_ack_vocie_select" checked="" value="man">
                                                <label for="press2_auth_ack_vocie_select_man">
                                                    Man &nbsp; &nbsp;
                                                </label>
                                            </div>
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" id="press2_auth_ack_vocie_select_woman" name="press2_auth_ack_vocie_select" value="woman">
                                                <label for="press2_auth_ack_vocie_select_woman">
                                                    Woman &nbsp; &nbsp;
                                                </label>
                                            </div>
                                        </div>
                                        <br>
                                        <input type="text" id="press2_auth_code_ack_textto_speech_field" name="press2_auth_code_ack_textto_speech_field" class="form-control" placeholder="Enter your message here...">
                                        <p class="error_message_call_flow" id="press2_auth_code_ack_textto_speech_message"></p>
                                    </div>

                                    <div class="form-group">
                                        <label>8. If access granted:</label>
                                    </div>

                                    <div class="form-group">
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" id="radioPrimary53" name="press2_auth_code_access_message" onchange="change_radio(this.value, 'press2_auth_code_access_message')" checked="" value="press2_auth_code_access_default_message" />
                                            <label for="radioPrimary53">
                                                Default Message &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" onchange="change_radio(this.value, 'press2_auth_code_access_message')" id="radioPrimary54" name="press2_auth_code_access_message" value="press2_auth_code_access_upload_audio">
                                            <label for="radioPrimary54">
                                                Upload Audio &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" id="radioPrimary55" name="press2_auth_code_access_message" onchange="change_radio(this.value, 'press2_auth_code_access_message')" value="press2_auth_code_access_record_audio">
                                            <label for="radioPrimary55">
                                                Record Audio &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" id="radioPrimary56" name="press2_auth_code_access_message" onchange="change_radio(this.value, 'press2_auth_code_access_message')" value="press2_auth_code_access_textto_speech">
                                            <label for="radioPrimary56">
                                                Text to Speech Message
                                            </label>
                                        </div>

                                    </div>
                                    <div class="form-group press2_auth_code_access_message" id="press2_auth_code_access_default_message">
                                        <div>
                                            <audio id="press2_auth_code_access_default_message_audio" controls>
                                            <source src="../../audio_messages/access_granted.wav" type="audio/wav">
                                            Your browser does not support the audio element.
                                            </audio>
                                        </div>
                                    </div>

                                    <div class="form-group press2_auth_code_access_message showHide" id="press2_auth_code_access_upload_audio">
                                        <input type="file" id="press2_auth_code_access_upload_audio_field" name="press2_auth_code_access_upload_audio_field" accept=".wav, .mp4" onchange="upload_file_call_flow('press2_auth_code_access_upload_audio_field', 'press2_auth_code_access_audio_message')" class="form-control">
                                        <div>
                                            <audio class="showHide" id="press2_auth_code_access_upload_audio_field_audio" controls> </audio>
                                        </div>

                                        <input type="hidden" name="press2_auth_code_access_upload_audio_field_hidden" id="press2_auth_code_access_upload_audio_field_hidden">
                                        <div id="press2_auth_code_access_audio_message">
                                            <p class="badge badge-info file_format_msg">Please upload a .wav or .mp4 file</p>
                                        </div>
                                    </div>

                                    <div class="form-group press2_auth_code_access_message showHide" id="press2_auth_code_access_record_audio">
                                        <button type="button" class="btn btn-primary" id="press2_auth_code_access_start_btn" onclick="start_audio('press2_auth_code_access_start_btn', 'press2_auth_code_access_stop_btn', 'press2_auth_code_access_audio_play_back', 'press2_auth_code_access_record_audio_field')">Start Recording</button>
                                        <button type="button" class="btn btn-success" id="press2_auth_code_access_stop_btn" onclick="stop_audio('press2_auth_code_access_start_btn', 'press2_auth_code_access_stop_btn', 'press2_auth_code_access_audio_play_back', 'press2_auth_code_access_record_audio_field')" disabled>Stop Recording</button>
                                        <div>
                                            <audio class="showHide" id="press2_auth_code_access_audio_play_back" controls>  </audio>
                                        </div>
                                        <input type="hidden" id="press2_auth_code_access_record_audio_field" name="press2_auth_code_access_audio_audio_data">
                                        <input type="hidden" id="press2_auth_code_access_record_audio_field_hidden" name="press2_auth_code_access_record_audio_field_hidden">
                                        <p class="error_message_call_flow" id="press2_auth_code_access_record_audio_message"></p>
                                    </div>

                                    <div class="form-group press2_auth_code_access_message showHide" id="press2_auth_code_access_textto_speech">
                                        <div>
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" id="press2_auth_access_vocie_select_man" name="press2_auth_access_vocie_select" checked="" value="man">
                                                <label for="press2_auth_access_vocie_select_man">
                                                    Man &nbsp; &nbsp;
                                                </label>
                                            </div>
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" id="press2_auth_access_vocie_select_woman" name="press2_auth_access_vocie_select" value="woman">
                                                <label for="press2_auth_access_vocie_select_woman">
                                                    Woman &nbsp; &nbsp;
                                                </label>
                                            </div>
                                        </div>
                                        <br>
                                        <input type="text" id="press2_auth_code_access_textto_speech_field" name="press2_auth_code_access_textto_speech_field" class="form-control" placeholder="Enter your message here...">
                                        <p class="error_message_call_flow" id="press2_auth_code_access_textto_speech_message"></p>
                                    </div>

                                    <div class="form-group">
                                        <label>9. If access denied:</label>
                                    </div>

                                    <div class="form-group">
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" id="radioPrimary57" name="press2_auth_code_denied_message" onchange="change_radio(this.value, 'press2_auth_code_denied_message')" checked="" value="press2_auth_code_denied_default_message" />
                                            <label for="radioPrimary57">
                                                Default Message &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" onchange="change_radio(this.value, 'press2_auth_code_denied_message')" id="radioPrimary58" name="press2_auth_code_denied_message" value="press2_auth_code_denied_upload_audio">
                                            <label for="radioPrimary58">
                                                Upload Audio &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" id="radioPrimary59" name="press2_auth_code_denied_message" onchange="change_radio(this.value, 'press2_auth_code_denied_message')" value="press2_auth_code_denied_record_audio">
                                            <label for="radioPrimary59">
                                                Record Audio &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" id="radioPrimary60" name="press2_auth_code_denied_message" onchange="change_radio(this.value, 'press2_auth_code_denied_message')" value="press2_auth_code_denied_textto_speech">
                                            <label for="radioPrimary60">
                                                Text to Speech Message
                                            </label>
                                        </div>

                                    </div>
                                    <div class="form-group press2_auth_code_denied_message" id="press2_auth_code_denied_default_message">
                                        <div>
                                            <audio id="press2_auth_code_denied_default_message_audio" controls>
                                            <source src="../../audio_messages/access_denied.wav" type="audio/wav">
                                            Your browser does not support the audio element.
                                            </audio>
                                        </div>
                                    </div>

                                    <div class="form-group press2_auth_code_denied_message showHide" id="press2_auth_code_denied_upload_audio">
                                        <input type="file" id="press2_auth_code_denied_upload_audio_field" name="press2_auth_code_denied_upload_audio_field" accept=".wav, .mp4" onchange="upload_file_call_flow('press2_auth_code_denied_upload_audio_field', 'press2_auth_code_denied_audio_message')" class="form-control">
                                        <div>
                                            <audio class="showHide" id="press2_auth_code_denied_upload_audio_field_audio" controls> </audio>
                                        </div>

                                        <input type="hidden" name="press2_auth_code_denied_upload_audio_field_hidden" id="press2_auth_code_denied_upload_audio_field_hidden">
                                        <div id="press2_auth_code_denied_audio_message">
                                            <p class="badge badge-info file_format_msg">Please upload a .wav or .mp4 file</p>
                                        </div>
                                    </div>

                                    <div class="form-group press2_auth_code_denied_message showHide" id="press2_auth_code_denied_record_audio">
                                        <button type="button" class="btn btn-primary" id="press2_auth_code_denied_start_btn" onclick="start_audio('press2_auth_code_denied_start_btn', 'press2_auth_code_denied_stop_btn', 'press2_auth_code_denied_audio_play_back', 'press2_auth_code_denied_record_audio_field')">Start Recording</button>
                                        <button type="button" class="btn btn-success" id="press2_auth_code_denied_stop_btn" onclick="stop_audio('press2_auth_code_denied_start_btn', 'press2_auth_code_denied_stop_btn', 'press2_auth_code_denied_audio_play_back', 'press2_auth_code_denied_record_audio_field')" disabled>Stop Recording</button>
                                        <div>
                                            <audio class="showHide" id="press2_auth_code_denied_audio_play_back" controls>  </audio>
                                        </div>
                                        <input type="hidden" id="press2_auth_code_denied_record_audio_field" name="press2_auth_code_denied_audio_audio_data">
                                        <input type="hidden" id="press2_auth_code_denied_record_audio_field_hidden" name="press2_auth_code_denied_record_audio_field_hidden">
                                        <p class="error_message_call_flow" id="press2_auth_code_denied_record_audio_message"></p>
                                    </div>

                                    <div class="form-group press2_auth_code_denied_message showHide" id="press2_auth_code_denied_textto_speech">
                                        <div>
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" id="press2_auth_denied_vocie_select_man" name="press2_auth_denied_vocie_select" checked="" value="man">
                                                <label for="press2_auth_denied_vocie_select_man">
                                                    Man &nbsp; &nbsp;
                                                </label>
                                            </div>
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" id="press2_auth_denied_vocie_select_woman" name="press2_auth_denied_vocie_select" value="woman">
                                                <label for="press2_auth_denied_vocie_select_woman">
                                                    Woman &nbsp; &nbsp;
                                                </label>
                                            </div>
                                        </div>
                                        <br>
                                        <input type="text" id="press2_auth_code_denied_textto_speech_field" name="press2_auth_code_denied_textto_speech_field" class="form-control" placeholder="Enter your message here...">
                                        <p class="error_message_call_flow" id="press2_auth_code_denied_textto_speech_message"></p>
                                    </div>

                                    <div class="form-group">
                                        <div class="icheck-primary">
                                            <input type="radio" id="radioPrimary9" name="is_authorized_message" checked="" value="0" />
                                            <label for="radioPrimary9">
                                                Do Not send an SMS to me &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary">
                                            <input type="radio" id="radioPrimary10" name="is_authorized_message" value="1">
                                            <label for="radioPrimary10">
                                                Send an SMS to me &nbsp; &nbsp;
                                            </label>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label>10. If they press 1:</label>
                                    </div>
                                    <div class="form-group">
                                        <div class="icheck-primary">
                                            <input type="radio" id="radioPrimary11" name="is_pre_notify_message" checked="" value="0" />
                                            <label for="radioPrimary11">
                                                Do Not send an SMS Pre-Notify to me &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary">
                                            <input type="radio" id="radioPrimary12" name="is_pre_notify_message" value="1">
                                            <label for="radioPrimary12">
                                                Send an SMS to me Pre-Notify to me &nbsp; &nbsp;
                                            </label>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label>11. Play this message to visitor:</label>
                                    </div>
                                    <div class="form-group">
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" id="radioPrimary13" name="advertisement_first_message" onchange="change_radio(this.value, 'advertisement_first_message')" checked="" value="is_advertisement_default_message">
                                            <label for="radioPrimary13">
                                                Default Message &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" onchange="change_radio(this.value, 'advertisement_first_message')" id="radioPrimary36" name="advertisement_first_message" value="is_advertisement_upload_audio">
                                            <label for="radioPrimary36">
                                                Upload Audio &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" onchange="change_radio(this.value, 'advertisement_first_message')" id="radioPrimary14" name="advertisement_first_message" value="is_advertisement_record_audio">
                                            <label for="radioPrimary14">
                                                Record Audio &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" onchange="change_radio(this.value, 'advertisement_first_message')" id="radioPrimary15" name="advertisement_first_message" value="is_advertisement_textto_speech">
                                            <label for="radioPrimary15">
                                                Text to Speech Message
                                            </label>
                                        </div>
                                    </div>
                                    <div class="form-group advertisement_first_message" id="is_advertisement_default_message">
                                        <div>
                                            <audio id="adv_def_aud" controls>
                                            <source src="../../audio_messages/You-are-using-invisible-intercom-ADVERTSING.wav" type="audio/wav">
                                            Your browser does not support the audio element.
                                            </audio>
                                        </div>
                                    </div>

                                    <div class="form-group advertisement_first_message showHide" id="is_advertisement_upload_audio">
                                        <input type="file" id="is_advertisement_upload_audio_field" name="is_advertisement_upload_audio_field" accept=".wav, .mp4" onchange="upload_file_call_flow('is_advertisement_upload_audio_field', 'advertisement_first_audio_message')" class="form-control">
                                        <div>
                                            <audio class="showHide" id="adv_upload_file_aud" controls>  </audio>
                                        </div>

                                        <input type="hidden" name="adv_aud_file_hidden" id="adv_aud_file_hidden">
                                        <div id="advertisement_first_audio_message">
                                            <p class="badge badge-info file_format_msg">Please upload a .wav or .mp4 file</p>
                                        </div>
                                    </div>

                                    <div class="form-group advertisement_first_message showHide" id="is_advertisement_record_audio">
                                        <button type="button" class="btn btn-primary" id="advertisement_first_start_btn" onclick="start_audio('advertisement_first_start_btn', 'advertisement_first_stop_btn', 'advertisement_first_audio_play_back', 'is_advertisement_record_audio_field')">Start Recording</button>
                                        <button type="button" class="btn btn-success" id="advertisement_first_stop_btn" onclick="stop_audio('advertisement_first_start_btn', 'advertisement_first_stop_btn', 'advertisement_first_audio_play_back', 'is_advertisement_record_audio_field')" disabled>Stop Recording</button>
                                        <div>
                                            <audio class="showHide" id="advertisement_first_audio_play_back" controls>  </audio>
                                        </div>

                                        <input type="hidden" id="adv_rec_hidden" name="adv_rec_hidden">
                                        <input type="hidden" id="is_advertisement_record_audio_field" name="is_advertisement_record_audio_field">
                                        <p class="error_message_call_flow" id="is_advertisement_record_audio_message"></p>
                                    </div>

                                    <div class="form-group advertisement_first_message showHide" id="is_advertisement_textto_speech">
                                        <div>
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" id="advertisement_vocie_select_man" name="advertisement_vocie_select" checked="" value="man">
                                                <label for="advertisement_vocie_select_man">
                                                    Man &nbsp; &nbsp;
                                                </label>
                                            </div>
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" id="advertisement_vocie_select_woman" name="advertisement_vocie_select" value="woman">
                                                <label for="advertisement_vocie_select_woman">
                                                    Woman &nbsp; &nbsp;
                                                </label>
                                            </div>
                                        </div>
                                        <br>
                                        <input type="text" name="is_advertisement_textto_speech_field" id="is_advertisement_textto_speech_field" class="form-control" placeholder="Enter your message here...">
                                        <p class="error_message_call_flow" id="is_advertisement_textto_speech_message"></p>
                                    </div>


                                    <div class="form-group">
                                        <label>Call forwarded numbers:</label>
                                    </div>
                                    <div class="form-group">
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <label>First Number</label>
                                                <select id="first_owner_number" name="first_number" class="form-control select2 select2_icon">
                                                    
                                                </select>
                                                <br>
                                                <div class="icheck-success d-inline">
                                                    <input type="checkbox" name="first_number_disturb" id="checkboxSuccess1" value="1">
                                                    <label for="checkboxSuccess1">
                                                        Do not Disturb
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <label>Second Number</label>
                                                <select id="second_owner_number" name="second_number" class="form-control select2 select2_icon">
                                                </select>
                                                <!-- <input type="text" id="second_owner_number" name="second_number" class="form-control" placeholder="Format  +12345678901"> -->
                                                <br>
                                                <div class="icheck-success d-inline">
                                                    <input type="checkbox" name="second_number_disturb" id="checkboxSuccess2" value="1">
                                                    <label for="checkboxSuccess2">
                                                        Do not Disturb
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <label>Third Number</label>
                                                <select id="third_owner_number" name="third_number" class="form-control select2 select2_icon">
                                                    
                                                </select>
                                                <!-- <input type="text" id="third_owner_number" name="third_number" class="form-control" placeholder="Format  +12345678901"> -->
                                                <br>
                                                <div class="icheck-success d-inline">
                                                    <input type="checkbox" name="third_number_disturb" id="checkboxSuccess3" value="1">
                                                    <label for="checkboxSuccess3">
                                                        Do not Disturb
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    

                                    <div class="form-group">
                                        <label>12. When call is connected to me but I don't answer:</label>
                                    </div>
                                    <div class="form-group">
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" id="radioPrimary16" name="connect_to_me_message" onchange="change_radio(this.value, 'connect_me_first_message')" checked="" value="is_connected_no_answer_default_message">
                                            <label for="radioPrimary16">
                                                Default Message &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" onchange="change_radio(this.value, 'connect_me_first_message')" id="radioPrimary37" name="connect_to_me_message" value="is_connected_no_answer_upload_audio">
                                            <label for="radioPrimary37">
                                                Upload Audio &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" onchange="change_radio(this.value, 'connect_me_first_message')" id="radioPrimary17" name="connect_to_me_message" value="is_connected_no_answer_record_audio">
                                            <label for="radioPrimary17">
                                                Record Audio &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" onchange="change_radio(this.value, 'connect_me_first_message')" id="radioPrimary18" name="connect_to_me_message" value="is_connected_no_answer_textto_speech">
                                            <label for="radioPrimary18">
                                                Text to Speech Message
                                            </label>
                                        </div>
                                    </div>
                                    <div class="form-group connect_me_first_message" id="is_connected_no_answer_default_message">
                                        <div>
                                            <audio id="def_connect_aud" controls>
                                            <source src="../../audio_messages/no_one_available.wav" type="audio/wav">
                                            Your browser does not support the audio element.
                                            </audio>
                                        </div>
                                    </div>

                                    <div class="form-group connect_me_first_message showHide" id="is_connected_no_answer_upload_audio">
                                        <input type="file" id="is_connected_no_answer_upload_audio_field" name="is_connected_no_answer_upload_audio_field" accept=".wav, .mp4" onchange="upload_file_call_flow('is_connected_no_answer_upload_audio_field', 'connect_me_first_audio_message')" class="form-control">

                                        <div>
                                            <audio class="showHide" id="connect_upload_file_aud" controls>  </audio>
                                        </div>

                                        <input type="hidden" name="connect_aud_file_hidden" id="connect_aud_file_hidden">
                                        <div id="connect_me_first_audio_message">
                                            <p class="badge badge-info file_format_msg">Please upload a .wav or .mp4 file</p>
                                        </div>
                                    </div>

                                    <div class="form-group connect_me_first_message showHide" id="is_connected_no_answer_record_audio">
                                        <button type="button" class="btn btn-primary" id="connect_me_first_start_btn" onclick="start_audio('connect_me_first_start_btn', 'connect_me_first_stop_btn', 'connect_me_first_audio_play_back', 'is_connected_no_answer_record_audio_field')">Start Recording</button>
                                        <button type="button" class="btn btn-success" id="connect_me_first_stop_btn" onclick="stop_audio('connect_me_first_start_btn', 'connect_me_first_stop_btn', 'connect_me_first_audio_play_back', 'is_connected_no_answer_record_audio_field')" disabled>Stop Recording</button>
                                        <div>
                                            <audio class="showHide" id="connect_me_first_audio_play_back" controls> </audio>
                                        </div>

                                        <input type="hidden" id="connect_rec_hidden" name="connect_rec_hidden">
                                        <input type="hidden" id="is_connected_no_answer_record_audio_field" name="is_connected_no_answer_record_audio_field">
                                        <p class="error_message_call_flow" id="is_connected_no_answer_record_audio_message"></p>
                                    </div>

                                    <div class="form-group connect_me_first_message showHide" id="is_connected_no_answer_textto_speech">
                                        <div>
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" id="connected_no_answer_vocie_select_man" name="connected_no_answer_vocie_select" checked="" value="man">
                                                <label for="connected_no_answer_vocie_select_man">
                                                    Man &nbsp; &nbsp;
                                                </label>
                                            </div>
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" id="connected_no_answer_vocie_select_woman" name="connected_no_answer_vocie_select" value="woman">
                                                <label for="connected_no_answer_vocie_select_woman">
                                                    Woman &nbsp; &nbsp;
                                                </label>
                                            </div>
                                        </div>
                                        <br>
                                        <input type="text" id="is_connected_no_answer_textto_speech_field" name="is_connected_no_answer_textto_speech_field" class="form-control" placeholder="Enter your message here...">
                                        <p class="error_message_call_flow" id="is_connected_no_answer_textto_speech_message"></p>
                                    </div>
                                    <label>Then End the Call</label>
                                    <div class="form-group">
                                        <label>13. If I answer I can communicate with them call will end after below time</label>
                                    </div>
                                    <div class="form-group user_attend_call_time" id="user_attend_call_time">
                                        <input type="number" id="call_duration_after_user_connect" name="call_duration_after_user_connect" class="form-control call_duration_after_user_connect_field" placeholder="Please enter seconds" value="120">
                                        <p class="error_message_call_duration_after_user_connect" id="error_message_call_duration_after_user_connect"></p>
                                    </div>
                                    <div class="form-group">
                                        <label>14. If I hang up</label>
                                    </div>
                                    <div class="form-group">
                                        <div class="icheck-primary">
                                            <input type="radio" id="radioPrimary19" name="is_connected_hangeup_message" checked="" onchange="change_radio(this.value, 'hang_up_call_fun')" value="hang_up_message_play" />
                                            <label for="radioPrimary19">
                                                Message Played &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary">
                                            <input type="radio" id="radioPrimary20" name="is_connected_hangeup_message" onchange="change_radio(this.value, 'hang_up_call_fun')" value="hang_up_call_terminate">
                                            <label for="radioPrimary20">
                                                The call will just Terminate &nbsp; &nbsp;
                                            </label>
                                        </div>
                                    </div>
                                    <div class="hang_up_call_fun" id="hang_up_message_play">
                                        <div class="form-group ">
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" id="radioPrimary21" name="hang_up_record_audio" onchange="change_radio(this.value, 'hang_up_options')" checked="" value="is_connected_hangeup_default_message">
                                                <label for="radioPrimary21">
                                                    Default Message &nbsp; &nbsp;
                                                </label>
                                            </div>
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" onchange="change_radio(this.value, 'hang_up_options')" id="radioPrimary38" name="hang_up_record_audio" value="is_connected_hangeup_upload_audio">
                                                <label for="radioPrimary38">
                                                    Upload Audio &nbsp; &nbsp;
                                                </label>
                                            </div>
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" onchange="change_radio(this.value, 'hang_up_options')" id="radioPrimary22" name="hang_up_record_audio" value="is_connected_hangeup_record_audio">
                                                <label for="radioPrimary22">
                                                    Record Audio &nbsp; &nbsp;
                                                </label>
                                            </div>
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" onchange="change_radio(this.value, 'hang_up_options')" id="radioPrimary23" name="hang_up_record_audio" value="is_connected_hangeup_textto_speech">
                                                <label for="radioPrimary23">
                                                    Text to Speech Message
                                                </label>
                                            </div>
                                        </div>
                                        <div class="form-group hang_up_options" id="is_connected_hangeup_default_message">
                                            <div>
                                                <audio controls>
                                                <source id="hang_def_aud" src="../../audio_messages/access_denied.wav" type="audio/wav">
                                                Your browser does not support the audio element.
                                                </audio>
                                            </div>
                                        </div>

                                        <div class="form-group hang_up_options showHide" id="is_connected_hangeup_upload_audio">
                                            <input type="file" id="is_connected_hangeup_upload_audio_field" name="is_connected_hangeup_upload_audio_field" accept=".wav, .mp4" onchange="upload_file_call_flow('is_connected_hangeup_upload_audio_field', 'hang_up_first_audio_message')" class="form-control">

                                            <div>
                                                <audio class="showHide" id="hang_upload_file_aud" controls> </audio>
                                            </div>

                                            <input type="hidden" name="hang_aud_file_hidden" id="hang_aud_file_hidden">
                                            <div id="hang_up_first_audio_message">
                                                <p class="badge badge-info file_format_msg">Please upload a .wav or .mp4 file</p>
                                            </div>
                                        </div>

                                        <div class="form-group hang_up_options showHide" id="is_connected_hangeup_record_audio">
                                            <button type="button" class="btn btn-primary" id="hang_up_first_start_btn" onclick="start_audio('hang_up_first_start_btn', 'hang_up_first_stop_btn', 'hang_up_first_audio_play_back', 'is_connected_hangeup_record_audio_field')">Start Recording</button>
                                            <button type="button" class="btn btn-success" id="hang_up_first_stop_btn" onclick="stop_audio('hang_up_first_start_btn', 'hang_up_first_stop_btn', 'hang_up_first_audio_play_back', 'is_connected_hangeup_record_audio_field')" disabled>Stop Recording</button>
                                            <div>
                                                <audio class="showHide" id="hang_up_first_audio_play_back" controls>    </audio>
                                            </div>
                                            <input type="hidden" name="hang_rec_aud_hidden" id="hang_rec_aud_hidden">
                                            <input type="hidden" id="is_connected_hangeup_record_audio_field" name="is_connected_hangeup_record_audio_field">
                                            <p class="error_message_call_flow" id="is_connected_hangeup_record_audio_message"></p>
                                        </div>

                                        <div class="form-group hang_up_options showHide" id="is_connected_hangeup_textto_speech">
                                            <div>
                                                <div class="icheck-primary d-inline">
                                                    <input type="radio" id="connected_hangup_vocie_select_man" name="connected_hangup_vocie_select" checked="" value="man">
                                                    <label for="connected_hangup_vocie_select_man">
                                                        Man &nbsp; &nbsp;
                                                    </label>
                                                </div>
                                                <div class="icheck-primary d-inline">
                                                    <input type="radio" id="connected_hangup_vocie_select_woman" name="connected_hangup_vocie_select" value="woman">
                                                    <label for="connected_hangup_vocie_select_woman">
                                                        Woman &nbsp; &nbsp;
                                                    </label>
                                                </div>
                                            </div>
                                            <br>
                                            <input type="text" id="is_connected_hangeup_textto_speech_field" name="is_connected_hangeup_textto_speech_field" class="form-control" placeholder="Enter your message here...">
                                            <p class="error_message_call_flow" id="is_connected_hangeup_textto_speech_message"></p>
                                        </div>
                                    </div>
                                    <label>Then End the Call</label>
                                    <div class="form-group">
                                        <label>15. If I press * key on my phone</label><br>
                                    </div>
                                    <div class="form-group">
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" id="radioPrimary61" name="door_key_option" checked="" value="1" />
                                            <label for="radioPrimary61">
                                                Play door key options  &nbsp; &nbsp;
                                            </label>
                                        </div>
                                        <div class="icheck-primary d-inline">
                                            <input type="radio" id="radioPrimary62" name="door_key_option" value="0">
                                            <label for="radioPrimary62">
                                                Don't play with door key options &nbsp; &nbsp;
                                            </label>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label>16. If I press door key on my phone to grant access:</label><br>
                                        <div style="margin-left: 15px;">
                                            <label>17. A beep is heared acknowledging the tone open number was received:</label><br>
                                            <label>18. A message plays:</label>
                                        </div>
                                    </div>
                                    <div style="margin-left: 15px;">
                                        <div class="form-group ">
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" id="radioPrimary24" name="open_command_first_check" onchange="change_radio(this.value, 'open_command_options')" checked="" value="is_beep_default_message">
                                                <label for="radioPrimary24">
                                                    Default Message &nbsp; &nbsp;
                                                </label>
                                            </div>
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" onchange="change_radio(this.value, 'open_command_options')" id="radioPrimary39" name="open_command_first_check" value="is_beep_upload_audio">
                                                <label for="radioPrimary39">
                                                    Upload Audio &nbsp; &nbsp;
                                                </label>
                                            </div>
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" onchange="change_radio(this.value, 'open_command_options')" id="radioPrimary25" name="open_command_first_check" value="is_beep_record_audio">
                                                <label for="radioPrimary25">
                                                    Record Audio &nbsp; &nbsp;
                                                </label>
                                            </div>
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" onchange="change_radio(this.value, 'open_command_options')" id="radioPrimary26" name="open_command_first_check" value="is_beep_textto_speech">
                                                <label for="radioPrimary26">
                                                    Text to Speech Message
                                                </label>
                                            </div>
                                        </div>
                                        <div class="form-group open_command_options" id="is_beep_default_message">
                                            <div>
                                                <audio controls>
                                                <source id="beep_def_aud" src="../../audio_messages/open_command_sent.wav" type="audio/wav">
                                                Your browser does not support the audio element.
                                                </audio>
                                            </div>
                                        </div>

                                        <div class="form-group open_command_options showHide" id="is_beep_upload_audio">
                                            <input type="file" id="is_beep_upload_audio_field" name="is_beep_upload_audio_field" accept=".wav, .mp4" onchange="upload_file_call_flow('is_beep_upload_audio_field', 'open_command_first_audio_message')" class="form-control">

                                            <div>
                                                <audio class="showHide" id="beep_upload_file_aud" controls> </audio>
                                            </div>

                                            <input type="hidden" name="beep_aud_file_hidden" id="beep_aud_file_hidden">
                                            <div id="open_command_first_audio_message">
                                                <p class="badge badge-info file_format_msg">Please upload a .wav or .mp4 file</p>
                                            </div>
                                        </div>

                                        <div class="form-group open_command_options showHide" id="is_beep_record_audio">
                                            <button type="button" class="btn btn-primary" id="open_command_first_start_btn" onclick="start_audio('open_command_first_start_btn', 'open_command_first_stop_btn', 'open_command_first_audio_play_back', 'is_beep_record_audio_field')">Start Recording</button>
                                            <button type="button" class="btn btn-success" id="open_command_first_stop_btn" onclick="stop_audio('open_command_first_start_btn', 'open_command_first_stop_btn', 'open_command_first_audio_play_back', 'is_beep_record_audio_field')" disabled>Stop Recording</button>
                                            <div>
                                                <audio class="showHide" id="open_command_first_audio_play_back" controls>   </audio>
                                            </div>
                                            <input type="hidden" name="beep_aud_rec_hidden" id="beep_aud_rec_hidden">
                                            <input type="hidden" id="is_beep_record_audio_field" name="is_beep_record_audio_field">
                                            <p class="error_message_call_flow" id="is_beep_record_audio_message"></p>
                                        </div>

                                        <div class="form-group open_command_options showHide" id="is_beep_textto_speech">
                                            <div>
                                                <div class="icheck-primary d-inline">
                                                    <input type="radio" id="is_beep_vocie_select_man" name="is_beep_vocie_select" checked="" value="man">
                                                    <label for="is_beep_vocie_select_man">
                                                        Man &nbsp; &nbsp;
                                                    </label>
                                                </div>
                                                <div class="icheck-primary d-inline">
                                                    <input type="radio" id="is_beep_vocie_select_woman" name="is_beep_vocie_select" value="woman">
                                                    <label for="is_beep_vocie_select_woman">
                                                        Woman &nbsp; &nbsp;
                                                    </label>
                                                </div>
                                            </div>
                                            <br>
                                            <input type="text" id="is_beep_textto_speech_field" name="is_beep_textto_speech_field" class="form-control" placeholder="Enter your message here...">
                                            <p class="error_message_call_flow" id="is_beep_textto_speech_message"></p>
                                        </div>
                                        <div class="form-group">
                                            <label>19. The open command is sent to the door or gate.</label><br>
                                            <label>20. A message plays:</label>
                                        </div>

                                        <div class="form-group ">
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" id="radioPrimary27" name="access_first_options" onchange="change_radio(this.value, 'access_first_options')" checked="" value="is_access_default_message">
                                                <label for="radioPrimary27">
                                                    Default Message &nbsp; &nbsp;
                                                </label>
                                            </div>
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" onchange="change_radio(this.value, 'access_first_options')" id="radioPrimary40" name="access_first_options" value="is_access_upload_audio">
                                                <label for="radioPrimary40">
                                                    Upload Audio &nbsp; &nbsp;
                                                </label>
                                            </div>
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" onchange="change_radio(this.value, 'access_first_options')" id="radioPrimary28" name="access_first_options" value="is_access_record_audio">
                                                <label for="radioPrimary28">
                                                    Record Audio &nbsp; &nbsp;
                                                </label>
                                            </div>
                                            <div class="icheck-primary d-inline">
                                                <input type="radio" onchange="change_radio(this.value, 'access_first_options')" id="radioPrimary29" name="access_first_options" value="is_access_textto_speech">
                                                <label for="radioPrimary29">
                                                    Text to Speech Message
                                                </label>
                                            </div>
                                        </div>
                                        <div class="form-group access_first_options" id="is_access_default_message">
                                            <div>
                                                <audio controls>
                                                <source id="access_def_aud" src="../../audio_messages/You-may-now-access-the-property.wav" type="audio/wav">
                                                Your browser does not support the audio element.
                                                </audio>
                                            </div>
                                        </div>

                                        <div class="form-group access_first_options showHide" id="is_access_upload_audio">
                                            <input type="file" id="is_access_upload_audio_field" name="is_access_upload_audio_field" accept=".wav, .mp4" onchange="upload_file_call_flow('is_access_upload_audio_field', 'access_first_audio_message')" class="form-control">

                                            <div>
                                                <audio class="showHide" id="access_upload_file_aud" controls>   </audio>
                                            </div>

                                            <input type="hidden" name="access_aud_file_hidden" id="access_aud_file_hidden">
                                            <div id="access_first_audio_message">
                                                <p class="badge badge-info file_format_msg">Please upload a .wav or .mp4 file</p>
                                            </div>
                                        </div>

                                        <div class="form-group access_first_options showHide" id="is_access_record_audio">
                                            <button type="button" class="btn btn-primary" id="access_first_start_btn" onclick="start_audio('access_first_start_btn', 'access_first_stop_btn', 'access_first_audio_play_back', 'is_access_record_audio_field')">Start Recording</button>
                                            <button type="button" class="btn btn-success" id="access_first_stop_btn" onclick="stop_audio('access_first_start_btn', 'access_first_stop_btn', 'access_first_audio_play_back', 'is_access_record_audio_field')" disabled>Stop Recording</button>
                                            <div>
                                                <audio class="showHide" id="access_first_audio_play_back" controls> </audio>
                                            </div>

                                            <input type="hidden" name="access_rec_hidden" id="access_rec_hidden">
                                            <input type="hidden" id="is_access_record_audio_field" name="is_access_record_audio_field">
                                            <p class="error_message_call_flow" id="is_access_record_audio_message"></p>
                                        </div>

                                        <div class="form-group access_first_options showHide" id="is_access_textto_speech">
                                            <div>
                                                <div class="icheck-primary d-inline">
                                                    <input type="radio" id="is_access_vocie_select_man" name="is_access_vocie_select" checked="" value="man">
                                                    <label for="is_access_vocie_select_man">
                                                        Man &nbsp; &nbsp;
                                                    </label>
                                                </div>
                                                <div class="icheck-primary d-inline">
                                                    <input type="radio" id="is_access_vocie_select_woman" name="is_access_vocie_select" value="woman">
                                                    <label for="is_access_vocie_select_woman">
                                                        Woman &nbsp; &nbsp;
                                                    </label>
                                                </div>
                                            </div>
                                            <br>
                                            <input type="text" id="is_access_textto_speech_field" name="is_access_textto_speech_field" class="form-control" placeholder="Enter your message here...">
                                            <p class="error_message_call_flow" id="is_access_textto_speech_message"></p>
                                        </div>

                                        <div class="form-group">
                                            <div class="icheck-primary">
                                                <input type="radio" id="radioPrimary30" name="is_grant_access_detail_message" checked="" value="0" />
                                                <label for="radioPrimary30">
                                                    Do Not send an SMS to me for granted access &nbsp; &nbsp;
                                                </label>
                                            </div>
                                            <div class="icheck-primary">
                                                <input type="radio" id="radioPrimary31" name="is_grant_access_detail_message" value="1">
                                                <label for="radioPrimary31">
                                                    Send an SMS to me with granted access details. &nbsp; &nbsp;
                                                </label>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <div class="icheck-primary">
                                                <input type="radio" id="radioPrimary32" name="is_hang_up_call_terminate" checked="" value="1" onchange="change_radio('end_call_time_d', 'call_flow_end_time_call')" />
                                                <label for="radioPrimary32">
                                                    Call shall terminate when I grant access or hang up the call
                                                </label>
                                            </div>
                                            <div class="icheck-primary">
                                                <input type="radio" id="radioPrimary33" name="is_hang_up_call_terminate" value="0" onchange="change_radio('end_call_time_div', 'call_flow_end_time_call')">
                                                <label for="radioPrimary33">
                                                    I can stay on the call for up to below seconds to navigate my visitor.
                                                </label>
                                            </div>
                                            
                                                
                                        </div>
                                        <div class="form-group call_flow_end_time_call showHide" id="end_call_time_div">
                                            <input type="number" id="end_call_time_seconds" name="end_call_time" class="form-control" placeholder="Please enter seconds" value="120">
                                            <p class="end_call_time_message" id="end_call_time_message"></p>
                                        </div>

                                    </div>
                                    <input type="hidden" name="update_call_flow" id="update_call_flow" value="0">
                                    <input type="hidden" name="call_flow_id" id="call_flow_id" value="1">
                                    <input type="hidden" name="my_call_flow_data" value="call_flow">
                                    <div class="form-group">
                                        <button type="button" onclick="save_call_flow()" class="btn btn-primary">Save</button>
                                    </div>
                                </div>

                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade <?php echo $activeTab == 'qrcodes' ? 'show active' : ''; ?>" id="qrcodes" role="tabpanel" aria-labelledby="qrcodes-tab">
                <div class="py-3 px-1">
                    <div class="px-2" id="qr_code_content">
                        <div class="d-flex justify-content-center">
                            <div class="loader_image">
                                <img src="/include/images/loader.gif" alt="">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="tab-pane fade <?php echo $activeTab == 'settings' ? 'show active' : ''; ?>" id="settings" role="tabpanel" aria-labelledby="settings-tab">
                <div class="py-3 px-1">
                    <div class="px-2" id="settings_content">
                        <div class="d-flex justify-content-center">
                            <div class="loader_image">
                                <img src="/include/images/loader.gif" alt="">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="tab-pane fade <?php echo $activeTab == 'streets' ? 'show active' : ''; ?>" id="streets" role="tabpanel" aria-labelledby="streets-tab">
                <div class="py-3 px-1">
                    <div class="px-2" id="streets_content">
                        <div class="d-flex justify-content-center">
                            <div class="loader_image">
                                <img src="/include/images/loader.gif" alt="">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<script>
    $(".select2").select2();
    $( document ).ready(function() {
        var active_my_tab = $("#active_tab_val").val();
        if (active_my_tab == "callflow") {
            doorsGates();
        }
    });
</script>